/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.processor.execute;

import com.google.common.collect.Lists;
import com.tencent.supersonic.chat.server.pojo.ExecuteContext;
import com.tencent.supersonic.chat.server.processor.execute.ExecuteResultProcessor;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.RelatedSchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class DimensionRecommendProcessor
implements ExecuteResultProcessor {
    private static final int recommend_dimension_size = 5;

    @Override
    public void process(ExecuteContext executeContext, QueryResult queryResult) {
        SemanticParseInfo semanticParseInfo = executeContext.getParseInfo();
        if (!QueryType.METRIC.equals((Object)semanticParseInfo.getQueryType()) || CollectionUtils.isEmpty((Collection)semanticParseInfo.getMetrics())) {
            return;
        }
        SchemaElement element = (SchemaElement)semanticParseInfo.getMetrics().iterator().next();
        List<SchemaElement> dimensionRecommended = this.getDimensions(element.getId(), element.getDataSet());
        queryResult.setRecommendedDimensions(dimensionRecommended);
    }

    private List<SchemaElement> getDimensions(Long metricId, Long dataSetId) {
        Optional<SchemaElement> metric;
        SemanticLayerService semanticService = (SemanticLayerService)ContextUtils.getBean(SemanticLayerService.class);
        DataSetSchema dataSetSchema = semanticService.getDataSetSchema(dataSetId);
        List<Object> drillDownDimensions = Lists.newArrayList();
        Set metricElements = dataSetSchema.getMetrics();
        if (!CollectionUtils.isEmpty((Collection)metricElements) && (metric = metricElements.stream().filter(schemaElement -> metricId.equals(schemaElement.getId()) && !CollectionUtils.isEmpty((Collection)schemaElement.getRelatedSchemaElements())).findFirst()).isPresent()) {
            drillDownDimensions = metric.get().getRelatedSchemaElements().stream().map(RelatedSchemaElement::getDimensionId).collect(Collectors.toList());
        }
        ArrayList drillDownDimensionsFinal = drillDownDimensions;
        return dataSetSchema.getDimensions().stream().filter(dim -> this.filterDimension(drillDownDimensionsFinal, (SchemaElement)dim)).sorted(Comparator.comparing(SchemaElement::getUseCnt).reversed()).limit(5L).collect(Collectors.toList());
    }

    private boolean filterDimension(List<Long> drillDownDimensions, SchemaElement dimension) {
        if (Objects.isNull(dimension)) {
            return false;
        }
        if (!CollectionUtils.isEmpty(drillDownDimensions)) {
            return drillDownDimensions.contains(dimension.getId());
        }
        return Objects.nonNull(dimension.getUseCnt());
    }
}

