/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.processor.execute;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.server.pojo.ExecuteContext;
import com.tencent.supersonic.chat.server.processor.execute.ExecuteResultProcessor;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.common.pojo.enums.AggOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.RatioOverType;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.common.util.DateUtils;
import com.tencent.supersonic.headless.api.pojo.AggregateInfo;
import com.tencent.supersonic.headless.api.pojo.MetricInfo;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.chat.utils.QueryReqBuilder;
import com.tencent.supersonic.headless.core.config.AggregatorConfig;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import java.text.DecimalFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MetricRatioProcessor
implements ExecuteResultProcessor {
    private static final Logger log = LoggerFactory.getLogger(MetricRatioProcessor.class);

    @Override
    public void process(ExecuteContext executeContext, QueryResult queryResult) {
        SemanticParseInfo semanticParseInfo = executeContext.getParseInfo();
        AggregatorConfig aggregatorConfig = (AggregatorConfig)ContextUtils.getBean(AggregatorConfig.class);
        if (CollectionUtils.isEmpty((Collection)semanticParseInfo.getMetrics()) || !aggregatorConfig.getEnableRatio().booleanValue() || !QueryType.METRIC.equals((Object)semanticParseInfo.getQueryType())) {
            return;
        }
        AggregateInfo aggregateInfo = this.getAggregateInfo(executeContext.getUser(), semanticParseInfo, queryResult);
        queryResult.setAggregateInfo(aggregateInfo);
    }

    public AggregateInfo getAggregateInfo(User user, SemanticParseInfo semanticParseInfo, QueryResult queryResult) {
        HashSet resultMetricNames = new HashSet();
        queryResult.getQueryColumns().stream().forEach(c -> resultMetricNames.addAll(SqlSelectHelper.getColumnFromExpr((String)c.getNameEn())));
        Optional<SchemaElement> ratioMetric = semanticParseInfo.getMetrics().stream().filter(m -> resultMetricNames.contains(m.getBizName())).findFirst();
        AggregateInfo aggregateInfo = new AggregateInfo();
        if (!ratioMetric.isPresent()) {
            return aggregateInfo;
        }
        try {
            String dateField = QueryReqBuilder.getDateField((DateConf)semanticParseInfo.getDateInfo());
            Optional<String> lastDayOp = queryResult.getQueryResults().stream().filter(r -> r.containsKey(dateField)).map(r -> r.get(dateField).toString()).sorted(Comparator.reverseOrder()).findFirst();
            if (!lastDayOp.isPresent()) {
                return new AggregateInfo();
            }
            Optional<Map> lastValue = queryResult.getQueryResults().stream().filter(r -> r.get(dateField).toString().equals(lastDayOp.get())).findFirst();
            MetricInfo metricInfo = new MetricInfo();
            metricInfo.setStatistics(new HashMap());
            if (lastValue.isPresent() && lastValue.get().containsKey(ratioMetric.get().getBizName())) {
                DecimalFormat df = new DecimalFormat("#.####");
                metricInfo.setValue(df.format(lastValue.get().get(ratioMetric.get().getBizName())));
            }
            metricInfo.setDate(lastValue.get().get(dateField).toString());
            CompletableFuture<MetricInfo> metricInfoRoll = CompletableFuture.supplyAsync(() -> this.queryRatio(user, semanticParseInfo, (SchemaElement)ratioMetric.get(), AggOperatorEnum.RATIO_ROLL, queryResult));
            CompletableFuture<MetricInfo> metricInfoOver = CompletableFuture.supplyAsync(() -> this.queryRatio(user, semanticParseInfo, (SchemaElement)ratioMetric.get(), AggOperatorEnum.RATIO_OVER, queryResult));
            CompletableFuture.allOf(metricInfoRoll, metricInfoOver);
            metricInfo.setName(metricInfoRoll.get().getName());
            metricInfo.setValue(metricInfoRoll.get().getValue());
            metricInfo.getStatistics().putAll(metricInfoRoll.get().getStatistics());
            metricInfo.getStatistics().putAll(metricInfoOver.get().getStatistics());
            aggregateInfo.getMetricInfos().add(metricInfo);
        }
        catch (Exception e) {
            log.error("queryRatio error {}", (Throwable)e);
        }
        return aggregateInfo;
    }

    private MetricInfo queryRatio(User user, SemanticParseInfo semanticParseInfo, SchemaElement metric, AggOperatorEnum aggOperatorEnum, QueryResult queryResult) {
        QueryStructReq queryStructReq = QueryReqBuilder.buildStructRatioReq((SemanticParseInfo)semanticParseInfo, (SchemaElement)metric, (AggOperatorEnum)aggOperatorEnum);
        String dateField = QueryReqBuilder.getDateField((DateConf)semanticParseInfo.getDateInfo());
        queryStructReq.setGroups(new ArrayList<String>(Arrays.asList(dateField)));
        queryStructReq.setDateInfo(this.getRatioDateConf(aggOperatorEnum, semanticParseInfo, queryResult));
        queryStructReq.setConvertToSql(false);
        SemanticLayerService queryService = (SemanticLayerService)ContextUtils.getBean(SemanticLayerService.class);
        SemanticQueryResp queryResp = queryService.queryByReq((SemanticQueryReq)queryStructReq, user);
        MetricInfo metricInfo = new MetricInfo();
        metricInfo.setStatistics(new HashMap());
        if (Objects.isNull(queryResp) || CollectionUtils.isEmpty((Collection)queryResp.getResultList())) {
            return metricInfo;
        }
        Map result = (Map)queryResp.getResultList().get(0);
        Optional<QueryColumn> valueColumn = queryResp.getColumns().stream().filter(c -> c.getNameEn().equals(metric.getBizName())).findFirst();
        if (!valueColumn.isPresent()) {
            return metricInfo;
        }
        String valueField = String.format("%s_%s", valueColumn.get().getNameEn(), aggOperatorEnum.getOperator());
        if (result.containsKey(valueColumn.get().getNameEn())) {
            DecimalFormat df = new DecimalFormat("#.######");
            metricInfo.setValue(df.format(result.get(valueColumn.get().getNameEn())));
        }
        Object ratio = "";
        if (Objects.nonNull(result.get(valueField))) {
            ratio = String.format("%.2f", Double.valueOf(result.get(valueField).toString()) * 100.0) + "%";
        }
        String statisticsRollName = RatioOverType.DAY_ON_DAY.getShowName();
        String statisticsOverName = RatioOverType.WEEK_ON_DAY.getShowName();
        if ("MONTH".equals(semanticParseInfo.getDateInfo().getPeriod())) {
            statisticsRollName = RatioOverType.MONTH_ON_MONTH.getShowName();
            statisticsOverName = RatioOverType.YEAR_ON_MONTH.getShowName();
        }
        if ("WEEK".equals(semanticParseInfo.getDateInfo().getPeriod())) {
            statisticsRollName = RatioOverType.WEEK_ON_WEEK.getShowName();
            statisticsOverName = RatioOverType.MONTH_ON_WEEK.getShowName();
        }
        metricInfo.getStatistics().put(aggOperatorEnum.equals((Object)AggOperatorEnum.RATIO_ROLL) ? statisticsRollName : statisticsOverName, ratio);
        metricInfo.setName(metric.getName());
        return metricInfo;
    }

    private DateConf getRatioDateConf(AggOperatorEnum aggOperatorEnum, SemanticParseInfo semanticParseInfo, QueryResult queryResult) {
        Comparable<ChronoLocalDateTime<?>> end;
        DateTimeFormatter formatter;
        String dateField = QueryReqBuilder.getDateField((DateConf)semanticParseInfo.getDateInfo());
        Optional<String> lastDayOp = queryResult.getQueryResults().stream().map(r -> r.get(dateField).toString()).sorted(Comparator.reverseOrder()).findFirst();
        if (!lastDayOp.isPresent()) {
            return semanticParseInfo.getDateInfo();
        }
        String lastDay = lastDayOp.get();
        DateConf dateConf = new DateConf();
        dateConf.setPeriod(semanticParseInfo.getDateInfo().getPeriod());
        dateConf.setDateMode(DateConf.DateMode.LIST);
        ArrayList<String> dayList = new ArrayList<String>();
        dayList.add(lastDay);
        String start = "";
        if ("TIME".equalsIgnoreCase(semanticParseInfo.getDateInfo().getPeriod())) {
            formatter = DateUtils.getDateFormatter((String)lastDay, (String[])new String[]{"YYYYMMDD", "yyyy-MM-dd HH:mm:ss.S"});
            end = LocalDateTime.parse(lastDay, formatter);
            String string = start = aggOperatorEnum.equals((Object)AggOperatorEnum.RATIO_ROLL) ? ((LocalDateTime)end).minusDays(1L).format(formatter) : ((LocalDateTime)end).minusWeeks(1L).format(formatter);
        }
        if ("DAY".equalsIgnoreCase(semanticParseInfo.getDateInfo().getPeriod())) {
            formatter = DateUtils.getDateFormatter((String)lastDay, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
            if (lastDay.contains(":")) {
                lastDay = lastDay.trim().split(" ")[0];
            }
            end = LocalDate.parse(lastDay, formatter);
            String string = start = aggOperatorEnum.equals((Object)AggOperatorEnum.RATIO_ROLL) ? ((LocalDate)end).minusDays(1L).format(formatter) : ((LocalDate)end).minusWeeks(1L).format(formatter);
        }
        if ("WEEK".equalsIgnoreCase(semanticParseInfo.getDateInfo().getPeriod())) {
            formatter = DateUtils.getTimeFormatter((String)lastDay, (String[])new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "YYYYMMDD"});
            end = LocalDateTime.parse(lastDay, formatter);
            String string = start = aggOperatorEnum.equals((Object)AggOperatorEnum.RATIO_ROLL) ? ((LocalDateTime)end).minusWeeks(1L).format(formatter) : ((LocalDateTime)end).minusMonths(1L).with(DayOfWeek.MONDAY).format(formatter);
        }
        if ("MONTH".equalsIgnoreCase(semanticParseInfo.getDateInfo().getPeriod())) {
            formatter = DateUtils.getDateFormatter((String)lastDay, (String[])new String[]{"yyyy-MM", "YYYYMM"});
            end = YearMonth.parse(lastDay, formatter);
            start = aggOperatorEnum.equals((Object)AggOperatorEnum.RATIO_ROLL) ? ((YearMonth)end).minusMonths(1L).format(formatter) : ((YearMonth)end).minusYears(1L).format(formatter);
        }
        dayList.add(start);
        dateConf.setDateList(dayList);
        return dateConf;
    }
}

