/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.processor.parse;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.tencent.supersonic.chat.api.pojo.response.SimilarQueryRecallResp;
import com.tencent.supersonic.chat.server.persistence.dataobject.ChatQueryDO;
import com.tencent.supersonic.chat.server.persistence.repository.ChatQueryRepository;
import com.tencent.supersonic.chat.server.pojo.ParseContext;
import com.tencent.supersonic.chat.server.processor.parse.ParseResultProcessor;
import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.service.ExemplarService;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRecommendProcessor
implements ParseResultProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryRecommendProcessor.class);

    @Override
    public void process(ParseContext parseContext, ParseResp parseResp) {
        CompletableFuture.runAsync(() -> this.doProcess(parseResp, parseContext));
    }

    private void doProcess(ParseResp parseResp, ParseContext parseContext) {
        Long queryId = parseResp.getQueryId();
        List<SimilarQueryRecallResp> solvedQueries = this.getSimilarQueries(parseContext.getQueryText(), parseContext.getAgent().getId());
        ChatQueryDO chatQueryDO = this.getChatQuery(queryId);
        chatQueryDO.setSimilarQueries(JSONObject.toJSONString(solvedQueries));
        this.updateChatQuery(chatQueryDO);
    }

    public List<SimilarQueryRecallResp> getSimilarQueries(String queryText, Integer agentId) {
        ExemplarService exemplarService = (ExemplarService)ContextUtils.getBean(ExemplarService.class);
        EmbeddingConfig embeddingConfig = (EmbeddingConfig)ContextUtils.getBean(EmbeddingConfig.class);
        String memoryCollectionName = embeddingConfig.getMemoryCollectionName(agentId);
        List exemplars = exemplarService.recallExemplars(memoryCollectionName, queryText, 5);
        return exemplars.stream().map(sqlExemplar -> SimilarQueryRecallResp.builder().queryText(sqlExemplar.getQuestion()).build()).collect(Collectors.toList());
    }

    private ChatQueryDO getChatQuery(Long queryId) {
        ChatQueryRepository chatQueryRepository = (ChatQueryRepository)ContextUtils.getBean(ChatQueryRepository.class);
        return chatQueryRepository.getChatQueryDO(queryId);
    }

    private void updateChatQuery(ChatQueryDO chatQueryDO) {
        ChatQueryRepository chatQueryRepository = (ChatQueryRepository)ContextUtils.getBean(ChatQueryRepository.class);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"question_id", (Object)chatQueryDO.getQuestionId());
        updateWrapper.set((Object)"similar_queries", (Object)chatQueryDO.getSimilarQueries());
        chatQueryRepository.updateChatQuery(chatQueryDO, (UpdateWrapper<ChatQueryDO>)updateWrapper);
    }
}

