/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.chat.server.agent.Agent;
import com.tencent.supersonic.chat.server.agent.AgentToolType;
import com.tencent.supersonic.chat.server.service.AgentService;
import com.tencent.supersonic.chat.server.util.LLMConnHelper;
import com.tencent.supersonic.common.pojo.ChatModelConfig;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chat/agent", "/openapi/chat/agent"})
public class AgentController {
    @Autowired
    private AgentService agentService;

    @PostMapping
    public Agent createAgent(@RequestBody Agent agent, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        User user = UserHolder.findUser((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        return this.agentService.createAgent(agent, user);
    }

    @PutMapping
    public Agent updateAgent(@RequestBody Agent agent, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        User user = UserHolder.findUser((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        return this.agentService.updateAgent(agent, user);
    }

    @DeleteMapping(value={"/{id}"})
    public boolean deleteAgent(@PathVariable(value="id") Integer id) {
        this.agentService.deleteAgent(id);
        return true;
    }

    @PostMapping(value={"/testLLMConn"})
    public boolean testLLMConn(@RequestBody ChatModelConfig modelConfig) {
        return LLMConnHelper.testConnection(modelConfig);
    }

    @RequestMapping(value={"/getAgentList"})
    public List<Agent> getAgentList() {
        return this.agentService.getAgents();
    }

    @RequestMapping(value={"/getToolTypes"})
    public Map<AgentToolType, String> getToolTypes() {
        return AgentToolType.getToolTypes();
    }
}

