/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.api.pojo.request.ChatAggConfigReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatConfigBaseReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatConfigEditReqReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatConfigFilter;
import com.tencent.supersonic.chat.api.pojo.request.ChatDefaultConfigReq;
import com.tencent.supersonic.chat.api.pojo.request.ChatDetailConfigReq;
import com.tencent.supersonic.chat.api.pojo.request.Entity;
import com.tencent.supersonic.chat.api.pojo.request.ItemNameVisibilityInfo;
import com.tencent.supersonic.chat.api.pojo.request.ItemVisibility;
import com.tencent.supersonic.chat.api.pojo.request.KnowledgeInfoReq;
import com.tencent.supersonic.chat.api.pojo.response.ChatAggRichConfigResp;
import com.tencent.supersonic.chat.api.pojo.response.ChatConfigResp;
import com.tencent.supersonic.chat.api.pojo.response.ChatConfigRichResp;
import com.tencent.supersonic.chat.api.pojo.response.ChatDefaultRichConfigResp;
import com.tencent.supersonic.chat.api.pojo.response.ChatDetailRichConfigResp;
import com.tencent.supersonic.chat.api.pojo.response.EntityRichInfoResp;
import com.tencent.supersonic.chat.api.pojo.response.ItemVisibilityInfo;
import com.tencent.supersonic.chat.server.config.ChatConfig;
import com.tencent.supersonic.chat.server.persistence.repository.ChatConfigRepository;
import com.tencent.supersonic.chat.server.service.ConfigService;
import com.tencent.supersonic.chat.server.util.ChatConfigHelper;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigServiceImpl.class);
    private final ChatConfigRepository chatConfigRepository;
    private final ChatConfigHelper chatConfigHelper;
    private final DimensionService dimensionService;
    private final MetricService metricService;
    private final SemanticLayerService semanticLayerService;

    public ConfigServiceImpl(ChatConfigRepository chatConfigRepository, ChatConfigHelper chatConfigHelper, DimensionService dimensionService, MetricService metricService, SemanticLayerService semanticLayerService) {
        this.chatConfigRepository = chatConfigRepository;
        this.chatConfigHelper = chatConfigHelper;
        this.dimensionService = dimensionService;
        this.metricService = metricService;
        this.semanticLayerService = semanticLayerService;
    }

    @Override
    public Long addConfig(ChatConfigBaseReq configBaseCmd, User user) {
        log.info("[create model extend] object:{}", (Object)JsonUtil.toString((Object)configBaseCmd, (boolean)true));
        this.duplicateCheck(configBaseCmd.getModelId());
        ChatConfig chaConfig = this.chatConfigHelper.newChatConfig(configBaseCmd, user);
        return this.chatConfigRepository.createConfig(chaConfig);
    }

    private void duplicateCheck(Long modelId) {
        ChatConfigFilter filter = new ChatConfigFilter();
        filter.setModelId(modelId);
        List<ChatConfigResp> chaConfigDescList = this.chatConfigRepository.getChatConfig(filter);
        if (!CollectionUtils.isEmpty(chaConfigDescList)) {
            throw new RuntimeException("chat config existed, no need to add repeatedly");
        }
    }

    @Override
    public Long editConfig(ChatConfigEditReqReq configEditCmd, User user) {
        log.info("[edit model extend] object:{}", (Object)JsonUtil.toString((Object)configEditCmd, (boolean)true));
        if (Objects.isNull(configEditCmd) || Objects.isNull(configEditCmd.getId()) && Objects.isNull(configEditCmd.getModelId())) {
            throw new RuntimeException("editConfig, id and modelId are not allowed to be empty at the same time");
        }
        ChatConfig chaConfig = this.chatConfigHelper.editChatConfig(configEditCmd, user);
        this.chatConfigRepository.updateConfig(chaConfig);
        return configEditCmd.getId();
    }

    public ItemNameVisibilityInfo getVisibilityByModelId(Long modelId) {
        ChatConfigResp chatConfigResp = this.fetchConfigByModelId(modelId);
        ChatConfig chatConfig = new ChatConfig();
        chatConfig.setModelId(modelId);
        chatConfig.setChatAggConfig(chatConfigResp.getChatAggConfig());
        chatConfig.setChatDetailConfig(chatConfigResp.getChatDetailConfig());
        ItemNameVisibilityInfo itemNameVisibility = this.getItemNameVisibility(chatConfig);
        return itemNameVisibility;
    }

    @Override
    public ItemNameVisibilityInfo getItemNameVisibility(ChatConfig chatConfig) {
        Long modelId = chatConfig.getModelId();
        ArrayList blackDimIdList = new ArrayList();
        if (Objects.nonNull(chatConfig.getChatAggConfig()) && Objects.nonNull(chatConfig.getChatAggConfig().getVisibility())) {
            blackDimIdList.addAll(chatConfig.getChatAggConfig().getVisibility().getBlackDimIdList());
        }
        if (Objects.nonNull(chatConfig.getChatDetailConfig()) && Objects.nonNull(chatConfig.getChatDetailConfig().getVisibility())) {
            blackDimIdList.addAll(chatConfig.getChatDetailConfig().getVisibility().getBlackDimIdList());
        }
        List filterDimIdList = blackDimIdList.stream().distinct().collect(Collectors.toList());
        ArrayList blackMetricIdList = new ArrayList();
        if (Objects.nonNull(chatConfig.getChatAggConfig()) && Objects.nonNull(chatConfig.getChatAggConfig().getVisibility())) {
            blackMetricIdList.addAll(chatConfig.getChatAggConfig().getVisibility().getBlackMetricIdList());
        }
        if (Objects.nonNull(chatConfig.getChatDetailConfig()) && Objects.nonNull(chatConfig.getChatDetailConfig().getVisibility())) {
            blackMetricIdList.addAll(chatConfig.getChatDetailConfig().getVisibility().getBlackMetricIdList());
        }
        List filterMetricIdList = blackMetricIdList.stream().distinct().collect(Collectors.toList());
        ItemNameVisibilityInfo itemNameVisibility = new ItemNameVisibilityInfo();
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setModelIds((List)Lists.newArrayList((Object[])new Long[]{modelId}));
        if (!CollectionUtils.isEmpty(blackDimIdList)) {
            List dimensionRespList = this.dimensionService.getDimensions(metaFilter);
            List blackDimNameList = dimensionRespList.stream().filter(o -> filterDimIdList.contains(o.getId())).map(SchemaItem::getName).collect(Collectors.toList());
            itemNameVisibility.setBlackDimNameList(blackDimNameList);
        }
        if (!CollectionUtils.isEmpty(blackMetricIdList)) {
            List metricRespList = this.metricService.getMetrics(metaFilter);
            List blackMetricList = metricRespList.stream().filter(o -> filterMetricIdList.contains(o.getId())).map(SchemaItem::getName).collect(Collectors.toList());
            itemNameVisibility.setBlackMetricNameList(blackMetricList);
        }
        return itemNameVisibility;
    }

    @Override
    public List<ChatConfigResp> search(ChatConfigFilter filter, User user) {
        log.info("[search model extend] object:{}", (Object)JsonUtil.toString((Object)filter, (boolean)true));
        List<ChatConfigResp> chaConfigDescList = this.chatConfigRepository.getChatConfig(filter);
        return chaConfigDescList;
    }

    @Override
    public ChatConfigResp fetchConfigByModelId(Long modelId) {
        return this.chatConfigRepository.getConfigByModelId(modelId);
    }

    private ItemVisibilityInfo fetchVisibilityDescByConfig(ItemVisibility visibility, DataSetSchema modelSchema) {
        ItemVisibilityInfo itemVisibilityDesc = new ItemVisibilityInfo();
        List<Long> dimIdAllList = this.chatConfigHelper.generateAllDimIdList(modelSchema);
        List<Long> metricIdAllList = this.chatConfigHelper.generateAllMetricIdList(modelSchema);
        ArrayList blackDimIdList = new ArrayList();
        ArrayList blackMetricIdList = new ArrayList();
        if (Objects.nonNull(visibility)) {
            if (!CollectionUtils.isEmpty((Collection)visibility.getBlackDimIdList())) {
                blackDimIdList.addAll(visibility.getBlackDimIdList());
            }
            if (!CollectionUtils.isEmpty((Collection)visibility.getBlackMetricIdList())) {
                blackMetricIdList.addAll(visibility.getBlackMetricIdList());
            }
        }
        ArrayList whiteMetricIdList = metricIdAllList.stream().filter(id -> !blackMetricIdList.contains(id) && metricIdAllList.contains(id)).collect(Collectors.toList());
        ArrayList whiteDimIdList = dimIdAllList.stream().filter(id -> !blackDimIdList.contains(id) && dimIdAllList.contains(id)).collect(Collectors.toList());
        itemVisibilityDesc.setBlackDimIdList(blackDimIdList);
        itemVisibilityDesc.setBlackMetricIdList(blackMetricIdList);
        itemVisibilityDesc.setWhiteDimIdList((List)(Objects.isNull(whiteDimIdList) ? new ArrayList() : whiteDimIdList));
        itemVisibilityDesc.setWhiteMetricIdList((List)(Objects.isNull(whiteMetricIdList) ? new ArrayList() : whiteMetricIdList));
        return itemVisibilityDesc;
    }

    @Override
    public ChatConfigRichResp getConfigRichInfo(Long modelId) {
        ChatConfigRichResp chatConfigRich = new ChatConfigRichResp();
        ChatConfigResp chatConfigResp = this.chatConfigRepository.getConfigByModelId(modelId);
        if (Objects.isNull(chatConfigResp)) {
            log.info("there is no chatConfigDesc for modelId:{}", (Object)modelId);
            return chatConfigRich;
        }
        BeanUtils.copyProperties((Object)chatConfigResp, (Object)chatConfigRich);
        DataSetSchema dataSetSchema = this.semanticLayerService.getDataSetSchema(modelId);
        if (dataSetSchema == null) {
            return chatConfigRich;
        }
        chatConfigRich.setBizName(dataSetSchema.getDataSet().getBizName());
        chatConfigRich.setModelName(dataSetSchema.getDataSet().getName());
        chatConfigRich.setChatAggRichConfig(this.fillChatAggRichConfig(dataSetSchema, chatConfigResp));
        chatConfigRich.setChatDetailRichConfig(this.fillChatDetailRichConfig(dataSetSchema, chatConfigRich, chatConfigResp));
        return chatConfigRich;
    }

    private ChatDetailRichConfigResp fillChatDetailRichConfig(DataSetSchema modelSchema, ChatConfigRichResp chatConfigRich, ChatConfigResp chatConfigResp) {
        if (Objects.isNull(chatConfigResp) || Objects.isNull(chatConfigResp.getChatDetailConfig())) {
            return null;
        }
        ChatDetailRichConfigResp detailRichConfig = new ChatDetailRichConfigResp();
        ChatDetailConfigReq chatDetailConfig = chatConfigResp.getChatDetailConfig();
        ItemVisibilityInfo itemVisibilityInfo = this.fetchVisibilityDescByConfig(chatDetailConfig.getVisibility(), modelSchema);
        detailRichConfig.setVisibility(itemVisibilityInfo);
        detailRichConfig.setKnowledgeInfos(this.fillKnowledgeBizName(chatDetailConfig.getKnowledgeInfos(), modelSchema));
        detailRichConfig.setGlobalKnowledgeConfig(chatDetailConfig.getGlobalKnowledgeConfig());
        detailRichConfig.setChatDefaultConfig(this.fetchDefaultConfig(chatDetailConfig.getChatDefaultConfig(), modelSchema, itemVisibilityInfo));
        return detailRichConfig;
    }

    private EntityRichInfoResp generateRichEntity(Entity entity, DataSetSchema modelSchema) {
        EntityRichInfoResp entityRichInfo = new EntityRichInfoResp();
        if (Objects.isNull(entity) || Objects.isNull(entity.getEntityId())) {
            return entityRichInfo;
        }
        BeanUtils.copyProperties((Object)entity, (Object)entityRichInfo);
        Map dimIdAndRespPair = modelSchema.getDimensions().stream().collect(Collectors.toMap(SchemaElement::getId, Function.identity(), (k1, k2) -> k1));
        entityRichInfo.setDimItem((SchemaElement)dimIdAndRespPair.get(entity.getEntityId()));
        return entityRichInfo;
    }

    private ChatAggRichConfigResp fillChatAggRichConfig(DataSetSchema modelSchema, ChatConfigResp chatConfigResp) {
        if (Objects.isNull(chatConfigResp) || Objects.isNull(chatConfigResp.getChatAggConfig())) {
            return null;
        }
        ChatAggConfigReq chatAggConfig = chatConfigResp.getChatAggConfig();
        ChatAggRichConfigResp chatAggRichConfig = new ChatAggRichConfigResp();
        ItemVisibilityInfo itemVisibilityInfo = this.fetchVisibilityDescByConfig(chatAggConfig.getVisibility(), modelSchema);
        chatAggRichConfig.setVisibility(itemVisibilityInfo);
        chatAggRichConfig.setKnowledgeInfos(this.fillKnowledgeBizName(chatAggConfig.getKnowledgeInfos(), modelSchema));
        chatAggRichConfig.setGlobalKnowledgeConfig(chatAggConfig.getGlobalKnowledgeConfig());
        chatAggRichConfig.setChatDefaultConfig(this.fetchDefaultConfig(chatAggConfig.getChatDefaultConfig(), modelSchema, itemVisibilityInfo));
        return chatAggRichConfig;
    }

    private ChatDefaultRichConfigResp fetchDefaultConfig(ChatDefaultConfigReq chatDefaultConfig, DataSetSchema modelSchema, ItemVisibilityInfo itemVisibilityInfo) {
        ChatDefaultRichConfigResp defaultRichConfig = new ChatDefaultRichConfigResp();
        if (Objects.isNull(chatDefaultConfig)) {
            return defaultRichConfig;
        }
        BeanUtils.copyProperties((Object)chatDefaultConfig, (Object)defaultRichConfig);
        Map dimIdAndRespPair = modelSchema.getDimensions().stream().collect(Collectors.toMap(SchemaElement::getId, Function.identity(), (k1, k2) -> k1));
        Map metricIdAndRespPair = modelSchema.getMetrics().stream().collect(Collectors.toMap(SchemaElement::getId, Function.identity(), (k1, k2) -> k1));
        ArrayList dimensions = new ArrayList();
        ArrayList metrics = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)chatDefaultConfig.getDimensionIds())) {
            chatDefaultConfig.getDimensionIds().stream().filter(dimId -> dimIdAndRespPair.containsKey(dimId) && itemVisibilityInfo.getWhiteDimIdList().contains(dimId)).forEach(dimId -> {
                SchemaElement dimSchemaResp = (SchemaElement)dimIdAndRespPair.get(dimId);
                if (Objects.nonNull(dimSchemaResp)) {
                    SchemaElement dimSchema = new SchemaElement();
                    BeanUtils.copyProperties((Object)dimSchemaResp, (Object)dimSchema);
                    dimensions.add(dimSchema);
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)chatDefaultConfig.getMetricIds())) {
            chatDefaultConfig.getMetricIds().stream().filter(metricId -> metricIdAndRespPair.containsKey(metricId) && itemVisibilityInfo.getWhiteMetricIdList().contains(metricId)).forEach(metricId -> {
                SchemaElement metricSchemaResp = (SchemaElement)metricIdAndRespPair.get(metricId);
                if (Objects.nonNull(metricSchemaResp)) {
                    SchemaElement metricSchema = new SchemaElement();
                    BeanUtils.copyProperties((Object)metricSchemaResp, (Object)metricSchema);
                    metrics.add(metricSchema);
                }
            });
        }
        defaultRichConfig.setDimensions(dimensions);
        defaultRichConfig.setMetrics(metrics);
        return defaultRichConfig;
    }

    private List<KnowledgeInfoReq> fillKnowledgeBizName(List<KnowledgeInfoReq> knowledgeInfos, DataSetSchema modelSchema) {
        if (CollectionUtils.isEmpty(knowledgeInfos)) {
            return new ArrayList<KnowledgeInfoReq>();
        }
        Map dimIdAndRespPair = modelSchema.getDimensions().stream().collect(Collectors.toMap(SchemaElement::getId, Function.identity(), (k1, k2) -> k1));
        knowledgeInfos.stream().forEach(knowledgeInfo -> {
            SchemaElement dimSchemaResp;
            if (Objects.nonNull(knowledgeInfo) && Objects.nonNull(dimSchemaResp = (SchemaElement)dimIdAndRespPair.get(knowledgeInfo.getItemId()))) {
                knowledgeInfo.setBizName(dimSchemaResp.getBizName());
            }
        });
        return knowledgeInfos;
    }

    @Override
    public List<ChatConfigRichResp> getAllChatRichConfig() {
        return new ArrayList<ChatConfigRichResp>();
    }
}

