/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.chat.api.pojo.enums.MemoryStatus;
import com.tencent.supersonic.chat.api.pojo.request.ChatMemoryFilter;
import com.tencent.supersonic.chat.api.pojo.request.ChatMemoryUpdateReq;
import com.tencent.supersonic.chat.api.pojo.request.PageMemoryReq;
import com.tencent.supersonic.chat.server.persistence.dataobject.ChatMemoryDO;
import com.tencent.supersonic.chat.server.persistence.repository.ChatMemoryRepository;
import com.tencent.supersonic.chat.server.service.MemoryService;
import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.pojo.SqlExemplar;
import com.tencent.supersonic.common.service.ExemplarService;
import com.tencent.supersonic.common.util.BeanMapper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MemoryServiceImpl
implements MemoryService {
    @Autowired
    private ChatMemoryRepository chatMemoryRepository;
    @Autowired
    private ExemplarService exemplarService;
    @Autowired
    private EmbeddingConfig embeddingConfig;

    @Override
    public void createMemory(ChatMemoryDO memory) {
        this.chatMemoryRepository.createMemory(memory);
    }

    @Override
    public void updateMemory(ChatMemoryUpdateReq chatMemoryUpdateReq, User user) {
        chatMemoryUpdateReq.updatedBy(user.getName());
        ChatMemoryDO chatMemoryDO = this.chatMemoryRepository.getMemory(chatMemoryUpdateReq.getId());
        boolean hadEnabled = MemoryStatus.ENABLED.equals((Object)chatMemoryDO.getStatus());
        BeanMapper.mapper((Object)chatMemoryUpdateReq, (Object)chatMemoryDO);
        if (MemoryStatus.ENABLED.equals((Object)chatMemoryUpdateReq.getStatus()) && !hadEnabled) {
            this.enableMemory(chatMemoryDO);
        } else if (MemoryStatus.DISABLED.equals((Object)chatMemoryUpdateReq.getStatus()) && hadEnabled) {
            this.disableMemory(chatMemoryDO);
        }
        this.updateMemory(chatMemoryDO);
    }

    @Override
    public void updateMemory(ChatMemoryDO memory) {
        this.chatMemoryRepository.updateMemory(memory);
    }

    @Override
    public PageInfo<ChatMemoryDO> pageMemories(PageMemoryReq pageMemoryReq) {
        return PageHelper.startPage((int)pageMemoryReq.getCurrent(), (int)pageMemoryReq.getPageSize()).doSelectPageInfo(() -> this.getMemories(pageMemoryReq.getChatMemoryFilter()));
    }

    @Override
    public List<ChatMemoryDO> getMemories(ChatMemoryFilter chatMemoryFilter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (chatMemoryFilter.getAgentId() != null) {
            queryWrapper.lambda().eq(ChatMemoryDO::getAgentId, (Object)chatMemoryFilter.getAgentId());
        }
        if (StringUtils.isNotBlank((CharSequence)chatMemoryFilter.getQuestion())) {
            queryWrapper.lambda().like(ChatMemoryDO::getQuestion, (Object)chatMemoryFilter.getQuestion());
        }
        if (!CollectionUtils.isEmpty((Collection)chatMemoryFilter.getQuestions())) {
            queryWrapper.lambda().in(ChatMemoryDO::getQuestion, (Collection)chatMemoryFilter.getQuestions());
        }
        if (chatMemoryFilter.getStatus() != null) {
            queryWrapper.lambda().eq(ChatMemoryDO::getStatus, (Object)chatMemoryFilter.getStatus());
        }
        if (chatMemoryFilter.getHumanReviewRet() != null) {
            queryWrapper.lambda().eq(ChatMemoryDO::getHumanReviewRet, (Object)chatMemoryFilter.getHumanReviewRet());
        }
        if (chatMemoryFilter.getLlmReviewRet() != null) {
            queryWrapper.lambda().eq(ChatMemoryDO::getLlmReviewRet, (Object)chatMemoryFilter.getLlmReviewRet());
        }
        return this.chatMemoryRepository.getMemories((QueryWrapper<ChatMemoryDO>)queryWrapper);
    }

    @Override
    public List<ChatMemoryDO> getMemoriesForLlmReview() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ChatMemoryDO::getStatus, (Object)MemoryStatus.PENDING)).isNull(ChatMemoryDO::getLlmReviewRet);
        return this.chatMemoryRepository.getMemories((QueryWrapper<ChatMemoryDO>)queryWrapper);
    }

    @Override
    public void enableMemory(ChatMemoryDO memory) {
        memory.setStatus(MemoryStatus.ENABLED);
        this.exemplarService.storeExemplar(this.embeddingConfig.getMemoryCollectionName(memory.getAgentId()), SqlExemplar.builder().question(memory.getQuestion()).dbSchema(memory.getDbSchema()).sql(memory.getS2sql()).build());
    }

    @Override
    public void disableMemory(ChatMemoryDO memory) {
        memory.setStatus(MemoryStatus.DISABLED);
        this.exemplarService.removeExemplar(this.embeddingConfig.getMemoryCollectionName(memory.getAgentId()), SqlExemplar.builder().question(memory.getQuestion()).dbSchema(memory.getDbSchema()).sql(memory.getS2sql()).build());
    }
}

