/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.chat.server.srmExtend;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.google.common.collect.Sets;
import com.tencent.supersonic.chat.server.agent.Agent;
import com.tencent.supersonic.chat.server.pojo.ParseContext;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.request.QueryDataReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.api.pojo.srmExtend.PermissionDataBuilder;
import com.tencent.supersonic.headless.api.pojo.srmExtend.SrmPermissionDataModel;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMReq;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SqlDataPermissionUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlDataPermissionUtil.class);

    public static Set<QueryFilter> buildPermissionFilterBeforeQueryData(QueryDataReq queryData) {
        SchemaElement dataSet = queryData.getParseInfo().getDataSet();
        String businessType = dataSet.getBusinessType();
        if (StrUtil.isEmpty((CharSequence)businessType)) {
            return Sets.newHashSet();
        }
        SrmPermissionDataModel permissionDataModel = PermissionDataBuilder.buildPermissionDataModel((String)businessType);
        List permissionParam = permissionDataModel.getDataList();
        if (CollectionUtils.isEmpty((Collection)permissionParam)) {
            return Sets.newHashSet();
        }
        Map<String, List<PermissionDataDTO>> sameFieldMap = permissionParam.stream().collect(Collectors.groupingBy(PermissionDataDTO::getPermissionField));
        if (null == sameFieldMap || sameFieldMap.isEmpty()) {
            return Sets.newHashSet();
        }
        for (String fileName : sameFieldMap.keySet()) {
            List<PermissionDataDTO> sameFieldPermissionList = sameFieldMap.get(fileName);
            for (PermissionDataDTO g : sameFieldPermissionList) {
                LLMReq.ElementValue value = new LLMReq.ElementValue();
                value.setFieldValue(g.getPermissionValue());
                value.setFieldName(g.getPermissionField());
            }
        }
        return Sets.newHashSet();
    }

    public static void buildPermissionFilterBeforeParse(ParseContext chatParseContext) {
        String model = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.sqlPermission.model");
        QueryFilters queryFilters = chatParseContext.getQueryFilters();
        if (null == queryFilters) {
            queryFilters = new QueryFilters();
            chatParseContext.setQueryFilters(queryFilters);
        }
        QueryFilter elsAccountFilter = new QueryFilter();
        elsAccountFilter.setOperator(FilterOperatorEnum.EQUALS);
        elsAccountFilter.setName("elsAccount");
        elsAccountFilter.setBizName("elsAccount");
        elsAccountFilter.setValue((Object)SysUtil.getLoginUser().getElsAccount());
        queryFilters.getFilters().add(elsAccountFilter);
        if (!"filter".equals(model) || CharSequenceUtil.isEmpty((CharSequence)model)) {
            return;
        }
        Agent agent = chatParseContext.getAgent();
        if (null == agent) {
            return;
        }
        String businessType = agent.getBusinessType();
        if (StrUtil.isEmpty((CharSequence)businessType)) {
            return;
        }
        SrmPermissionDataModel permissionDataModel = PermissionDataBuilder.buildPermissionDataModel((String)businessType);
        List permissionParam = permissionDataModel.getDataList();
        if (CollectionUtils.isEmpty((Collection)permissionParam)) {
            return;
        }
        Map<String, List<PermissionDataDTO>> sameFieldMap = permissionParam.stream().collect(Collectors.groupingBy(PermissionDataDTO::getPermissionField));
        if (null == sameFieldMap || sameFieldMap.isEmpty()) {
            return;
        }
        for (String fileName : sameFieldMap.keySet()) {
            List<PermissionDataDTO> sameFieldPermissionList = sameFieldMap.get(fileName);
            if (sameFieldPermissionList.isEmpty()) continue;
            PermissionDataDTO dataDTO = sameFieldPermissionList.get(0);
            QueryFilter queryFilter = new QueryFilter();
            queryFilter.setOperator(FilterOperatorEnum.IN);
            queryFilter.setName(dataDTO.getPermissionField());
            queryFilter.setBizName(dataDTO.getPermissionField());
            String value = sameFieldPermissionList.stream().map(PermissionDataDTO::getPermissionValue).collect(Collectors.joining("`,`"));
            queryFilter.setValue((Object)("('" + value + "')"));
            queryFilters.getFilters().add(queryFilter);
        }
    }
}

