/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.bintrie;

import com.hankcs.hanlp.LoadRemoveService;
import com.hankcs.hanlp.collection.trie.bintrie.Node;
import com.hankcs.hanlp.collection.trie.bintrie._ValueArray;
import com.hankcs.hanlp.corpus.io.ByteArray;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNode<V>
implements Comparable<BaseNode> {
    private static final Logger log = LoggerFactory.getLogger(BaseNode.class);
    static final Status[] ARRAY_STATUS = Status.values();
    protected BaseNode[] child;
    protected Status status;
    protected char c;
    protected V value;
    protected String prefix = null;

    public BaseNode<V> transition(String path, int begin) {
        BaseNode cur = this;
        for (int i = begin; i < path.length(); ++i) {
            if ((cur = cur.getChild(path.charAt(i))) != null && cur.status != Status.UNDEFINED_0) continue;
            return null;
        }
        return cur;
    }

    public BaseNode<V> transition(char[] path, int begin) {
        BaseNode cur = this;
        for (int i = begin; i < path.length; ++i) {
            if ((cur = cur.getChild(path[i])) != null && cur.status != Status.UNDEFINED_0) continue;
            return null;
        }
        return cur;
    }

    public BaseNode<V> transition(char path) {
        BaseNode cur = this;
        if ((cur = cur.getChild(path)) == null || cur.status == Status.UNDEFINED_0) {
            return null;
        }
        return cur;
    }

    protected abstract boolean addChild(BaseNode var1);

    protected boolean hasChild(char c) {
        return this.getChild(c) != null;
    }

    protected char getChar() {
        return this.c;
    }

    public abstract BaseNode getChild(char var1);

    public final V getValue() {
        return this.value;
    }

    public final void setValue(V value) {
        this.value = value;
    }

    @Override
    public int compareTo(BaseNode other) {
        return this.compareTo(other.getChar());
    }

    @Override
    public int compareTo(char other) {
        if (this.c > other) {
            return 1;
        }
        if (this.c < other) {
            return -1;
        }
        return 0;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void walk(StringBuilder sb, Set<Map.Entry<String, V>> entrySet) {
        sb.append(this.c);
        if (this.status == Status.WORD_MIDDLE_2 || this.status == Status.WORD_END_3) {
            entrySet.add(new TrieEntry(sb.toString(), this.value));
        }
        if (this.child == null) {
            return;
        }
        for (BaseNode node : this.child) {
            if (node == null) continue;
            node.walk(new StringBuilder(sb.toString()), entrySet);
        }
    }

    protected void walkToSave(DataOutputStream out) throws IOException {
        out.writeChar(this.c);
        out.writeInt(this.status.ordinal());
        int childSize = 0;
        if (this.child != null) {
            childSize = this.child.length;
        }
        out.writeInt(childSize);
        if (this.child == null) {
            return;
        }
        for (BaseNode node : this.child) {
            node.walkToSave(out);
        }
    }

    protected void walkToSave(ObjectOutput out) throws IOException {
        out.writeChar(this.c);
        out.writeInt(this.status.ordinal());
        if (this.status == Status.WORD_END_3 || this.status == Status.WORD_MIDDLE_2) {
            out.writeObject(this.value);
        }
        int childSize = 0;
        if (this.child != null) {
            childSize = this.child.length;
        }
        out.writeInt(childSize);
        if (this.child == null) {
            return;
        }
        for (BaseNode node : this.child) {
            node.walkToSave(out);
        }
    }

    protected void walkToLoad(ByteArray byteArray, _ValueArray<V> valueArray) {
        this.c = byteArray.nextChar();
        this.status = ARRAY_STATUS[byteArray.nextInt()];
        if (this.status == Status.WORD_END_3 || this.status == Status.WORD_MIDDLE_2) {
            this.value = valueArray.nextValue();
        }
        int childSize = byteArray.nextInt();
        this.child = new BaseNode[childSize];
        for (int i = 0; i < childSize; ++i) {
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray, valueArray);
        }
    }

    protected void walkToLoad(ObjectInput byteArray) throws IOException, ClassNotFoundException {
        this.c = byteArray.readChar();
        this.status = ARRAY_STATUS[byteArray.readInt()];
        if (this.status == Status.WORD_END_3 || this.status == Status.WORD_MIDDLE_2) {
            this.value = byteArray.readObject();
        }
        int childSize = byteArray.readInt();
        this.child = new BaseNode[childSize];
        for (int i = 0; i < childSize; ++i) {
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray);
        }
    }

    public String toString() {
        return "BaseNode{child=" + Arrays.toString(this.child) + ", status=" + this.status + ", c=" + this.c + ", value=" + this.value + ", prefix='" + this.prefix + "'}";
    }

    public void walkNode(Set<Map.Entry<String, V>> entrySet) {
        if (this.status == Status.WORD_MIDDLE_2 || this.status == Status.WORD_END_3) {
            log.debug("walkNode before:{}", (Object)this.value.toString());
            List natures = new LoadRemoveService().removeNatures((List)this.value);
            String name = this.prefix != null ? this.prefix + this.c : "" + this.c;
            log.debug("walkNode name:{},after:{},natures:{}", new Object[]{name, (List)this.value, natures});
            entrySet.add(new TrieEntry(name, natures));
        }
    }

    public void walkLimit(StringBuilder sb, Set<Map.Entry<String, V>> entrySet) {
        ArrayDeque<BaseNode> queue = new ArrayDeque<BaseNode>();
        this.prefix = sb.toString();
        queue.add(this);
        while (!queue.isEmpty()) {
            BaseNode root = (BaseNode)queue.poll();
            if (root == null) continue;
            root.walkNode(entrySet);
            if (root.child == null) continue;
            String prefix = root.prefix + root.c;
            for (BaseNode node : root.child) {
                if (!Objects.nonNull(node)) continue;
                node.prefix = prefix;
                queue.add(node);
            }
        }
    }

    public static enum Status {
        UNDEFINED_0,
        NOT_WORD_1,
        WORD_MIDDLE_2,
        WORD_END_3;

    }

    public class TrieEntry
    extends AbstractMap.SimpleEntry<String, V>
    implements Comparable<TrieEntry> {
        public TrieEntry(String key, V value) {
            super(key, value);
        }

        @Override
        public int compareTo(TrieEntry o) {
            return ((String)this.getKey()).compareTo(String.valueOf(o.getKey()));
        }
    }
}

