/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg;

import com.hankcs.hanlp.algorithm.Viterbi;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CoreDictionaryTransformMatrixDictionary;
import com.hankcs.hanlp.dictionary.TransformMatrix;
import com.hankcs.hanlp.dictionary.other.CharType;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class WordBasedSegment
extends Segment {
    protected static void generateWord(List<Vertex> linkedArray, WordNet wordNetOptimum) {
        WordBasedSegment.fixResultByRule(linkedArray);
        wordNetOptimum.addAll(linkedArray);
    }

    protected static void fixResultByRule(List<Vertex> linkedArray) {
        WordBasedSegment.mergeContinueNumIntoOne(linkedArray);
        WordBasedSegment.changeDelimiterPOS(linkedArray);
        WordBasedSegment.splitMiddleSlashFromDigitalWords(linkedArray);
        WordBasedSegment.checkDateElements(linkedArray);
    }

    static void changeDelimiterPOS(List<Vertex> linkedArray) {
        Iterator<Vertex> var1 = linkedArray.iterator();
        while (var1.hasNext()) {
            Vertex vertex = var1.next();
            if (!vertex.realWord.equals("\uff0d\uff0d") && !vertex.realWord.equals("\u2014") && !vertex.realWord.equals("-")) continue;
            vertex.confirmNature(Nature.w);
        }
        return;
    }

    private static void splitMiddleSlashFromDigitalWords(List<Vertex> linkedArray) {
        if (linkedArray.size() >= 2) {
            Vertex next;
            ListIterator<Vertex> listIterator = linkedArray.listIterator();
            Vertex current = next = listIterator.next();
            while (listIterator.hasNext()) {
                String[] param;
                next = listIterator.next();
                Nature currentNature = current.getNature();
                if (currentNature == Nature.nx && (next.hasNature(Nature.q) || next.hasNature(Nature.n)) && (param = current.realWord.split("-", 1)).length == 2 && TextUtility.isAllNum((String)param[0]) && TextUtility.isAllNum((String)param[1])) {
                    current = current.copy();
                    current.realWord = param[0];
                    current.confirmNature(Nature.m);
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.set(current);
                    listIterator.next();
                    listIterator.add(Vertex.newPunctuationInstance((String)"-"));
                    listIterator.add(Vertex.newNumberInstance((String)param[1]));
                }
                current = next;
            }
        }
    }

    private static void checkDateElements(List<Vertex> linkedArray) {
        if (linkedArray.size() >= 2) {
            Vertex next;
            ListIterator<Vertex> listIterator = linkedArray.listIterator();
            Vertex current = next = listIterator.next();
            while (listIterator.hasNext()) {
                next = listIterator.next();
                if (TextUtility.isAllNum((String)current.realWord) || TextUtility.isAllChineseNum((String)current.realWord)) {
                    String nextWord = next.realWord;
                    if (nextWord.length() == 1 && "\u6708\u65e5\u65f6\u5206\u79d2".contains(nextWord) || nextWord.length() == 2 && nextWord.equals("\u6708\u4efd")) {
                        WordBasedSegment.mergeDate(listIterator, next, current);
                    } else if (nextWord.equals("\u5e74")) {
                        if (TextUtility.isYearTime((String)current.realWord)) {
                            WordBasedSegment.mergeDate(listIterator, next, current);
                        } else {
                            current.confirmNature(Nature.m);
                        }
                    } else if (current.realWord.endsWith("\u70b9")) {
                        current.confirmNature(Nature.t, true);
                    } else {
                        char[] tmpCharArray = current.realWord.toCharArray();
                        String lastChar = String.valueOf(tmpCharArray[tmpCharArray.length - 1]);
                        if (!"\u2236\u00b7\uff0e\uff0f./".contains(lastChar)) {
                            current.confirmNature(Nature.m, true);
                        } else if (current.realWord.length() > 1) {
                            char last = current.realWord.charAt(current.realWord.length() - 1);
                            current = Vertex.newNumberInstance((String)current.realWord.substring(0, current.realWord.length() - 1));
                            listIterator.previous();
                            listIterator.previous();
                            listIterator.set(current);
                            listIterator.next();
                            listIterator.add(Vertex.newPunctuationInstance((String)String.valueOf(last)));
                        }
                    }
                }
                current = next;
            }
        }
    }

    private static void mergeDate(ListIterator<Vertex> listIterator, Vertex next, Vertex current) {
        current = Vertex.newTimeInstance((String)(current.realWord + next.realWord));
        listIterator.previous();
        listIterator.previous();
        listIterator.set(current);
        listIterator.next();
        listIterator.next();
        listIterator.remove();
    }

    protected static List<Term> convert(List<Vertex> vertexList) {
        return Segment.convert(vertexList, (boolean)false);
    }

    protected static Graph generateBiGraph(WordNet wordNet) {
        return wordNet.toGraph();
    }

    private static List<AtomNode> atomSegment(String sSentence, int start, int end) {
        if (end < start) {
            throw new RuntimeException("start=" + start + " < end=" + end);
        }
        ArrayList<AtomNode> atomSegment = new ArrayList<AtomNode>();
        int pCur = 0;
        StringBuilder sb = new StringBuilder();
        char[] charArray = sSentence.substring(start, end).toCharArray();
        int[] charTypeArray = new int[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            charTypeArray[i] = CharType.get((char)c);
            if (c == '.' && i < charArray.length - 1 && CharType.get((char)charArray[i + 1]) == 9) {
                charTypeArray[i] = 9;
                continue;
            }
            if (c == '.' && i < charArray.length - 1 && charArray[i + 1] >= '0' && charArray[i + 1] <= '9') {
                charTypeArray[i] = 5;
                continue;
            }
            if (charTypeArray[i] != 8) continue;
            charTypeArray[i] = 5;
        }
        while (pCur < charArray.length) {
            int nCurType = charTypeArray[pCur];
            if (nCurType != 7 && nCurType != 10 && nCurType != 6 && nCurType != 17) {
                if (pCur < charArray.length - 1 && (nCurType == 5 || nCurType == 9)) {
                    sb.delete(0, sb.length());
                    sb.append(charArray[pCur]);
                    boolean reachEnd = true;
                    while (pCur < charArray.length - 1) {
                        int nNextType;
                        if ((nNextType = charTypeArray[++pCur]) != nCurType) {
                            reachEnd = false;
                            break;
                        }
                        sb.append(charArray[pCur]);
                    }
                    atomSegment.add(new AtomNode(sb.toString(), nCurType));
                    if (!reachEnd) continue;
                    ++pCur;
                    continue;
                }
                atomSegment.add(new AtomNode(charArray[pCur], nCurType));
                ++pCur;
                continue;
            }
            String single = String.valueOf(charArray[pCur]);
            if (single.length() != 0) {
                atomSegment.add(new AtomNode(single, nCurType));
            }
            ++pCur;
        }
        return atomSegment;
    }

    private static void mergeContinueNumIntoOne(List<Vertex> linkedArray) {
        if (linkedArray.size() >= 2) {
            Vertex next;
            ListIterator<Vertex> listIterator = linkedArray.listIterator();
            Vertex current = next = listIterator.next();
            while (listIterator.hasNext()) {
                next = listIterator.next();
                if (!TextUtility.isAllNum((String)current.realWord) && !TextUtility.isAllChineseNum((String)current.realWord) || !TextUtility.isAllNum((String)next.realWord) && !TextUtility.isAllChineseNum((String)next.realWord)) {
                    current = next;
                    continue;
                }
                current = Vertex.newNumberInstance((String)(current.realWord + next.realWord));
                listIterator.previous();
                listIterator.previous();
                listIterator.set(current);
                listIterator.next();
                listIterator.next();
                listIterator.remove();
            }
            return;
        }
    }

    protected void generateWordNet(final WordNet wordNetStorage) {
        final char[] charArray = wordNetStorage.charArray;
        DoubleArrayTrie.Searcher searcher = CoreDictionary.trie.getSearcher(charArray, 0);
        while (searcher.next()) {
            wordNetStorage.add(searcher.begin + 1, new Vertex(new String(charArray, searcher.begin, searcher.length), (CoreDictionary.Attribute)searcher.value, searcher.index));
        }
        if (this.config.forceCustomDictionary) {
            this.customDictionary.parseText(charArray, (AhoCorasickDoubleArrayTrie.IHit)new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

                public void hit(int begin, int end, CoreDictionary.Attribute value) {
                    wordNetStorage.add(begin + 1, new Vertex(new String(charArray, begin, end - begin), value));
                }
            });
        }
        LinkedList[] vertexes = wordNetStorage.getVertexes();
        int i = 1;
        while (i < vertexes.length) {
            if (vertexes[i].isEmpty()) {
                int j;
                for (j = i + 1; j < vertexes.length - 1 && (vertexes[j].isEmpty() || CharType.get((char)charArray[j - 1]) == 11); ++j) {
                }
                wordNetStorage.add(i, Segment.quickAtomSegment((char[])charArray, (int)(i - 1), (int)(j - 1)));
                i = j;
                continue;
            }
            i += ((Vertex)vertexes[i].getLast()).realWord.length();
        }
    }

    protected List<Term> decorateResultForIndexMode(List<Vertex> vertexList, WordNet wordNetAll) {
        LinkedList<Term> termList = new LinkedList<Term>();
        int line = 1;
        ListIterator<Vertex> listIterator = vertexList.listIterator();
        listIterator.next();
        int length = vertexList.size() - 2;
        for (int i = 0; i < length; ++i) {
            Vertex vertex = listIterator.next();
            Term termMain = Segment.convert((Vertex)vertex);
            this.addTerms(termList, vertex, line - 1);
            termMain.offset = line - 1;
            if (vertex.realWord.length() > 2) {
                for (int currentLine = line; currentLine < line + vertex.realWord.length(); ++currentLine) {
                    Iterator iterator = wordNetAll.descendingIterator(currentLine);
                    while (iterator.hasNext()) {
                        Vertex smallVertex = (Vertex)iterator.next();
                        if ((termMain.nature != Nature.mq || !smallVertex.hasNature(Nature.q)) && smallVertex.realWord.length() < this.config.indexMode || smallVertex == vertex || currentLine + smallVertex.realWord.length() > line + vertex.realWord.length()) continue;
                        listIterator.add(smallVertex);
                        this.addTerms(termList, smallVertex, currentLine - 1);
                    }
                }
            }
            line += vertex.realWord.length();
        }
        return termList;
    }

    protected static void speechTagging(List<Vertex> vertexList) {
        Viterbi.compute(vertexList, (TransformMatrix)CoreDictionaryTransformMatrixDictionary.transformMatrixDictionary);
    }

    protected void addTerms(List<Term> terms, Vertex vertex, int offset) {
        for (int i = 0; i < vertex.attribute.nature.length; ++i) {
            Term term = new Term(vertex.realWord, vertex.attribute.nature[i]);
            term.setFrequency(vertex.attribute.frequency[i]);
            term.offset = offset;
            terms.add(term);
        }
    }
}

