/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.calcite;

import com.tencent.supersonic.common.calcite.S2MysqlSqlDialect;
import com.tencent.supersonic.common.calcite.SqlParserInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class SqlParseUtils {
    public static SqlParserInfo getSqlParseInfo(String sql) {
        try {
            SqlParser parser = SqlParser.create((String)sql);
            SqlNode sqlNode = parser.parseQuery();
            SqlParserInfo sqlParserInfo = new SqlParserInfo();
            SqlParseUtils.handlerSQL(sqlNode, sqlParserInfo);
            sqlParserInfo.setAllFields(sqlParserInfo.getAllFields().stream().distinct().collect(Collectors.toList()));
            sqlParserInfo.setSelectFields(sqlParserInfo.getSelectFields().stream().distinct().collect(Collectors.toList()));
            return sqlParserInfo;
        }
        catch (SqlParseException e) {
            throw new RuntimeException("getSqlParseInfo", e);
        }
    }

    public static void handlerSQL(SqlNode sqlNode, SqlParserInfo sqlParserInfo) {
        SqlKind kind = sqlNode.getKind();
        switch (kind) {
            case SELECT: {
                SqlParseUtils.handlerSelect(sqlNode, sqlParserInfo);
                break;
            }
            case ORDER_BY: {
                SqlParseUtils.handlerOrderBy(sqlNode, sqlParserInfo);
                break;
            }
        }
    }

    private static void handlerOrderBy(SqlNode node, SqlParserInfo sqlParserInfo) {
        SqlOrderBy sqlOrderBy = (SqlOrderBy)node;
        SqlNode query = sqlOrderBy.query;
        SqlParseUtils.handlerSQL(query, sqlParserInfo);
        SqlNodeList orderList = sqlOrderBy.orderList;
        Set<String> orderFields = SqlParseUtils.handlerField((SqlNode)orderList);
        sqlParserInfo.getAllFields().addAll(orderFields);
    }

    private static void handlerSelect(SqlNode select, SqlParserInfo sqlParserInfo) {
        List<String> allFields = sqlParserInfo.getAllFields();
        SqlSelect sqlSelect = (SqlSelect)select;
        SqlNodeList selectList = sqlSelect.getSelectList();
        selectList.getList().forEach(list -> {
            Set<String> selectFields = SqlParseUtils.handlerField(list);
            sqlParserInfo.getSelectFields().addAll(selectFields);
        });
        String tableName = SqlParseUtils.handlerFrom(sqlSelect.getFrom());
        sqlParserInfo.setTableName(tableName);
        Set<String> selectFields = SqlParseUtils.handlerSelectField(sqlSelect);
        allFields.addAll(selectFields);
    }

    private static Set<String> handlerSelectField(SqlSelect sqlSelect) {
        SqlNodeList group;
        HashSet<String> results = new HashSet<String>();
        if (sqlSelect.getFrom() instanceof SqlBasicCall) {
            Set<String> formFields = SqlParseUtils.handlerField(sqlSelect.getFrom());
            results.addAll(formFields);
        }
        sqlSelect.getSelectList().getList().forEach(list -> {
            Set<String> selectFields = SqlParseUtils.handlerField(list);
            results.addAll(selectFields);
        });
        if (sqlSelect.hasWhere()) {
            Set<String> whereFields = SqlParseUtils.handlerField(sqlSelect.getWhere());
            results.addAll(whereFields);
        }
        if (sqlSelect.hasOrderBy()) {
            Set<String> orderByFields = SqlParseUtils.handlerField((SqlNode)sqlSelect.getOrderList());
            results.addAll(orderByFields);
        }
        if ((group = sqlSelect.getGroup()) != null) {
            group.forEach(groupField -> {
                Set<String> groupByFields = SqlParseUtils.handlerField(groupField);
                results.addAll(groupByFields);
            });
        }
        return results;
    }

    private static String handlerFrom(SqlNode from) {
        SqlKind kind = from.getKind();
        switch (kind) {
            case IDENTIFIER: {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)from;
                return sqlIdentifier.getSimple();
            }
            case AS: {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)from;
                SqlNode sqlNode = (SqlNode)sqlBasicCall.getOperandList().get(0);
                SqlSelect sqlSelect = (SqlSelect)sqlNode;
                return SqlParseUtils.handlerFrom(sqlSelect.getFrom());
            }
        }
        return "";
    }

    private static Set<String> handlerField(SqlNode field) {
        HashSet<String> fields = new HashSet<String>();
        SqlKind kind = field.getKind();
        switch (kind) {
            case AS: {
                List operandList1 = ((SqlBasicCall)field).getOperandList();
                SqlNode leftAs = (SqlNode)operandList1.get(0);
                fields.addAll(SqlParseUtils.handlerField(leftAs));
                break;
            }
            case IDENTIFIER: {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)field;
                String simpleName = sqlIdentifier.getSimple();
                if (!StringUtils.isNotEmpty((CharSequence)simpleName)) break;
                fields.add(simpleName);
                break;
            }
            case SELECT: {
                SqlSelect sqlSelect = (SqlSelect)field;
                fields.addAll(SqlParseUtils.handlerSelectField(sqlSelect));
                break;
            }
            default: {
                if (field instanceof SqlBasicCall) {
                    List operandList2 = ((SqlBasicCall)field).getOperandList();
                    for (int i = 0; i < operandList2.size(); ++i) {
                        fields.addAll(SqlParseUtils.handlerField((SqlNode)operandList2.get(i)));
                    }
                }
                if (!(field instanceof SqlNodeList)) break;
                ((SqlNodeList)field).getList().forEach(node -> fields.addAll(SqlParseUtils.handlerField(node)));
            }
        }
        return fields;
    }

    public static String addAliasToSql(String sql) throws SqlParseException {
        SqlParser parser = SqlParser.create((String)sql);
        SqlNode sqlNode = parser.parseStmt();
        if (!(sqlNode instanceof SqlSelect)) {
            return sql;
        }
        SqlNodeList selectList = ((SqlSelect)sqlNode).getSelectList();
        for (SqlNode node : selectList) {
            SqlBasicCall sqlBasicCall;
            List operandList;
            if (!(node instanceof SqlBasicCall) || !org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(operandList = (sqlBasicCall = (SqlBasicCall)node).getOperandList())) || operandList.size() != 1) continue;
            SqlIdentifier sqlIdentifier = (SqlIdentifier)operandList.get(0);
            String simple = sqlIdentifier.getSimple();
            SqlBasicCall aliasedNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{sqlBasicCall, new SqlIdentifier(simple.toLowerCase(), SqlParserPos.ZERO)}, SqlParserPos.ZERO);
            selectList.set(selectList.indexOf((Object)node), (SqlNode)aliasedNode);
        }
        S2MysqlSqlDialect dialect = new S2MysqlSqlDialect(S2MysqlSqlDialect.DEFAULT_CONTEXT);
        SqlString newSql = sqlNode.toSqlString((SqlDialect)dialect);
        return newSql.getSql().replaceAll("`", "");
    }

    public static String addFieldsToSql(String sql, List<String> addFields) throws SqlParseException {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(addFields)) {
            return sql;
        }
        SqlParser parser = SqlParser.create((String)sql);
        SqlNode sqlNode = parser.parseStmt();
        SqlNodeList selectList = SqlParseUtils.getSelectList(sqlNode);
        if (Objects.isNull(selectList)) {
            return sql;
        }
        for (Object node : selectList) {
            if (!(node instanceof SqlBasicCall)) continue;
            return sql;
        }
        HashSet<String> existFields = new HashSet<String>();
        for (SqlNode node : selectList.getList()) {
            if (!(node instanceof SqlIdentifier)) continue;
            String fieldName = ((SqlIdentifier)node).getSimple();
            existFields.add(fieldName.toLowerCase());
        }
        for (String addField : addFields) {
            if (existFields.contains(addField.toLowerCase())) continue;
            SqlIdentifier newField = new SqlIdentifier(addField, SqlParserPos.ZERO);
            selectList.add((SqlNode)newField);
            existFields.add(addField.toLowerCase());
        }
        S2MysqlSqlDialect dialect = new S2MysqlSqlDialect(S2MysqlSqlDialect.DEFAULT_CONTEXT);
        SqlString newSql = sqlNode.toSqlString((SqlDialect)dialect);
        return newSql.getSql().replaceAll("`", "");
    }

    private static SqlNodeList getSelectList(SqlNode sqlNode) {
        SqlKind kind = sqlNode.getKind();
        switch (kind) {
            case SELECT: {
                SqlSelect sqlSelect = (SqlSelect)sqlNode;
                return sqlSelect.getSelectList();
            }
            case ORDER_BY: {
                SqlOrderBy sqlOrderBy = (SqlOrderBy)sqlNode;
                SqlSelect query = (SqlSelect)sqlOrderBy.query;
                return query.getSelectList();
            }
        }
        return null;
    }

    public static Set<String> getFilterField(String where) {
        HashSet<String> result = new HashSet<String>();
        try {
            SqlParser parser = SqlParser.create((String)where);
            SqlNode sqlNode = parser.parseExpression();
            SqlParseUtils.getFieldByExpression(sqlNode, result);
            return result;
        }
        catch (SqlParseException e) {
            throw new RuntimeException("getSqlParseInfo", e);
        }
    }

    public static void getFieldByExpression(SqlNode sqlNode, Set<String> fields) {
        if (sqlNode instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
            fields.add(((String)sqlIdentifier.names.get(0)).toLowerCase());
            return;
        }
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            for (SqlNode operand : sqlBasicCall.getOperandList()) {
                SqlParseUtils.getFieldByExpression(operand, fields);
            }
        }
    }

    public static Map getCaseExprFields(String expr) {
        SqlParser parser = SqlParser.create((String)expr);
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            SqlNode sqlNodeCase = parser.parseExpression();
            if (sqlNodeCase instanceof SqlCase) {
                SqlCase sqlCase = (SqlCase)sqlNodeCase;
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)sqlCase.getThenOperands()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)sqlCase.getWhenOperands())) {
                    return ret;
                }
                S2MysqlSqlDialect dialect = new S2MysqlSqlDialect(S2MysqlSqlDialect.DEFAULT_CONTEXT);
                int i = 0;
                for (SqlNode sqlNode : sqlCase.getWhenOperands().getList()) {
                    SqlBasicCall when;
                    if (sqlNode instanceof SqlBasicCall && !CollectionUtils.isEmpty((Collection)(when = (SqlBasicCall)sqlNode).getOperandList()) && when.getOperandList().size() > 1) {
                        String value = ((SqlNode)when.getOperandList().get(1)).toSqlString((SqlDialect)dialect).getSql();
                        if (sqlCase.getThenOperands().get(i) != null && sqlCase.getThenOperands().get(i) instanceof SqlIdentifier) {
                            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlCase.getThenOperands().get(i);
                            String field = sqlIdentifier.getSimple();
                            ret.put(value, field);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (SqlParseException e) {
            throw new RuntimeException("getSqlParseInfo", e);
        }
        return ret;
    }
}

