/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DateVisitor
extends ExpressionVisitorAdapter {
    private static final Logger log = LoggerFactory.getLogger(DateVisitor.class);
    private List<String> filedNames;
    private DateBoundInfo dateBoundInfo = new DateBoundInfo();

    public DateVisitor(List<String> filedNames) {
        this.filedNames = filedNames;
    }

    public void visit(GreaterThan expr) {
        if (this.containsField(expr.getLeftExpression())) {
            this.dateBoundInfo.setColumName(SqlSelectHelper.getColumnName(expr.getLeftExpression()));
            this.dateBoundInfo.setLowerBound(expr.getStringExpression());
            String columnValue = SqlSelectHelper.getColumValue(expr.getRightExpression());
            this.dateBoundInfo.setLowerDate(columnValue);
        }
    }

    public void visit(GreaterThanEquals expr) {
        if (this.containsField(expr.getLeftExpression())) {
            this.dateBoundInfo.setColumName(SqlSelectHelper.getColumnName(expr.getLeftExpression()));
            this.dateBoundInfo.setLowerBound(expr.getStringExpression());
            String columnValue = SqlSelectHelper.getColumValue(expr.getRightExpression());
            this.dateBoundInfo.setLowerDate(columnValue);
        }
    }

    public void visit(MinorThanEquals expr) {
        if (this.containsField(expr.getLeftExpression())) {
            this.dateBoundInfo.setColumName(SqlSelectHelper.getColumnName(expr.getLeftExpression()));
            this.dateBoundInfo.setUpperBound(expr.getStringExpression());
            String columnValue = SqlSelectHelper.getColumValue(expr.getRightExpression());
            this.dateBoundInfo.setUpperDate(columnValue);
        }
    }

    public void visit(MinorThan expr) {
        if (this.containsField(expr.getLeftExpression())) {
            this.dateBoundInfo.setColumName(SqlSelectHelper.getColumnName(expr.getLeftExpression()));
            this.dateBoundInfo.setUpperBound(expr.getStringExpression());
            String columnValue = SqlSelectHelper.getColumValue(expr.getRightExpression());
            this.dateBoundInfo.setUpperDate(columnValue);
        }
    }

    private boolean containsField(Expression expr) {
        if (expr instanceof Column) {
            Column column = (Column)expr;
            if (!CollectionUtils.isEmpty(this.filedNames) && this.filedNames.contains(column.getColumnName())) {
                return true;
            }
        }
        return false;
    }

    public DateBoundInfo getDateBoundInfo() {
        return this.dateBoundInfo;
    }

    public class DateBoundInfo {
        private String columName;
        private String lowerBound;
        private String lowerDate;
        private String upperBound;
        private String upperDate;

        public String getColumName() {
            return this.columName;
        }

        public String getLowerBound() {
            return this.lowerBound;
        }

        public String getLowerDate() {
            return this.lowerDate;
        }

        public String getUpperBound() {
            return this.upperBound;
        }

        public String getUpperDate() {
            return this.upperDate;
        }

        public void setColumName(String columName) {
            this.columName = columName;
        }

        public void setLowerBound(String lowerBound) {
            this.lowerBound = lowerBound;
        }

        public void setLowerDate(String lowerDate) {
            this.lowerDate = lowerDate;
        }

        public void setUpperBound(String upperBound) {
            this.upperBound = upperBound;
        }

        public void setUpperDate(String upperDate) {
            this.upperDate = upperDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DateBoundInfo)) {
                return false;
            }
            DateBoundInfo other = (DateBoundInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columName = this.getColumName();
            String other$columName = other.getColumName();
            if (this$columName == null ? other$columName != null : !this$columName.equals(other$columName)) {
                return false;
            }
            String this$lowerBound = this.getLowerBound();
            String other$lowerBound = other.getLowerBound();
            if (this$lowerBound == null ? other$lowerBound != null : !this$lowerBound.equals(other$lowerBound)) {
                return false;
            }
            String this$lowerDate = this.getLowerDate();
            String other$lowerDate = other.getLowerDate();
            if (this$lowerDate == null ? other$lowerDate != null : !this$lowerDate.equals(other$lowerDate)) {
                return false;
            }
            String this$upperBound = this.getUpperBound();
            String other$upperBound = other.getUpperBound();
            if (this$upperBound == null ? other$upperBound != null : !this$upperBound.equals(other$upperBound)) {
                return false;
            }
            String this$upperDate = this.getUpperDate();
            String other$upperDate = other.getUpperDate();
            return !(this$upperDate == null ? other$upperDate != null : !this$upperDate.equals(other$upperDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DateBoundInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columName = this.getColumName();
            result = result * 59 + ($columName == null ? 43 : $columName.hashCode());
            String $lowerBound = this.getLowerBound();
            result = result * 59 + ($lowerBound == null ? 43 : $lowerBound.hashCode());
            String $lowerDate = this.getLowerDate();
            result = result * 59 + ($lowerDate == null ? 43 : $lowerDate.hashCode());
            String $upperBound = this.getUpperBound();
            result = result * 59 + ($upperBound == null ? 43 : $upperBound.hashCode());
            String $upperDate = this.getUpperDate();
            result = result * 59 + ($upperDate == null ? 43 : $upperDate.hashCode());
            return result;
        }

        public String toString() {
            return "DateVisitor.DateBoundInfo(columName=" + this.getColumName() + ", lowerBound=" + this.getLowerBound() + ", lowerDate=" + this.getLowerDate() + ", upperBound=" + this.getUpperBound() + ", upperDate=" + this.getUpperDate() + ")";
        }
    }
}

