/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.lang3.StringUtils;

public class FilterRemoveVisitor
extends ExpressionVisitorAdapter {
    private List<String> filedNames;

    public FilterRemoveVisitor(List<String> filedNames) {
        this.filedNames = filedNames;
    }

    private boolean isRemove(Expression leftExpression) {
        if (!(leftExpression instanceof Column)) {
            return false;
        }
        Column leftColumnName = (Column)leftExpression;
        String columnName = leftColumnName.getColumnName();
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            return false;
        }
        return this.filedNames.contains(columnName);
    }

    public void visit(EqualsTo expr) {
        if (!this.isRemove(expr.getLeftExpression())) {
            return;
        }
        expr.setRightExpression((Expression)new LongValue(1L));
        expr.setLeftExpression((Expression)new LongValue(1L));
    }

    public void visit(MinorThan expr) {
        if (!this.isRemove(expr.getLeftExpression())) {
            return;
        }
        expr.setRightExpression((Expression)new LongValue(1L));
        expr.setLeftExpression((Expression)new LongValue(0L));
    }

    public void visit(MinorThanEquals expr) {
        if (!this.isRemove(expr.getLeftExpression())) {
            return;
        }
        expr.setRightExpression((Expression)new LongValue(1L));
        expr.setLeftExpression((Expression)new LongValue(1L));
    }

    public void visit(GreaterThan expr) {
        if (!this.isRemove(expr.getLeftExpression())) {
            return;
        }
        expr.setRightExpression((Expression)new LongValue(0L));
        expr.setLeftExpression((Expression)new LongValue(1L));
    }

    public void visit(GreaterThanEquals expr) {
        if (!this.isRemove(expr.getLeftExpression())) {
            return;
        }
        expr.setRightExpression((Expression)new LongValue(1L));
        expr.setLeftExpression((Expression)new LongValue(1L));
    }

    public void visit(InExpression expr) {
        if (!this.isRemove(expr.getLeftExpression())) {
            return;
        }
        expr.setNot(false);
        expr.setRightExpression((Expression)new LongValue(1L));
        expr.setLeftExpression((Expression)new LongValue(1L));
    }
}

