/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SelectItem;

public class QueryExpressionReplaceVisitor
extends ExpressionVisitorAdapter {
    private Map<String, String> fieldExprMap;

    public QueryExpressionReplaceVisitor(Map<String, String> fieldExprMap) {
        this.fieldExprMap = fieldExprMap;
    }

    protected void visitBinaryExpression(BinaryExpression expr) {
        Expression expression;
        Function leftFunc;
        Expression left = expr.getLeftExpression();
        String toReplace = "";
        if (left instanceof Function && (leftFunc = (Function)left).getParameters().getExpressions().get(0) instanceof Column) {
            toReplace = QueryExpressionReplaceVisitor.getReplaceExpr(leftFunc, this.fieldExprMap);
        }
        if (left instanceof Column) {
            toReplace = QueryExpressionReplaceVisitor.getReplaceExpr((Column)left, this.fieldExprMap);
        }
        if (!toReplace.isEmpty() && Objects.nonNull(expression = QueryExpressionReplaceVisitor.getExpression(toReplace))) {
            expr.setLeftExpression(expression);
            return;
        }
        expr.getLeftExpression().accept((ExpressionVisitor)this);
        expr.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SelectItem selectExpressionItem) {
        Expression toReplaceExpr;
        Function leftFunc;
        Expression expression = selectExpressionItem.getExpression();
        String toReplace = "";
        String columnName = "";
        if (expression instanceof Function && (leftFunc = (Function)expression).getParameters().getExpressions().get(0) instanceof Column) {
            Column column = (Column)leftFunc.getParameters().getExpressions().get(0);
            columnName = column.getColumnName();
            toReplace = QueryExpressionReplaceVisitor.getReplaceExpr(leftFunc, this.fieldExprMap);
        }
        if (expression instanceof Column) {
            Column column = (Column)expression;
            columnName = column.getColumnName();
            toReplace = QueryExpressionReplaceVisitor.getReplaceExpr((Column)expression, this.fieldExprMap);
        }
        if (!toReplace.isEmpty() && Objects.nonNull(toReplaceExpr = QueryExpressionReplaceVisitor.getExpression(toReplace))) {
            selectExpressionItem.setExpression(toReplaceExpr);
            if (Objects.isNull(selectExpressionItem.getAlias())) {
                selectExpressionItem.setAlias(new Alias(columnName, true));
            }
        }
    }

    public static Expression replace(Expression expression, Map<String, String> fieldExprMap) {
        Expression replace;
        String toReplace = "";
        if (expression instanceof Function) {
            toReplace = QueryExpressionReplaceVisitor.getReplaceExpr((Function)expression, fieldExprMap);
        }
        if (expression instanceof Column) {
            toReplace = QueryExpressionReplaceVisitor.getReplaceExpr((Column)expression, fieldExprMap);
        }
        if (!toReplace.isEmpty() && Objects.nonNull(replace = QueryExpressionReplaceVisitor.getExpression(toReplace))) {
            return replace;
        }
        return expression;
    }

    public static Expression getExpression(String expr) {
        if (expr.isEmpty()) {
            return null;
        }
        try {
            Expression expression = CCJSqlParserUtil.parseExpression((String)expr);
            return expression;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getReplaceExpr(Column column, Map<String, String> fieldExprMap) {
        return fieldExprMap.containsKey(column.getColumnName()) ? fieldExprMap.get(column.getColumnName()) : "";
    }

    public static String getReplaceExpr(Function function, Map<String, String> fieldExprMap) {
        Column column = (Column)function.getParameters().getExpressions().get(0);
        return QueryExpressionReplaceVisitor.getReplaceExpr(column, fieldExprMap);
    }
}

