/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.SqlEditEnum;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlRemoveHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlRemoveHelper.class);

    public static String removeAsteriskAndAddFields(String sql, Set<String> needAddDefaultFields) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (Objects.isNull(selectStatement)) {
            return sql;
        }
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        List selectItems = ((PlainSelect)selectStatement).getSelectItems();
        if (selectItems.stream().anyMatch(item -> item.getExpression() instanceof AllColumns)) {
            selectItems.clear();
            ArrayList<SelectItem> columnSelectItems = new ArrayList<SelectItem>();
            for (String fieldName : needAddDefaultFields) {
                SelectItem selectExpressionItem = new SelectItem((Expression)new Column(fieldName));
                columnSelectItems.add(selectExpressionItem);
            }
            selectItems.addAll(columnSelectItems);
        }
        return selectStatement.toString();
    }

    public static String removeSameFieldFromSelect(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return sql;
        }
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        List selectItems = ((PlainSelect)selectStatement).getSelectItems();
        HashSet fields = new HashSet();
        selectItems.removeIf(selectItem -> {
            String field = selectItem.getExpression().toString();
            if (fields.contains(field)) {
                return true;
            }
            fields.add(field);
            return false;
        });
        ((PlainSelect)selectStatement).setSelectItems(selectItems);
        return selectStatement.toString();
    }

    public static String removeWhereCondition(String sql, final Set<String> removeFieldNames) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        selectStatement.accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                SqlRemoveHelper.removeWhereCondition(plainSelect.getWhere(), (Set<String>)removeFieldNames);
            }
        });
        return SqlRemoveHelper.removeNumberFilter(selectStatement.toString());
    }

    private static void removeWhereCondition(Expression whereExpression, Set<String> removeFieldNames) {
        if (whereExpression == null) {
            return;
        }
        SqlRemoveHelper.removeWhereExpression(whereExpression, removeFieldNames);
    }

    public static String removeNumberFilter(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return sql;
        }
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        Expression where = ((PlainSelect)selectStatement).getWhere();
        Expression having = ((PlainSelect)selectStatement).getHaving();
        try {
            ((PlainSelect)selectStatement).setWhere(SqlRemoveHelper.filteredExpression(where, SqlEditEnum.NUMBER_FILTER));
            ((PlainSelect)selectStatement).setHaving(SqlRemoveHelper.filteredExpression(having, SqlEditEnum.NUMBER_FILTER));
        }
        catch (Exception e) {
            log.info("replaceFunction has an exception:{}", (Object)e.toString());
        }
        return selectStatement.toString();
    }

    private static void removeWhereExpression(Expression whereExpression, Set<String> removeFieldNames) {
        if (SqlSelectHelper.isLogicExpression(whereExpression)) {
            BinaryExpression binaryExpression = (BinaryExpression)whereExpression;
            Expression leftExpression = binaryExpression.getLeftExpression();
            Expression rightExpression = binaryExpression.getRightExpression();
            SqlRemoveHelper.removeWhereExpression(leftExpression, removeFieldNames);
            SqlRemoveHelper.removeWhereExpression(rightExpression, removeFieldNames);
        } else if (whereExpression instanceof Parenthesis) {
            SqlRemoveHelper.removeWhereExpression(((Parenthesis)whereExpression).getExpression(), removeFieldNames);
        } else {
            SqlRemoveHelper.removeExpressionWithConstant(whereExpression, removeFieldNames);
        }
    }

    public static String getConstant(Expression expression) {
        String constant = " 1 = 1 ";
        if (expression instanceof GreaterThanEquals) {
            constant = " 1 >= 1 ";
        } else if (expression instanceof MinorThanEquals) {
            constant = " 1 <= 1 ";
        } else if (expression instanceof GreaterThan) {
            constant = " 2 > 1 ";
        } else if (expression instanceof MinorThan) {
            constant = " 1 < 2 ";
        }
        return constant;
    }

    private static void removeExpressionWithConstant(Expression expression, Set<String> removeFieldNames) {
        InExpression constantExpression;
        String columnName;
        if (expression instanceof EqualsTo || expression instanceof GreaterThanEquals || expression instanceof GreaterThan || expression instanceof MinorThanEquals || expression instanceof MinorThan) {
            ComparisonOperator comparisonOperator = (ComparisonOperator)expression;
            columnName = SqlSelectHelper.getColumnName(comparisonOperator.getLeftExpression(), comparisonOperator.getRightExpression());
            if (!removeFieldNames.contains(columnName)) {
                return;
            }
            String constant = SqlRemoveHelper.getConstant(expression);
            try {
                ComparisonOperator constantExpression2 = (ComparisonOperator)CCJSqlParserUtil.parseCondExpression((String)constant);
                comparisonOperator.setLeftExpression(constantExpression2.getLeftExpression());
                comparisonOperator.setRightExpression(constantExpression2.getRightExpression());
                comparisonOperator.setASTNode(constantExpression2.getASTNode());
            }
            catch (JSQLParserException e) {
                log.error("JSQLParserException", (Throwable)e);
            }
        }
        if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            columnName = SqlSelectHelper.getColumnName(inExpression.getLeftExpression(), inExpression.getRightExpression());
            if (!removeFieldNames.contains(columnName)) {
                return;
            }
            try {
                constantExpression = (InExpression)CCJSqlParserUtil.parseCondExpression((String)" 1 in (1) ");
                inExpression.setLeftExpression(constantExpression.getLeftExpression());
                inExpression.setRightExpression(constantExpression.getRightExpression());
                inExpression.setASTNode(constantExpression.getASTNode());
            }
            catch (JSQLParserException e) {
                log.error("JSQLParserException", (Throwable)e);
            }
        }
        if (expression instanceof LikeExpression) {
            LikeExpression likeExpression = (LikeExpression)expression;
            columnName = SqlSelectHelper.getColumnName(likeExpression.getLeftExpression(), likeExpression.getRightExpression());
            if (!removeFieldNames.contains(columnName)) {
                return;
            }
            try {
                constantExpression = (LikeExpression)CCJSqlParserUtil.parseCondExpression((String)"1 like 1");
                likeExpression.setLeftExpression(constantExpression.getLeftExpression());
                likeExpression.setRightExpression(constantExpression.getRightExpression());
            }
            catch (JSQLParserException e) {
                log.error("JSQLParserException", (Throwable)e);
            }
        }
    }

    public static String removeHavingCondition(String sql, final Set<String> removeFieldNames) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        selectStatement.accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                SqlRemoveHelper.removeWhereCondition(plainSelect.getHaving(), (Set<String>)removeFieldNames);
            }
        });
        return SqlRemoveHelper.removeNumberFilter(selectStatement.toString());
    }

    public static String removeGroupBy(String sql, Set<String> fields) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return sql;
        }
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        GroupByElement groupByElement = ((PlainSelect)selectStatement).getGroupBy();
        if (groupByElement == null) {
            return sql;
        }
        ExpressionList groupByExpressionList = groupByElement.getGroupByExpressionList();
        groupByExpressionList.getExpressions().removeIf(expression -> {
            if (expression instanceof Column) {
                Column column = (Column)expression;
                return fields.contains(column.getColumnName());
            }
            return false;
        });
        if (CollectionUtils.isEmpty((Collection)groupByExpressionList.getExpressions())) {
            ((PlainSelect)selectStatement).setGroupByElement(null);
        }
        return selectStatement.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expression filteredExpression(Expression where, SqlEditEnum sqlEditEnum) throws Exception {
        if (Objects.isNull(where)) {
            return null;
        }
        if (where instanceof Parenthesis) {
            Expression expression = SqlRemoveHelper.filteredExpression(((Parenthesis)where).getExpression(), sqlEditEnum);
            if (expression == null) return expression;
            try {
                return CCJSqlParserUtil.parseExpression((String)("(" + expression + ")"));
            }
            catch (JSQLParserException jsqlParserException) {
                log.info("jsqlParser has an exception:{}", (Object)jsqlParserException.toString());
                return where;
            }
        } else {
            if (where instanceof AndExpression) {
                AndExpression andExpression = (AndExpression)where;
                return SqlRemoveHelper.filteredLogicExpression(andExpression, sqlEditEnum);
            }
            if (!(where instanceof OrExpression)) return SqlRemoveHelper.dealComparisonOperatorFilter(where, sqlEditEnum);
            OrExpression orExpression = (OrExpression)where;
            return SqlRemoveHelper.filteredLogicExpression(orExpression, sqlEditEnum);
        }
    }

    private static <T extends BinaryExpression> Expression filteredLogicExpression(T binaryExpression, SqlEditEnum sqlEditEnum) throws Exception {
        Expression leftExpression = SqlRemoveHelper.filteredExpression(binaryExpression.getLeftExpression(), sqlEditEnum);
        Expression rightExpression = SqlRemoveHelper.filteredExpression(binaryExpression.getRightExpression(), sqlEditEnum);
        if (leftExpression != null && rightExpression != null) {
            binaryExpression.setLeftExpression(leftExpression);
            binaryExpression.setRightExpression(rightExpression);
            return binaryExpression;
        }
        if (leftExpression != null && rightExpression == null) {
            return leftExpression;
        }
        if (leftExpression == null && rightExpression != null) {
            return rightExpression;
        }
        return null;
    }

    private static Expression dealComparisonOperatorFilter(Expression expression, SqlEditEnum sqlEditEnum) {
        if (Objects.isNull(expression)) {
            return null;
        }
        if (expression instanceof GreaterThanEquals || expression instanceof GreaterThan || expression instanceof MinorThan || expression instanceof MinorThanEquals || expression instanceof EqualsTo || expression instanceof NotEqualsTo) {
            return SqlRemoveHelper.removeSingleFilter((ComparisonOperator)expression, sqlEditEnum);
        }
        if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            Expression leftExpression = inExpression.getLeftExpression();
            return SqlRemoveHelper.recursionBase(leftExpression, expression, sqlEditEnum);
        }
        if (expression instanceof LikeExpression) {
            LikeExpression likeExpression = (LikeExpression)expression;
            Expression leftExpression = likeExpression.getLeftExpression();
            return SqlRemoveHelper.recursionBase(leftExpression, expression, sqlEditEnum);
        }
        return expression;
    }

    private static Expression removeSingleFilter(ComparisonOperator comparisonExpression, SqlEditEnum sqlEditEnum) {
        Expression leftExpression = comparisonExpression.getLeftExpression();
        return SqlRemoveHelper.recursionBase(leftExpression, (Expression)comparisonExpression, sqlEditEnum);
    }

    private static Expression recursionBase(Expression leftExpression, Expression expression, SqlEditEnum sqlEditEnum) {
        if (sqlEditEnum.equals((Object)SqlEditEnum.NUMBER_FILTER)) {
            return SqlRemoveHelper.distinguishNumberFilter(leftExpression, expression);
        }
        if (sqlEditEnum.equals((Object)SqlEditEnum.DATEDIFF)) {
            return SqlReplaceHelper.distinguishDateDiffFilter(leftExpression, expression);
        }
        return expression;
    }

    private static Expression distinguishNumberFilter(Expression leftExpression, Expression expression) {
        if (leftExpression instanceof LongValue) {
            return null;
        }
        return expression;
    }
}

