/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.DateFunctionHelper;
import com.tencent.supersonic.common.jsqlparser.ExpressionReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.FieldReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.FieldlValueReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.FiledNameReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.FunctionAliasReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.FunctionNameReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.GroupByFunctionReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.GroupByReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.JsqlConstants;
import com.tencent.supersonic.common.jsqlparser.OrderByReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.QueryExpressionReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.SqlEditEnum;
import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.jsqlparser.TableNameReplaceVisitor;
import com.tencent.supersonic.common.pojo.enums.AggOperatorEnum;
import com.tencent.supersonic.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.GroupByVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlReplaceHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlReplaceHelper.class);

    public static String replaceSelectFields(String sql, Map<String, String> fieldNameMap) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        ((PlainSelect)selectStatement).getSelectItems().stream().forEach(o -> {
            Column column;
            String columnName;
            String value;
            Function function;
            Column column2;
            SelectItem selectExpressionItem = o;
            String alias = "";
            if (selectExpressionItem.getExpression() instanceof Function && fieldNameMap.containsKey((column2 = (Column)(function = (Function)selectExpressionItem.getExpression()).getParameters().getExpressions().get(0)).getColumnName())) {
                alias = value = (String)fieldNameMap.get(column2.getColumnName());
                function.withParameters(new Expression[]{new Column(value)});
            }
            if (selectExpressionItem.getExpression() instanceof Column && fieldNameMap.containsKey(columnName = (column = (Column)selectExpressionItem.getExpression()).getColumnName())) {
                alias = value = (String)fieldNameMap.get(columnName);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    selectExpressionItem.setExpression((Expression)new Column(value));
                }
            }
            if (Objects.nonNull(selectExpressionItem.getAlias()) && StringUtils.isNotBlank((CharSequence)alias)) {
                selectExpressionItem.getAlias().setName(alias);
            }
        });
        return selectStatement.toString();
    }

    public static String replaceAggFields(String sql, Map<String, Pair<String, String>> fieldNameToAggMap) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        ((PlainSelect)selectStatement).getSelectItems().stream().forEach(o -> {
            Function function;
            Column column;
            SelectItem selectExpressionItem = o;
            if (selectExpressionItem.getExpression() instanceof Function && fieldNameToAggMap.containsKey((column = (Column)(function = (Function)selectExpressionItem.getExpression()).getParameters().getExpressions().get(0)).getColumnName())) {
                Pair agg = (Pair)fieldNameToAggMap.get(column.getColumnName());
                String field = (String)agg.getKey();
                String func = (String)agg.getRight();
                if (AggOperatorEnum.isCountDistinct(func)) {
                    function.setName("count");
                    function.setDistinct(true);
                } else {
                    function.setName(func);
                }
                function.withParameters(new Expression[]{new Column(field)});
                if (Objects.nonNull(selectExpressionItem.getAlias()) && StringUtils.isNotBlank((CharSequence)field)) {
                    selectExpressionItem.getAlias().setName(field);
                }
            }
        });
        return selectStatement.toString();
    }

    public static String replaceValue(String sql, Map<String, Map<String, String>> filedNameToValueMap) {
        return SqlReplaceHelper.replaceValue(sql, filedNameToValueMap, true);
    }

    public static String replaceValue(String sql, Map<String, Map<String, String>> filedNameToValueMap, boolean exactReplace) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelect(selectStatement);
        for (PlainSelect plainSelect : plainSelects) {
            Expression where = plainSelect.getWhere();
            FieldlValueReplaceVisitor visitor = new FieldlValueReplaceVisitor(exactReplace, filedNameToValueMap);
            if (!Objects.nonNull(where)) continue;
            where.accept((ExpressionVisitor)visitor);
        }
        return selectStatement.toString();
    }

    public static String replaceFieldNameByValue(String sql, Map<String, Set<String>> fieldValueToFieldNames) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        plainSelectList.add((PlainSelect)selectStatement);
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelects(plainSelectList);
        for (PlainSelect plainSelect : plainSelects) {
            Expression where = plainSelect.getWhere();
            FiledNameReplaceVisitor visitor = new FiledNameReplaceVisitor(fieldValueToFieldNames);
            if (!Objects.nonNull(where)) continue;
            where.accept((ExpressionVisitor)visitor);
        }
        return selectStatement.toString();
    }

    public static void getFromSelect(FromItem fromItem, List<PlainSelect> plainSelectList) {
        SetOperationList setOperationList;
        if (!(fromItem instanceof ParenthesedSelect)) {
            return;
        }
        ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
        Select select = parenthesedSelect.getSelect();
        if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            plainSelectList.add(plainSelect);
            SqlReplaceHelper.getFromSelect(plainSelect.getFromItem(), plainSelectList);
        } else if (select instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)select).getSelects())) {
            setOperationList.getSelects().forEach(subSelectBody -> {
                PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                plainSelectList.add(subPlainSelect);
                SqlReplaceHelper.getFromSelect(subPlainSelect.getFromItem(), plainSelectList);
            });
        }
    }

    public static String replaceFields(String sql, Map<String, String> fieldNameMap) {
        return SqlReplaceHelper.replaceFields(sql, fieldNameMap, false);
    }

    public static String replaceFields(String sql, Map<String, String> fieldNameMap, boolean exactReplace) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        List<PlainSelect> plainSelectList = SqlSelectHelper.getWithItem(selectStatement);
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectStatement;
            plainSelectList.add(plainSelect);
            SqlReplaceHelper.getFromSelect(plainSelect.getFromItem(), plainSelectList);
        } else if (selectStatement instanceof SetOperationList) {
            List orderByElements;
            SetOperationList setOperationList = (SetOperationList)selectStatement;
            if (!CollectionUtils.isEmpty((Collection)setOperationList.getSelects())) {
                setOperationList.getSelects().forEach(subSelectBody -> {
                    PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                    plainSelectList.add(subPlainSelect);
                    SqlReplaceHelper.getFromSelect(subPlainSelect.getFromItem(), plainSelectList);
                });
            }
            if (!CollectionUtils.isEmpty((Collection)(orderByElements = setOperationList.getOrderByElements()))) {
                for (OrderByElement orderByElement : orderByElements) {
                    orderByElement.accept((OrderByVisitor)new OrderByReplaceVisitor(fieldNameMap, exactReplace));
                }
            }
        } else {
            return sql;
        }
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelects(plainSelectList);
        for (PlainSelect plainSelect : plainSelects) {
            SqlReplaceHelper.replaceFieldsInPlainOneSelect(fieldNameMap, exactReplace, plainSelect);
        }
        return selectStatement.toString();
    }

    private static void replaceFieldsInPlainOneSelect(Map<String, String> fieldNameMap, boolean exactReplace, PlainSelect plainSelect) {
        List joins;
        Expression having;
        GroupByElement groupByElement;
        List orderByElements;
        Expression where = plainSelect.getWhere();
        FieldReplaceVisitor visitor = new FieldReplaceVisitor(fieldNameMap, exactReplace);
        if (Objects.nonNull(where)) {
            where.accept((ExpressionVisitor)visitor);
        }
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)visitor);
            SqlReplaceHelper.replaceAsName(fieldNameMap, selectItem);
        }
        if (plainSelect.getFromItem() instanceof ParenthesedSelect) {
            SetOperationList setOperationList;
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
            Select select = parenthesedSelect.getSelect();
            if (select instanceof PlainSelect) {
                PlainSelect subPlainSelect = (PlainSelect)select;
                SqlReplaceHelper.replaceFieldsInPlainOneSelect(fieldNameMap, exactReplace, subPlainSelect);
            } else if (select instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)select).getSelects())) {
                setOperationList.getSelects().forEach(subSelectBody -> {
                    PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                    SqlReplaceHelper.replaceFieldsInPlainOneSelect(fieldNameMap, exactReplace, subPlainSelect);
                });
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(orderByElements = plainSelect.getOrderByElements()))) {
            for (OrderByElement orderByElement : orderByElements) {
                orderByElement.accept((OrderByVisitor)new OrderByReplaceVisitor(fieldNameMap, exactReplace));
            }
        }
        if (Objects.nonNull(groupByElement = plainSelect.getGroupBy())) {
            groupByElement.accept((GroupByVisitor)new GroupByReplaceVisitor(fieldNameMap, exactReplace));
        }
        if (Objects.nonNull(having = plainSelect.getHaving())) {
            having.accept((ExpressionVisitor)visitor);
        }
        if (!CollectionUtils.isEmpty((Collection)(joins = plainSelect.getJoins()))) {
            for (Join join : joins) {
                if (!CollectionUtils.isEmpty((Collection)join.getOnExpressions())) {
                    join.getOnExpressions().stream().forEach(onExpression -> onExpression.accept((ExpressionVisitor)visitor));
                }
                if (!(join.getRightItem() instanceof ParenthesedSelect)) continue;
                ParenthesedSelect parenthesedSelect = (ParenthesedSelect)join.getRightItem();
                ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
                plainSelectList.add(parenthesedSelect.getPlainSelect());
                List<PlainSelect> subPlainSelects = SqlSelectHelper.getPlainSelects(plainSelectList);
                for (PlainSelect subPlainSelect : subPlainSelects) {
                    SqlReplaceHelper.replaceFieldsInPlainOneSelect(fieldNameMap, exactReplace, subPlainSelect);
                }
            }
        }
    }

    private static void replaceAsName(Map<String, String> fieldNameMap, SelectItem selectItem) {
        Alias alias = selectItem.getAlias();
        if (Objects.isNull(alias)) {
            return;
        }
        String aliasName = alias.getName();
        String replaceFieldName = fieldNameMap.get(aliasName);
        if (StringUtils.isNotBlank((CharSequence)replaceFieldName)) {
            alias.setName(replaceFieldName);
        }
    }

    public static String replaceFunction(String sql, Map<String, String> functionMap) {
        return SqlReplaceHelper.replaceFunction(sql, functionMap, null);
    }

    public static String replaceFunction(String sql, Map<String, String> functionMap, Map<String, UnaryOperator> functionCall) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        plainSelectList.add((PlainSelect)selectStatement);
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelects(plainSelectList);
        for (PlainSelect plainSelect : plainSelects) {
            SqlReplaceHelper.replaceFunction(functionMap, functionCall, plainSelect);
        }
        return selectStatement.toString();
    }

    private static void replaceFunction(Map<String, String> functionMap, Map<String, UnaryOperator> functionCall, PlainSelect selectBody) {
        GroupByElement groupBy;
        PlainSelect plainSelect = selectBody;
        Expression where = plainSelect.getWhere();
        FunctionNameReplaceVisitor visitor = new FunctionNameReplaceVisitor(functionMap, functionCall);
        if (Objects.nonNull(where)) {
            where.accept((ExpressionVisitor)visitor);
        }
        if (Objects.nonNull(groupBy = plainSelect.getGroupBy())) {
            GroupByFunctionReplaceVisitor replaceVisitor = new GroupByFunctionReplaceVisitor(functionMap, functionCall);
            groupBy.accept((GroupByVisitor)replaceVisitor);
        }
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)visitor);
        }
        Expression having = plainSelect.getHaving();
        if (Objects.nonNull(having)) {
            SqlReplaceHelper.replaceHavingFunction(functionMap, having);
        }
        List orderByElementList = plainSelect.getOrderByElements();
        SqlReplaceHelper.replaceOrderByFunction(functionMap, orderByElementList);
    }

    public static String replaceFunction(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        Expression where = ((PlainSelect)selectStatement).getWhere();
        try {
            Expression expression = SqlRemoveHelper.filteredExpression(where, SqlEditEnum.DATEDIFF);
            ((PlainSelect)selectStatement).setWhere(expression);
        }
        catch (Exception e) {
            log.info("replaceFunction has an exception:{}", (Object)e.toString());
        }
        return selectStatement.toString();
    }

    private static void replaceHavingFunction(Map<String, String> functionMap, Expression having) {
        if (Objects.nonNull(having)) {
            if (having instanceof AndExpression) {
                AndExpression andExpression = (AndExpression)having;
                SqlReplaceHelper.replaceHavingFunction(functionMap, andExpression.getLeftExpression());
                SqlReplaceHelper.replaceHavingFunction(functionMap, andExpression.getRightExpression());
            } else if (having instanceof OrExpression) {
                OrExpression orExpression = (OrExpression)having;
                SqlReplaceHelper.replaceHavingFunction(functionMap, orExpression.getLeftExpression());
                SqlReplaceHelper.replaceHavingFunction(functionMap, orExpression.getRightExpression());
            } else {
                SqlReplaceHelper.replaceComparisonOperatorFunction(functionMap, having);
            }
        }
    }

    private static void replaceComparisonOperatorFunction(Map<String, String> functionMap, Expression expression) {
        if (Objects.isNull(expression)) {
            return;
        }
        if (expression instanceof GreaterThanEquals) {
            SqlReplaceHelper.replaceFilterFunction(functionMap, (GreaterThanEquals)expression);
        } else if (expression instanceof GreaterThan) {
            SqlReplaceHelper.replaceFilterFunction(functionMap, (GreaterThan)expression);
        } else if (expression instanceof MinorThan) {
            SqlReplaceHelper.replaceFilterFunction(functionMap, (MinorThan)expression);
        } else if (expression instanceof MinorThanEquals) {
            SqlReplaceHelper.replaceFilterFunction(functionMap, (MinorThanEquals)expression);
        } else if (expression instanceof EqualsTo) {
            SqlReplaceHelper.replaceFilterFunction(functionMap, (EqualsTo)expression);
        } else if (expression instanceof NotEqualsTo) {
            SqlReplaceHelper.replaceFilterFunction(functionMap, (NotEqualsTo)expression);
        }
    }

    private static void replaceOrderByFunction(Map<String, String> functionMap, List<OrderByElement> orderByElementList) {
        if (Objects.isNull(orderByElementList)) {
            return;
        }
        for (OrderByElement orderByElement : orderByElementList) {
            Function function;
            if (!(orderByElement.getExpression() instanceof Function) || !functionMap.containsKey((function = (Function)orderByElement.getExpression()).getName())) continue;
            function.setName(functionMap.get(function.getName()));
        }
    }

    private static <T extends ComparisonOperator> void replaceFilterFunction(Map<String, String> functionMap, T comparisonExpression) {
        Function function;
        Expression expression = comparisonExpression.getLeftExpression();
        if (expression instanceof Function && functionMap.containsKey((function = (Function)expression).getName())) {
            function.setName(functionMap.get(function.getName()));
        }
    }

    public static String replaceTable(String sql, String tableName) {
        SetOperationList setOperationList;
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return sql;
        }
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        List<PlainSelect> plainSelectList = SqlSelectHelper.getWithItem(selectStatement);
        if (!CollectionUtils.isEmpty(plainSelectList)) {
            List<String> withNameList = SqlSelectHelper.getWithName(sql);
            plainSelectList.stream().forEach(plainSelect -> {
                ParenthesedSelect parenthesedSelect;
                PlainSelect subPlainSelect;
                Table table;
                Table table2;
                if (plainSelect.getFromItem() instanceof Table && !withNameList.contains((table2 = (Table)plainSelect.getFromItem()).getName())) {
                    SqlReplaceHelper.replaceSingleTable(plainSelect, tableName);
                }
                if (plainSelect.getFromItem() instanceof ParenthesedSelect && !withNameList.contains((table = (Table)(subPlainSelect = (parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem()).getPlainSelect()).getFromItem()).getName())) {
                    SqlReplaceHelper.replaceSingleTable(subPlainSelect, tableName);
                }
            });
            return selectStatement.toString();
        }
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect2 = (PlainSelect)selectStatement;
            SqlReplaceHelper.replaceSingleTable(plainSelect2, tableName);
            SqlReplaceHelper.replaceSubTable(plainSelect2, tableName);
        } else if (selectStatement instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)selectStatement).getSelects())) {
            setOperationList.getSelects().forEach(subSelectBody -> {
                PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                SqlReplaceHelper.replaceSingleTable(subPlainSelect, tableName);
                SqlReplaceHelper.replaceSubTable(subPlainSelect, tableName);
            });
        }
        return selectStatement.toString();
    }

    public static void replaceSubTable(PlainSelect plainSelect, String tableName) {
        List joinList;
        if (plainSelect.getFromItem() instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
            PlainSelect subPlainSelect = parenthesedSelect.getPlainSelect();
            SqlReplaceHelper.replaceSingleTable(subPlainSelect, tableName);
        }
        if (CollectionUtils.isEmpty((Collection)(joinList = plainSelect.getJoins()))) {
            return;
        }
        for (Join join : joinList) {
            if (!(join.getFromItem() instanceof ParenthesedSelect)) continue;
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)join.getFromItem();
            SqlReplaceHelper.replaceSingleTable(parenthesedSelect.getPlainSelect(), tableName);
        }
    }

    public static void replaceSingleTable(PlainSelect plainSelect, final String tableName) {
        ArrayList<PlainSelect> plainSelects = new ArrayList<PlainSelect>();
        plainSelects.add(plainSelect);
        List<PlainSelect> painSelects = SqlSelectHelper.getPlainSelects(plainSelects);
        for (PlainSelect painSelect : painSelects) {
            painSelect.accept((SelectVisitor)new SelectVisitorAdapter(){

                public void visit(PlainSelect plainSelect) {
                    plainSelect.getFromItem().accept((FromItemVisitor)new TableNameReplaceVisitor(tableName));
                }
            });
            List joins = painSelect.getJoins();
            if (CollectionUtils.isEmpty((Collection)joins)) continue;
            for (Join join : joins) {
                if (join.getRightItem() instanceof ParenthesedFromItem) {
                    ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
                    plainSelectList.add((PlainSelect)join.getRightItem());
                    List<PlainSelect> subPlainSelects = SqlSelectHelper.getPlainSelects(plainSelectList);
                    for (PlainSelect subPlainSelect : subPlainSelects) {
                        subPlainSelect.getFromItem().accept((FromItemVisitor)new TableNameReplaceVisitor(tableName));
                    }
                    continue;
                }
                if (!(join.getRightItem() instanceof Table)) continue;
                Table table = (Table)join.getRightItem();
                table.setName(tableName);
            }
        }
    }

    public static String replaceAlias(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        FunctionAliasReplaceVisitor visitor = new FunctionAliasReplaceVisitor();
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)visitor);
        }
        Map<String, String> aliasToActualExpression = visitor.getAliasToActualExpression();
        if (Objects.nonNull(aliasToActualExpression) && !aliasToActualExpression.isEmpty()) {
            return SqlReplaceHelper.replaceFields(selectStatement.toString(), aliasToActualExpression, true);
        }
        return selectStatement.toString();
    }

    public static String replaceHavingValue(String sql, Map<String, Map<String, String>> filedNameToValueMap) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Expression having = plainSelect.getHaving();
        FieldlValueReplaceVisitor visitor = new FieldlValueReplaceVisitor(false, filedNameToValueMap);
        if (Objects.nonNull(having)) {
            having.accept((ExpressionVisitor)visitor);
        }
        return selectStatement.toString();
    }

    public static Expression distinguishDateDiffFilter(Expression leftExpression, Expression expression) {
        if (leftExpression instanceof Function) {
            Function function = (Function)leftExpression;
            if (function.getName().equals("datediff")) {
                ComparisonOperator comparisonOperator = (ComparisonOperator)expression;
                ExpressionList leftExpressions = function.getParameters();
                Column field = (Column)function.getParameters().getExpressions().get(1);
                String columnName = field.getColumnName();
                try {
                    String startDateValue = DateFunctionHelper.getStartDateStr(comparisonOperator, leftExpressions);
                    String endDateValue = DateFunctionHelper.getEndDateValue(leftExpressions);
                    String dateOperator = comparisonOperator.getStringExpression();
                    String endDateOperator = JsqlConstants.rightMap.get(dateOperator);
                    String startDateOperator = JsqlConstants.leftMap.get(dateOperator);
                    String endDateCondExpr = columnName + endDateOperator + StringUtil.getCommaWrap(endDateValue);
                    ComparisonOperator rightExpression = (ComparisonOperator)CCJSqlParserUtil.parseCondExpression((String)endDateCondExpr);
                    String startDateCondExpr = columnName + StringUtil.getSpaceWrap(startDateOperator) + StringUtil.getCommaWrap(startDateValue);
                    ComparisonOperator newLeftExpression = (ComparisonOperator)CCJSqlParserUtil.parseCondExpression((String)startDateCondExpr);
                    AndExpression andExpression = new AndExpression((Expression)newLeftExpression, (Expression)rightExpression);
                    if (">".equals(dateOperator) || ">=".equals(dateOperator)) {
                        return newLeftExpression;
                    }
                    return CCJSqlParserUtil.parseCondExpression((String)("(" + andExpression.toString() + ")"));
                }
                catch (JSQLParserException e) {
                    log.error("JSQLParserException", (Throwable)e);
                }
            }
            return expression;
        }
        return expression;
    }

    private static Select replaceAggAliasOrderItem(Select selectStatement) {
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectStatement;
            if (Objects.nonNull(plainSelect.getOrderByElements())) {
                HashMap<String, String> selectNames = new HashMap<String, String>();
                for (int i = 0; i < plainSelect.getSelectItems().size(); ++i) {
                    Column column;
                    SelectItem f = plainSelect.getSelectItem(i);
                    if (!Objects.nonNull(f.getAlias()) || !(f.getExpression() instanceof Function)) continue;
                    Function function = (Function)f.getExpression();
                    String alias = f.getAlias().getName();
                    if (function.getParameters().size() != 1 || !(function.getParameters().get(0) instanceof Column) || !(column = (Column)function.getParameters().get(0)).getColumnName().equalsIgnoreCase(alias)) continue;
                    selectNames.put(alias, String.valueOf(i + 1));
                }
                plainSelect.getOrderByElements().stream().forEach(o -> {
                    Column column;
                    Function function;
                    if (o.getExpression() instanceof Function && (function = (Function)o.getExpression()).getParameters().size() == 1 && function.getParameters().get(0) instanceof Column && selectNames.containsKey((column = (Column)function.getParameters().get(0)).getColumnName())) {
                        o.setExpression((Expression)new LongValue((String)selectNames.get(column.getColumnName())));
                    }
                });
            }
            if (plainSelect.getFromItem() instanceof ParenthesedSelect) {
                ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
                parenthesedSelect.setSelect(SqlReplaceHelper.replaceAggAliasOrderItem(parenthesedSelect.getSelect()));
            }
            return selectStatement;
        }
        return selectStatement;
    }

    public static String replaceAggAliasOrderItem(String sql) {
        Select selectStatement = SqlReplaceHelper.replaceAggAliasOrderItem(SqlSelectHelper.getSelect(sql));
        return selectStatement.toString();
    }

    public static String replaceExpression(String expr, Map<String, String> replace) {
        Expression expression = QueryExpressionReplaceVisitor.getExpression(expr);
        if (Objects.nonNull(expression)) {
            if (expression instanceof Column && replace.containsKey(expr)) {
                return replace.get(expr);
            }
            ExpressionReplaceVisitor expressionReplaceVisitor = new ExpressionReplaceVisitor(replace);
            expression.accept((ExpressionVisitor)expressionReplaceVisitor);
            return expression.toString();
        }
        return expr;
    }

    public static String replaceSqlByExpression(String sql, Map<String, String> replace) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        if (selectStatement instanceof PlainSelect) {
            plainSelectList.add((PlainSelect)selectStatement);
        } else if (selectStatement instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectStatement;
            if (!CollectionUtils.isEmpty((Collection)setOperationList.getSelects())) {
                setOperationList.getSelects().forEach(subSelectBody -> {
                    PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                    plainSelectList.add(subPlainSelect);
                });
            }
        } else {
            return sql;
        }
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelects(plainSelectList);
        for (PlainSelect plainSelect : plainSelects) {
            SqlReplaceHelper.replacePlainSelectByExpr(plainSelect, replace);
        }
        return selectStatement.toString();
    }

    private static void replacePlainSelectByExpr(PlainSelect plainSelect, Map<String, String> replace) {
        List orderByElements;
        Expression where;
        QueryExpressionReplaceVisitor expressionReplaceVisitor = new QueryExpressionReplaceVisitor(replace);
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)expressionReplaceVisitor);
        }
        Expression having = plainSelect.getHaving();
        if (Objects.nonNull(having)) {
            having.accept((ExpressionVisitor)expressionReplaceVisitor);
        }
        if (Objects.nonNull(where = plainSelect.getWhere())) {
            where.accept((ExpressionVisitor)expressionReplaceVisitor);
        }
        if (!CollectionUtils.isEmpty((Collection)(orderByElements = plainSelect.getOrderByElements()))) {
            for (OrderByElement orderByElement : orderByElements) {
                orderByElement.setExpression(QueryExpressionReplaceVisitor.replace(orderByElement.getExpression(), replace));
            }
        }
    }

    public static String dealAliasToOrderBy(String querySql) {
        SetOperationList setOperationList;
        Select selectStatement = SqlSelectHelper.getSelect(querySql);
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        if (selectStatement instanceof PlainSelect) {
            plainSelectList.add((PlainSelect)selectStatement);
        } else if (selectStatement instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)selectStatement).getSelects())) {
            setOperationList.getSelects().forEach(subSelectBody -> {
                PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                plainSelectList.add(subPlainSelect);
            });
        }
        for (PlainSelect plainSelect : plainSelectList) {
            List selectItemList = plainSelect.getSelectItems();
            List orderByElementList = plainSelect.getOrderByElements();
            if (CollectionUtils.isEmpty((Collection)orderByElementList)) continue;
            HashMap<String, Expression> map = new HashMap<String, Expression>();
            for (int i = 0; i < selectItemList.size(); ++i) {
                if (Objects.isNull(((SelectItem)selectItemList.get(i)).getAlias())) continue;
                map.put(((SelectItem)selectItemList.get(i)).getAlias().getName(), ((SelectItem)selectItemList.get(i)).getExpression());
                ((SelectItem)selectItemList.get(i)).setAlias(null);
            }
            for (OrderByElement orderByElement : orderByElementList) {
                if (!map.containsKey(orderByElement.getExpression().toString())) continue;
                orderByElement.setExpression((Expression)map.get(orderByElement.getExpression().toString()));
            }
            plainSelect.setOrderByElements(orderByElementList);
        }
        return selectStatement.toString();
    }
}

