/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.FieldAcquireVisitor;
import com.tencent.supersonic.common.jsqlparser.FieldAndValueAcquireVisitor;
import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.GroupByVisitor;
import com.tencent.supersonic.common.jsqlparser.OrderByAcquireVisitor;
import com.tencent.supersonic.common.jsqlparser.QueryExpressionReplaceVisitor;
import com.tencent.supersonic.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlSelectHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlSelectHelper.class);

    public static List<FieldExpression> getFilterExpression(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<FieldExpression> result = new HashSet();
        for (PlainSelect plainSelect : plainSelectList) {
            Expression having;
            if (Objects.isNull(plainSelect)) continue;
            Expression where = plainSelect.getWhere();
            if (Objects.nonNull(where)) {
                where.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
            }
            if (!Objects.nonNull(having = plainSelect.getHaving())) continue;
            having.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
        }
        result = result.stream().filter(fieldExpression -> StringUtils.isNotBlank((CharSequence)fieldExpression.getFieldName())).collect(Collectors.toSet());
        return new ArrayList<FieldExpression>(result);
    }

    public static List<String> getWhereFields(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        if (CollectionUtils.isEmpty(plainSelectList)) {
            return new ArrayList<String>();
        }
        HashSet<String> result = new HashSet<String>();
        SqlSelectHelper.getWhereFields(plainSelectList, result);
        return new ArrayList<String>(result);
    }

    public static void getWhereFields(List<PlainSelect> plainSelectList, Set<String> result) {
        plainSelectList.stream().forEach(plainSelect -> {
            Expression where = plainSelect.getWhere();
            if (Objects.nonNull(where)) {
                where.accept((ExpressionVisitor)new FieldAcquireVisitor(result));
            }
        });
    }

    public static List<String> getSelectFields(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        if (CollectionUtils.isEmpty(plainSelectList)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(SqlSelectHelper.getSelectFields(plainSelectList));
    }

    public static Set<String> getSelectFields(List<PlainSelect> plainSelectList) {
        HashSet<String> result = new HashSet<String>();
        plainSelectList.stream().forEach(plainSelect -> {
            List selectItems = plainSelect.getSelectItems();
            for (SelectItem selectItem : selectItems) {
                selectItem.accept((SelectItemVisitor)new FieldAcquireVisitor(result));
            }
        });
        return result;
    }

    public static List<PlainSelect> getPlainSelect(Select selectStatement) {
        SetOperationList setOperationList;
        if (selectStatement == null) {
            return null;
        }
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        plainSelectList.addAll(SqlSelectHelper.getWithItem(selectStatement));
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectStatement;
            SqlSelectHelper.getSubPlainSelect((Select)plainSelect, plainSelectList);
        } else if (selectStatement instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)selectStatement).getSelects())) {
            setOperationList.getSelects().forEach(subSelectBody -> {
                PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                SqlSelectHelper.getSubPlainSelect((Select)subPlainSelect, plainSelectList);
            });
        }
        return plainSelectList;
    }

    public static List<PlainSelect> getPlainSelect(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        return SqlSelectHelper.getPlainSelect(selectStatement);
    }

    public static Boolean hasSubSelect(String sql) {
        PlainSelect plainSelect;
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return false;
        }
        if (selectStatement instanceof PlainSelect && (plainSelect = (PlainSelect)selectStatement).getFromItem() instanceof ParenthesedSelect) {
            return true;
        }
        return false;
    }

    public static void getSubPlainSelect(Select select, List<PlainSelect> plainSelectList) {
        if (select instanceof PlainSelect) {
            List joinList;
            PlainSelect plainSelect = (PlainSelect)select;
            plainSelectList.add(plainSelect);
            if (plainSelect.getFromItem() instanceof ParenthesedSelect) {
                ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
                Object subSelect = parenthesedSelect.getSelect();
                SqlSelectHelper.getSubPlainSelect((Select)subSelect, plainSelectList);
            }
            if (CollectionUtils.isEmpty((Collection)(joinList = plainSelect.getJoins()))) {
                return;
            }
            for (Join join : joinList) {
                if (!(join.getRightItem() instanceof ParenthesedSelect)) continue;
                ParenthesedSelect parenthesedSelect = (ParenthesedSelect)join.getRightItem();
                plainSelectList.add(parenthesedSelect.getPlainSelect());
            }
        }
        if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            for (Object subSelect : setOperationList.getSelects()) {
                SqlSelectHelper.getSubPlainSelect((Select)subSelect, plainSelectList);
            }
        }
    }

    public static Select getSelect(String sql) {
        Statement statement = null;
        try {
            statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            log.error("parse error, sql:{}", (Object)sql, (Object)e);
            return null;
        }
        if (statement instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)statement;
            return parenthesedSelect.getSelect();
        }
        if (!(statement instanceof Select)) {
            return null;
        }
        return (Select)statement;
    }

    public static List<PlainSelect> getPlainSelects(List<PlainSelect> plainSelectList) {
        final ArrayList<PlainSelect> plainSelects = new ArrayList<PlainSelect>();
        for (PlainSelect plainSelect : plainSelectList) {
            plainSelects.add(plainSelect);
            final ExpressionVisitorAdapter expressionVisitor = new ExpressionVisitorAdapter(){

                public void visit(Select subSelect) {
                    ParenthesedSelect parenthesedSelect;
                    if (subSelect instanceof ParenthesedSelect && (parenthesedSelect = (ParenthesedSelect)subSelect).getSelect() instanceof PlainSelect) {
                        plainSelects.add(parenthesedSelect.getPlainSelect());
                    }
                }
            };
            plainSelect.accept((SelectVisitor)new SelectVisitorAdapter(){

                public void visit(PlainSelect plainSelect) {
                    List selectItems;
                    Expression having;
                    Expression whereExpression = plainSelect.getWhere();
                    if (whereExpression != null) {
                        whereExpression.accept((ExpressionVisitor)expressionVisitor);
                    }
                    if (Objects.nonNull(having = plainSelect.getHaving())) {
                        having.accept((ExpressionVisitor)expressionVisitor);
                    }
                    if (!CollectionUtils.isEmpty((Collection)(selectItems = plainSelect.getSelectItems()))) {
                        for (SelectItem selectItem : selectItems) {
                            selectItem.accept((SelectItemVisitor)expressionVisitor);
                        }
                    }
                }
            });
        }
        return plainSelects;
    }

    public static List<String> getAllFields(String sql) {
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelects(SqlSelectHelper.getPlainSelect(sql));
        HashSet<String> results = new HashSet<String>();
        for (PlainSelect plainSelect : plainSelects) {
            List<String> fields = SqlSelectHelper.getFieldsByPlainSelect(plainSelect);
            results.addAll(fields);
        }
        return new ArrayList<String>(results);
    }

    private static List<String> getFieldsByPlainSelect(PlainSelect plainSelect) {
        if (Objects.isNull(plainSelect)) {
            return new ArrayList<String>();
        }
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        plainSelectList.add(plainSelect);
        Set<String> result = SqlSelectHelper.getSelectFields(plainSelectList);
        SqlSelectHelper.getGroupByFields(plainSelect, result);
        SqlSelectHelper.getOrderByFields(plainSelect, result);
        SqlSelectHelper.getWhereFields(plainSelectList, result);
        SqlSelectHelper.getHavingFields(plainSelect, result);
        SqlSelectHelper.getLateralViewsFields(plainSelect, result);
        return new ArrayList<String>(result);
    }

    private static void getHavingFields(PlainSelect plainSelect, Set<String> result) {
        Expression having = plainSelect.getHaving();
        if (Objects.nonNull(having)) {
            having.accept((ExpressionVisitor)new FieldAcquireVisitor(result));
        }
    }

    private static void getLateralViewsFields(PlainSelect plainSelect, Set<String> result) {
        List lateralViews = plainSelect.getLateralViews();
        if (!CollectionUtils.isEmpty((Collection)lateralViews)) {
            lateralViews.stream().forEach(l -> {
                if (Objects.nonNull(l.getGeneratorFunction())) {
                    l.getGeneratorFunction().accept((ExpressionVisitor)new FieldAcquireVisitor(result));
                }
            });
        }
    }

    public static List<Expression> getHavingExpression(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (PlainSelect plainSelect : plainSelectList) {
            Expression having = plainSelect.getHaving();
            if (!Objects.nonNull(having) || !(having instanceof ComparisonOperator)) continue;
            ComparisonOperator comparisonOperator = (ComparisonOperator)having;
            if (comparisonOperator.getLeftExpression() instanceof Function) {
                expressionList.add(comparisonOperator.getLeftExpression());
                continue;
            }
            if (!(comparisonOperator.getRightExpression() instanceof Function)) continue;
            expressionList.add(comparisonOperator.getRightExpression());
        }
        return expressionList;
    }

    public static List<FieldExpression> getWhereExpressions(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<FieldExpression> result = new HashSet<FieldExpression>();
        for (PlainSelect plainSelect : plainSelectList) {
            Expression subWhere;
            if (Objects.isNull(plainSelect)) continue;
            Expression where = plainSelect.getWhere();
            if (Objects.nonNull(where)) {
                where.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
            }
            if (!(plainSelect.getFromItem() instanceof ParenthesedSelect)) continue;
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
            Select subSelect = parenthesedSelect.getSelect();
            if (subSelect instanceof PlainSelect) {
                PlainSelect subPlainSelect = parenthesedSelect.getPlainSelect();
                subWhere = subPlainSelect.getWhere();
                if (!Objects.nonNull(subWhere)) continue;
                subWhere.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
                continue;
            }
            if (subSelect instanceof ParenthesedSelect) {
                ParenthesedSelect subParenthesedSelect = (ParenthesedSelect)subSelect;
                subWhere = subParenthesedSelect.getPlainSelect().getWhere();
                if (!Objects.nonNull(subWhere)) continue;
                subWhere.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
                continue;
            }
            if (!(subSelect instanceof SetOperationList)) continue;
            SetOperationList setOperationList = (SetOperationList)subSelect;
            List selectList = setOperationList.getSelects();
            for (Select select : selectList) {
                Expression subWhere2 = select.getPlainSelect().getWhere();
                if (!Objects.nonNull(subWhere2)) continue;
                subWhere2.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
            }
        }
        return new ArrayList<FieldExpression>(result);
    }

    public static List<FieldExpression> getHavingExpressions(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<FieldExpression> result = new HashSet<FieldExpression>();
        for (PlainSelect plainSelect : plainSelectList) {
            Expression having;
            if (Objects.isNull(plainSelect) || !Objects.nonNull(having = plainSelect.getHaving())) continue;
            having.accept((ExpressionVisitor)new FieldAndValueAcquireVisitor(result));
        }
        return new ArrayList<FieldExpression>(result);
    }

    public static List<String> getOrderByFields(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<String> result = new HashSet<String>();
        for (PlainSelect plainSelect : plainSelectList) {
            if (Objects.isNull(plainSelect)) continue;
            SqlSelectHelper.getOrderByFields(plainSelect, result);
        }
        return new ArrayList<String>(result);
    }

    private static Set<FieldExpression> getOrderByFields(PlainSelect plainSelect) {
        HashSet<FieldExpression> result = new HashSet<FieldExpression>();
        List orderByElements = plainSelect.getOrderByElements();
        if (!CollectionUtils.isEmpty((Collection)orderByElements)) {
            for (OrderByElement orderByElement : orderByElements) {
                orderByElement.accept((OrderByVisitor)new OrderByAcquireVisitor(result));
            }
        }
        return result;
    }

    private static void getOrderByFields(PlainSelect plainSelect, Set<String> result) {
        Set<FieldExpression> orderByFieldExpressions = SqlSelectHelper.getOrderByFields(plainSelect);
        Set collect = orderByFieldExpressions.stream().map(fieldExpression -> fieldExpression.getFieldName()).filter(Objects::nonNull).collect(Collectors.toSet());
        result.addAll(collect);
    }

    public static List<FieldExpression> getOrderByExpressions(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<FieldExpression> result = new HashSet<FieldExpression>();
        for (PlainSelect plainSelect : plainSelectList) {
            if (Objects.isNull(plainSelect)) {
                return new ArrayList<FieldExpression>();
            }
            result.addAll(SqlSelectHelper.getOrderByFields(plainSelect));
        }
        return new ArrayList<FieldExpression>(result);
    }

    public static List<String> getGroupByFields(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<String> result = new HashSet<String>();
        for (PlainSelect plainSelect : plainSelectList) {
            if (Objects.isNull(plainSelect)) continue;
            SqlSelectHelper.getGroupByFields(plainSelect, result);
        }
        return new ArrayList<String>(result);
    }

    private static void getGroupByFields(PlainSelect plainSelect, Set<String> result) {
        GroupByElement groupBy = plainSelect.getGroupBy();
        if (groupBy != null) {
            ExpressionList groupByExpressions = groupBy.getGroupByExpressions();
            for (Expression expression : groupByExpressions) {
                if (!(expression instanceof Column)) continue;
                Column column = (Column)expression;
                result.add(column.getColumnName());
            }
        }
    }

    public static String getTableName(String sql) {
        Table table = SqlSelectHelper.getTable(sql);
        return StringUtil.replaceBackticks(table.getName());
    }

    public static List<String> getAggregateFields(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<String> result = new HashSet<String>();
        for (PlainSelect plainSelect : plainSelectList) {
            if (Objects.isNull(plainSelect)) continue;
            List selectItems = plainSelect.getSelectItems();
            for (SelectItem selectItem : selectItems) {
                Function function;
                if (!(selectItem.getExpression() instanceof Function) || !Objects.nonNull((function = (Function)selectItem.getExpression()).getParameters()) || CollectionUtils.isEmpty((Collection)function.getParameters().getExpressions())) continue;
                String columnName = function.getParameters().getExpressions().get(0).toString();
                result.add(columnName);
            }
        }
        return new ArrayList<String>(result);
    }

    public static List<String> getAggregateAsFields(String sql) {
        List<PlainSelect> plainSelectList = SqlSelectHelper.getPlainSelect(sql);
        HashSet<String> result = new HashSet<String>();
        for (PlainSelect plainSelect : plainSelectList) {
            if (Objects.isNull(plainSelect)) continue;
            List selectItems = plainSelect.getSelectItems();
            for (SelectItem selectItem : selectItems) {
                if (!(selectItem.getExpression() instanceof Function)) continue;
                Function function = (Function)selectItem.getExpression();
                Alias alias = selectItem.getAlias();
                if (alias != null && StringUtils.isNotBlank((CharSequence)alias.getName())) {
                    result.add(alias.getName());
                    continue;
                }
                if (!Objects.nonNull(function.getParameters()) || CollectionUtils.isEmpty((Collection)function.getParameters().getExpressions())) continue;
                String columnName = function.getParameters().getExpressions().get(0).toString();
                result.add(columnName);
            }
        }
        return new ArrayList<String>(result);
    }

    public static boolean hasGroupBy(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return false;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        GroupByElement groupBy = plainSelect.getGroupBy();
        if (Objects.nonNull(groupBy)) {
            GroupByVisitor replaceVisitor = new GroupByVisitor();
            groupBy.accept((net.sf.jsqlparser.statement.select.GroupByVisitor)replaceVisitor);
            return replaceVisitor.isHasAggregateFunction();
        }
        return false;
    }

    public static boolean hasDistinct(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return false;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Distinct distinct = plainSelect.getDistinct();
        return Objects.nonNull(distinct);
    }

    public static boolean isLogicExpression(Expression whereExpression) {
        return whereExpression instanceof AndExpression || whereExpression instanceof OrExpression || whereExpression instanceof XorExpression;
    }

    public static String getColumnName(Expression leftExpression, Expression rightExpression) {
        ExpressionList expressionList;
        if (leftExpression instanceof Column) {
            return ((Column)leftExpression).getColumnName();
        }
        if (leftExpression instanceof Function && !CollectionUtils.isEmpty((Collection)(expressionList = ((Function)leftExpression).getParameters())) && expressionList.get(0) instanceof Column) {
            return ((Column)expressionList.get(0)).getColumnName();
        }
        if (rightExpression instanceof Column) {
            return ((Column)rightExpression).getColumnName();
        }
        return "";
    }

    public static String getColumnName(Expression leftExpression) {
        Expression expression;
        Function function;
        if (leftExpression instanceof Column) {
            Column leftColumnName = (Column)leftExpression;
            return leftColumnName.getColumnName();
        }
        if (leftExpression instanceof Function && !CollectionUtils.isEmpty((Collection)(function = (Function)leftExpression).getParameters()) && (expression = (Expression)function.getParameters().get(0)) instanceof Column) {
            return ((Column)expression).getColumnName();
        }
        return "";
    }

    public static String getColumValue(Expression expression) {
        if (expression instanceof StringValue) {
            StringValue value = (StringValue)expression;
            return value.getValue();
        }
        if (expression instanceof LongValue) {
            LongValue value = (LongValue)expression;
            return String.valueOf(value.getValue());
        }
        return "";
    }

    public static Boolean hasWith(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return false;
        }
        List withItemList = selectStatement.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemList)) {
            return true;
        }
        return false;
    }

    public static List<PlainSelect> getWithItem(Select selectStatement) {
        if (selectStatement == null) {
            return new ArrayList<PlainSelect>();
        }
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        List withItemList = selectStatement.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemList)) {
            for (int i = 0; i < withItemList.size(); ++i) {
                WithItem withItem = (WithItem)withItemList.get(i);
                Select withSelect = withItem.getSelect();
                if (withSelect instanceof PlainSelect) {
                    PlainSelect withPlainSelect = (PlainSelect)withSelect;
                    plainSelectList.add(withPlainSelect);
                    if (withPlainSelect.getFromItem() instanceof ParenthesedSelect) {
                        ParenthesedSelect parenthesedSelect = (ParenthesedSelect)withPlainSelect.getFromItem();
                        plainSelectList.add(parenthesedSelect.getPlainSelect());
                    }
                }
                if (!(withSelect instanceof ParenthesedSelect)) continue;
                ParenthesedSelect parenthesedSelect = (ParenthesedSelect)withSelect;
                PlainSelect withPlainSelect = parenthesedSelect.getPlainSelect();
                plainSelectList.add(withPlainSelect);
            }
        }
        return plainSelectList;
    }

    public static List<String> getWithName(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> withNameList = new ArrayList<String>();
        List withItemList = selectStatement.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemList)) {
            for (int i = 0; i < withItemList.size(); ++i) {
                WithItem withItem = (WithItem)withItemList.get(i);
                withNameList.add(withItem.getAlias().getName());
            }
        }
        return withNameList;
    }

    public static Map<String, WithItem> getWith(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return new HashMap<String, WithItem>();
        }
        HashMap<String, WithItem> withMap = new HashMap<String, WithItem>();
        List withItemList = selectStatement.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemList)) {
            for (int i = 0; i < withItemList.size(); ++i) {
                WithItem withItem = (WithItem)withItemList.get(i);
                withMap.put(withItem.getAlias().getName(), withItem);
            }
        }
        return withMap;
    }

    public static Table getTable(String sql) {
        SetOperationList setOperationList;
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return null;
        }
        List<PlainSelect> plainSelectList = SqlSelectHelper.getWithItem(selectStatement);
        if (!CollectionUtils.isEmpty(plainSelectList)) {
            Table table = SqlSelectHelper.getTable(plainSelectList.get(0).toString());
            return table;
        }
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectStatement;
            if (plainSelect.getFromItem() instanceof Table) {
                return (Table)plainSelect.getFromItem();
            }
            if (plainSelect.getFromItem() instanceof ParenthesedSelect) {
                PlainSelect subSelect = ((ParenthesedSelect)plainSelect.getFromItem()).getPlainSelect();
                return SqlSelectHelper.getTable(subSelect.getSelectBody().toString());
            }
        } else if (selectStatement instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)selectStatement).getSelects())) {
            return (Table)((PlainSelect)setOperationList.getSelects().get(0)).getFromItem();
        }
        return null;
    }

    public static String getDbTableName(String sql) {
        Table table = SqlSelectHelper.getTable(sql);
        return table.getFullyQualifiedName();
    }

    public static Set<String> getColumnFromExpr(String expr) {
        Expression expression = QueryExpressionReplaceVisitor.getExpression(expr);
        HashSet<String> columns = new HashSet<String>();
        if (Objects.nonNull(expression)) {
            SqlSelectHelper.getColumnFromExpr(expression, columns);
        }
        return columns;
    }

    public static void getColumnFromExpr(Expression expression, Set<String> columns) {
        CaseExpression expr;
        if (expression instanceof Column) {
            columns.add(((Column)expression).getColumnName());
        }
        if (expression instanceof Function) {
            ExpressionList expressionList = ((Function)expression).getParameters();
            for (Expression expr2 : expressionList) {
                SqlSelectHelper.getColumnFromExpr(expr2, columns);
            }
        }
        if (expression instanceof CaseExpression) {
            expr = (CaseExpression)expression;
            if (Objects.nonNull(expr.getWhenClauses())) {
                for (WhenClause whenClause : expr.getWhenClauses()) {
                    SqlSelectHelper.getColumnFromExpr(whenClause.getWhenExpression(), columns);
                    SqlSelectHelper.getColumnFromExpr(whenClause.getThenExpression(), columns);
                }
            }
            if (Objects.nonNull(expr.getElseExpression())) {
                SqlSelectHelper.getColumnFromExpr(expr.getElseExpression(), columns);
            }
        }
        if (expression instanceof BinaryExpression) {
            expr = (BinaryExpression)expression;
            SqlSelectHelper.getColumnFromExpr(expr.getLeftExpression(), columns);
            SqlSelectHelper.getColumnFromExpr(expr.getRightExpression(), columns);
        }
        if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            SqlSelectHelper.getColumnFromExpr(inExpression.getLeftExpression(), columns);
        }
        if (expression instanceof Between) {
            Between between = (Between)expression;
            SqlSelectHelper.getColumnFromExpr(between.getLeftExpression(), columns);
        }
        if (expression instanceof IsBooleanExpression) {
            IsBooleanExpression isBooleanExpression = (IsBooleanExpression)expression;
            SqlSelectHelper.getColumnFromExpr(isBooleanExpression.getLeftExpression(), columns);
        }
        if (expression instanceof IsNullExpression) {
            IsNullExpression isNullExpression = (IsNullExpression)expression;
            SqlSelectHelper.getColumnFromExpr(isNullExpression.getLeftExpression(), columns);
        }
        if (expression instanceof Parenthesis) {
            expr = (Parenthesis)expression;
            SqlSelectHelper.getColumnFromExpr(expr.getExpression(), columns);
        }
    }

    public static Boolean hasLimit(String querySql) {
        Select selectStatement = SqlSelectHelper.getSelect(querySql);
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = selectStatement.getPlainSelect();
            Limit limit = plainSelect.getLimit();
            return Objects.nonNull(limit);
        }
        if (selectStatement instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectStatement;
            Boolean result = true;
            if (!CollectionUtils.isEmpty((Collection)setOperationList.getSelects())) {
                for (Select select : setOperationList.getSelects()) {
                    PlainSelect subPlainSelect = select.getPlainSelect();
                    Limit limit = subPlainSelect.getLimit();
                    if (!Objects.isNull(limit)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        return false;
    }

    public static Map<String, Set<String>> getFieldsWithSubQuery(String sql) {
        List<PlainSelect> plainSelects = SqlSelectHelper.getPlainSelects(SqlSelectHelper.getPlainSelect(sql));
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        for (PlainSelect plainSelect : plainSelects) {
            SqlSelectHelper.getFieldsWithSubQuery(plainSelect, results);
        }
        return results;
    }

    private static void getFieldsWithSubQuery(PlainSelect plainSelect, Map<String, Set<String>> fields) {
        if (plainSelect.getFromItem() instanceof Table) {
            boolean isWith = false;
            if (!CollectionUtils.isEmpty((Collection)plainSelect.getWithItemsList())) {
                for (WithItem withItem : plainSelect.getWithItemsList()) {
                    if (!Objects.nonNull(withItem.getSelect())) continue;
                    SqlSelectHelper.getFieldsWithSubQuery(withItem.getSelect().getPlainSelect(), fields);
                    isWith = true;
                }
            }
            if (!isWith) {
                Table table = (Table)plainSelect.getFromItem();
                if (!fields.containsKey(table.getFullyQualifiedName())) {
                    fields.put(table.getFullyQualifiedName(), new HashSet());
                }
                List sqlFields = SqlSelectHelper.getFieldsByPlainSelect(plainSelect).stream().map(f -> f.replaceAll("`", "")).collect(Collectors.toList());
                fields.get(table.getFullyQualifiedName()).addAll(sqlFields);
            }
        }
        if (plainSelect.getFromItem() instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
            SqlSelectHelper.getFieldsWithSubQuery(parenthesedSelect.getPlainSelect(), fields);
            if (CollectionUtils.isEmpty((Collection)plainSelect.getJoins())) {
                return;
            }
            for (Join join : plainSelect.getJoins()) {
                if (join.getRightItem() instanceof ParenthesedSelect) {
                    SqlSelectHelper.getFieldsWithSubQuery(((ParenthesedSelect)join.getRightItem()).getPlainSelect(), fields);
                }
                if (!(join.getFromItem() instanceof ParenthesedSelect)) continue;
                SqlSelectHelper.getFieldsWithSubQuery(((ParenthesedSelect)join.getFromItem()).getPlainSelect(), fields);
            }
        }
    }
}

