/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlValidHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlValidHelper.class);

    public static boolean equals(String thisSql, String otherSql) {
        List<FieldExpression> otherOrderByExpressions;
        List<FieldExpression> otherHavingExpressions;
        List<FieldExpression> otherFieldExpressions;
        List<String> otherAllFields;
        List<String> otherSelectFields;
        List<String> thisSelectFields = SqlSelectHelper.getSelectFields(thisSql);
        if (!CollectionUtils.isEqualCollection(thisSelectFields, otherSelectFields = SqlSelectHelper.getSelectFields(otherSql))) {
            return false;
        }
        List<String> thisAllFields = SqlSelectHelper.getAllFields(thisSql);
        if (!CollectionUtils.isEqualCollection(thisAllFields, otherAllFields = SqlSelectHelper.getAllFields(otherSql))) {
            return false;
        }
        List<FieldExpression> thisFieldExpressions = SqlSelectHelper.getFilterExpression(thisSql);
        if (!CollectionUtils.isEqualCollection(thisFieldExpressions, otherFieldExpressions = SqlSelectHelper.getFilterExpression(otherSql))) {
            return false;
        }
        if (!SqlSelectHelper.getDbTableName(thisSql).equalsIgnoreCase(SqlSelectHelper.getDbTableName(otherSql))) {
            return false;
        }
        List<FieldExpression> thisHavingExpressions = SqlSelectHelper.getHavingExpressions(thisSql);
        if (!CollectionUtils.isEqualCollection(thisHavingExpressions, otherHavingExpressions = SqlSelectHelper.getHavingExpressions(otherSql))) {
            return false;
        }
        List<FieldExpression> thisOrderByExpressions = SqlSelectHelper.getOrderByExpressions(thisSql);
        return CollectionUtils.isEqualCollection(thisOrderByExpressions, otherOrderByExpressions = SqlSelectHelper.getOrderByExpressions(otherSql));
    }

    public static boolean isValidSQL(String sql) {
        try {
            CCJSqlParserUtil.parse((String)sql);
            return true;
        }
        catch (JSQLParserException e) {
            log.error("isValidSQL parse:{}", (Throwable)e);
            return false;
        }
    }
}

