/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.pojo;

import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.DateUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class DateConf {
    private static final long serialVersionUID = 3074129990945004340L;
    private DateMode dateMode = DateMode.RECENT;
    private String startDate = LocalDate.now().plusDays(-1L).toString();
    private String endDate = LocalDate.now().toString();
    private List<String> dateList = new ArrayList<String>();
    private Integer unit = 1;
    private String period = "DAY";
    private String detectWord;
    private boolean isInherited;
    private boolean groupByDate;

    public List<String> getDateList() {
        if (!CollectionUtils.isEmpty(this.dateList)) {
            return this.dateList;
        }
        String startDateStr = this.getStartDate();
        String endDateStr = this.getEndDate();
        return DateUtils.getDateList(startDateStr, endDateStr, this.getPeriod());
    }

    public String getGroupByTimeDimension() {
        if ("DAY".equals(this.period)) {
            return TimeDimensionEnum.DAY.getName();
        }
        if ("WEEK".equals(this.period)) {
            return TimeDimensionEnum.WEEK.getName();
        }
        if ("MONTH".equals(this.period)) {
            return TimeDimensionEnum.MONTH.getName();
        }
        return TimeDimensionEnum.DAY.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateConf dateConf = (DateConf)o;
        return this.dateMode == dateConf.dateMode && Objects.equals(this.startDate, dateConf.startDate) && Objects.equals(this.endDate, dateConf.endDate) && Objects.equals(this.unit, dateConf.unit) && Objects.equals(this.period, dateConf.period);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateMode, this.startDate, this.endDate, this.unit, this.period});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"dateMode\":").append((Object)this.dateMode);
        sb.append(",\"startDate\":\"").append(this.startDate).append('\"');
        sb.append(",\"endDate\":\"").append(this.endDate).append('\"');
        sb.append(",\"dateList\":").append(this.dateList);
        sb.append(",\"unit\":").append(this.unit);
        sb.append(",\"period\":\"").append(this.period).append('\"');
        sb.append(",\"text\":\"").append(this.detectWord).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public DateMode getDateMode() {
        return this.dateMode;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public Integer getUnit() {
        return this.unit;
    }

    public String getPeriod() {
        return this.period;
    }

    public String getDetectWord() {
        return this.detectWord;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public boolean isGroupByDate() {
        return this.groupByDate;
    }

    public void setDateMode(DateMode dateMode) {
        this.dateMode = dateMode;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setDateList(List<String> dateList) {
        this.dateList = dateList;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setDetectWord(String detectWord) {
        this.detectWord = detectWord;
    }

    public void setInherited(boolean isInherited) {
        this.isInherited = isInherited;
    }

    public void setGroupByDate(boolean groupByDate) {
        this.groupByDate = groupByDate;
    }

    public static enum DateMode {
        BETWEEN,
        LIST,
        RECENT,
        AVAILABLE;

    }
}

