/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.pojo.enums;

import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum DictWordType {
    METRIC("metric"),
    DIMENSION("dimension"),
    VALUE("value"),
    DATASET("dataSet"),
    ENTITY("entity"),
    NUMBER("m"),
    TAG("tag"),
    TERM("term"),
    SUFFIX("suffix");

    public static final String NATURE_SPILT = "_";
    public static final String SPACE = " ";
    private String type;

    private DictWordType(String type) {
        this.type = type;
    }

    public String getType() {
        return NATURE_SPILT + this.type;
    }

    public static DictWordType getNatureType(String nature) {
        if (StringUtils.isEmpty((CharSequence)nature) || !nature.startsWith(NATURE_SPILT)) {
            return null;
        }
        for (DictWordType dictWordType : DictWordType.values()) {
            if (!nature.endsWith(dictWordType.getType())) continue;
            return dictWordType;
        }
        String[] natures = nature.split(NATURE_SPILT);
        if (natures.length == 2 && StringUtils.isNumeric((CharSequence)natures[1])) {
            return DATASET;
        }
        if (natures.length == 3 && StringUtils.isNumeric((CharSequence)natures[1]) && StringUtils.isNumeric((CharSequence)natures[2])) {
            return VALUE;
        }
        return null;
    }

    public static DictWordType of(TypeEnums type) {
        for (DictWordType wordType : DictWordType.values()) {
            if (!wordType.name().equalsIgnoreCase(type.name())) continue;
            return wordType;
        }
        return null;
    }

    public static String getSuffixNature(TypeEnums type) {
        DictWordType wordType = DictWordType.of(type);
        if (Objects.nonNull((Object)wordType)) {
            return wordType.type;
        }
        return "";
    }
}

