/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.pojo.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public enum TimeDimensionEnum {
    DAY("sys_imp_date", "\u6570\u636e\u65e5\u671f"),
    WEEK("sys_imp_week", "\u6570\u636e\u65e5\u671f_\u5468"),
    MONTH("sys_imp_month", "\u6570\u636e\u65e5\u671f_\u6708");

    private String name;
    private String chName;

    private TimeDimensionEnum(String name, String chName) {
        this.name = name;
        this.chName = chName;
    }

    public static boolean containsTimeDimension(String fieldName) {
        return TimeDimensionEnum.getNameList().contains(fieldName) || TimeDimensionEnum.getChNameList().contains(fieldName);
    }

    public static List<String> getNameList() {
        return Arrays.stream(TimeDimensionEnum.values()).map(TimeDimensionEnum::getName).collect(Collectors.toList());
    }

    public static List<String> getChNameList() {
        return Arrays.stream(TimeDimensionEnum.values()).map(TimeDimensionEnum::getChName).collect(Collectors.toList());
    }

    public static Map<String, String> getChNameToNameMap() {
        return Arrays.stream(TimeDimensionEnum.values()).collect(Collectors.toMap(TimeDimensionEnum::getChName, TimeDimensionEnum::getName, (k1, k2) -> k1));
    }

    public static Map<String, String> getNameToNameMap() {
        return Arrays.stream(TimeDimensionEnum.values()).collect(Collectors.toMap(TimeDimensionEnum::getName, TimeDimensionEnum::getName, (k1, k2) -> k1));
    }

    public String getName() {
        return this.name;
    }

    public String getChName() {
        return this.chName;
    }

    public static boolean containsZhTimeDimension(List<String> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return false;
        }
        return fields.stream().anyMatch(field -> TimeDimensionEnum.containsTimeDimension(field));
    }
}

