/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.pojo.SqlExemplar;
import com.tencent.supersonic.common.service.EmbeddingService;
import com.tencent.supersonic.common.service.ExemplarService;
import com.tencent.supersonic.common.util.JsonUtil;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.RetrieveQuery;
import dev.langchain4j.store.embedding.RetrieveQueryResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class ExemplarServiceImpl
implements ExemplarService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ExemplarServiceImpl.class);
    private static final String SYS_EXEMPLAR_FILE = "s2-exemplar.json";
    private TypeReference<List<SqlExemplar>> valueTypeRef = new TypeReference<List<SqlExemplar>>(){};
    private final ObjectMapper objectMapper = JsonUtil.INSTANCE.getObjectMapper();
    @Autowired
    private EmbeddingConfig embeddingConfig;
    @Autowired
    private EmbeddingService embeddingService;

    @Override
    public void storeExemplar(String collection, SqlExemplar exemplar) {
        Metadata metadata = Metadata.from(JsonUtil.toMap(JsonUtil.toString(exemplar), String.class, Object.class));
        TextSegment segment = TextSegment.from((String)exemplar.getQuestion(), (Metadata)metadata);
        this.embeddingService.addQuery(collection, Lists.newArrayList((Object[])new TextSegment[]{segment}));
    }

    @Override
    public void removeExemplar(String collection, SqlExemplar exemplar) {
        Metadata metadata = Metadata.from(JsonUtil.toMap(JsonUtil.toString(exemplar), String.class, Object.class));
        TextSegment segment = TextSegment.from((String)exemplar.getQuestion(), (Metadata)metadata);
        this.embeddingService.deleteQuery(collection, Lists.newArrayList((Object[])new TextSegment[]{segment}));
    }

    @Override
    public List<SqlExemplar> recallExemplars(String query, int num) {
        String collection = this.embeddingConfig.getText2sqlCollectionName();
        return this.recallExemplars(collection, query, num);
    }

    @Override
    public List<SqlExemplar> recallExemplars(String collection, String query, int num) {
        ArrayList exemplars = Lists.newArrayList();
        RetrieveQuery retrieveQuery = RetrieveQuery.builder().queryTextsList(Lists.newArrayList((Object[])new String[]{query})).build();
        List<RetrieveQueryResult> results = this.embeddingService.retrieveQuery(collection, retrieveQuery, num);
        results.stream().forEach(ret -> ret.getRetrieval().stream().forEach(r -> exemplars.add(JsonUtil.mapToObject(r.getMetadata(), SqlExemplar.class))));
        return exemplars;
    }

    public void run(String ... args) {
        try {
            this.loadSysExemplars();
        }
        catch (IOException e) {
            log.error("Failed to load system exemplars", (Throwable)e);
        }
    }

    private void loadSysExemplars() throws IOException {
        ClassPathResource resource = new ClassPathResource(SYS_EXEMPLAR_FILE);
        InputStream inputStream = resource.getInputStream();
        List exemplars = (List)this.objectMapper.readValue(inputStream, this.valueTypeRef);
        String collection = this.embeddingConfig.getText2sqlCollectionName();
        exemplars.stream().forEach(e -> this.storeExemplar(collection, (SqlExemplar)e));
    }
}

