/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.tencent.supersonic.common.util.HttpClientResult;
import com.tencent.supersonic.common.util.RetryUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String ENCODING = "UTF-8";
    private static final int DEFAULT_MAX_CONN_PERHOST = 100;
    private static final int DEFAULT_MAX_TOTAL_CONN = 200;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 150000;
    private static final int DEFAULT_READ_TIMEOUT = 150000;
    private static final int DEFAULT_CONN_REQUEST_TIMEOUT = 100000;
    private static CloseableHttpClient httpClient = null;

    private static void init() {
        try {
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial((chain, authType) -> true).build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build());
            connManager.setMaxTotal(200);
            connManager.setDefaultMaxPerRoute(100);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(150000).setSocketTimeout(150000).setConnectionRequestTimeout(100000).build();
            HttpRequestRetryHandler httpRequestRetryHandler = (exception, executionCount, context) -> {
                if (executionCount > 3) {
                    log.warn("Maximum tries reached, exception would be thrown to outer block");
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    log.warn("Retry, No response from server on  {}  error: {}", (Object)executionCount, (Object)exception.getMessage());
                    return true;
                }
                if (exception instanceof SocketException) {
                    log.warn("Retry, No connection from server on {} error: {}", (Object)executionCount, (Object)exception.getMessage());
                    return true;
                }
                return false;
            };
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long keepAlive = super.getKeepAliveDuration(response, context);
                    if (keepAlive == -1L) {
                        keepAlive = 5000L;
                    }
                    return keepAlive;
                }
            }).setRetryHandler(httpRequestRetryHandler).setConnectionTimeToLive(5000L, TimeUnit.MILLISECONDS).evictIdleConnections(5L, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static HttpClientResult doPost(String url) {
        return HttpClientUtils.doPost(url, null, null, null, null);
    }

    public static HttpClientResult doPost(String url, Map<String, String> params) {
        return HttpClientUtils.doPost(url, null, null, null, params);
    }

    public static HttpClientResult doPost(String url, String proxyHost, Integer proxyPort, Map<String, String> headers, Map<String, String> params) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            HttpPost httpPost = null;
            CloseableHttpResponse response = null;
            try {
                httpPost = new HttpPost(url);
                HttpClientUtils.setProxy((HttpRequestBase)httpPost, proxyHost, proxyPort);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPost);
                HttpClientUtils.packageParam(params, (HttpEntityEnclosingRequestBase)httpPost);
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpClientResult result = HttpClientUtils.getHttpClientResult(response);
                log.info("uri:{}, req:{}, resp:{}", new Object[]{url, "headers:" + HttpClientUtils.getHeaders((HttpRequestBase)httpPost) + "------params:" + params, result});
                httpClientResult = result;
            }
            catch (Exception e) {
                try {
                    log.error("uri:{}, req:{}", new Object[]{url, "headers:" + headers + "------params:" + params, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    HttpClientUtils.close((HttpRequestBase)httpPost, response);
                    throw throwable;
                }
            }
            HttpClientUtils.close((HttpRequestBase)httpPost, response);
            return httpClientResult;
        });
    }

    public static HttpClientResult doPost(String url, Map<String, String> header, Map<String, String> params) {
        return HttpClientUtils.doPost(url, null, null, header, params);
    }

    public static HttpClientResult doGet(String url) {
        return HttpClientUtils.doGet(url, null, null, null, null);
    }

    public static HttpClientResult doGet(String url, Map<String, String> params) {
        return HttpClientUtils.doGet(url, null, null, null, params);
    }

    public static HttpClientResult doGet(String url, String proxyHost, Integer proxyPort, Map<String, String> headers, Map<String, String> params) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            HttpGet httpGet = null;
            CloseableHttpResponse response = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                if (params != null) {
                    Set entrySet = params.entrySet();
                    for (Map.Entry entry : entrySet) {
                        uriBuilder.setParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                httpGet = new HttpGet(uriBuilder.build());
                HttpClientUtils.setProxy((HttpRequestBase)httpGet, proxyHost, proxyPort);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpGet);
                response = httpClient.execute((HttpUriRequest)httpGet);
                HttpClientResult res = HttpClientUtils.getHttpClientResult(response);
                log.debug("GET uri:{}, req:{}, resp:{}", new Object[]{url, "headers:" + HttpClientUtils.getHeaders((HttpRequestBase)httpGet) + "------params:" + params, res});
                httpClientResult = res;
            }
            catch (Exception e) {
                try {
                    log.error("GET error! uri:{}, req:{}", new Object[]{url, "headers:" + headers + "------params:" + params, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    HttpClientUtils.close(httpGet, response);
                    throw throwable;
                }
            }
            HttpClientUtils.close((HttpRequestBase)httpGet, response);
            return httpClientResult;
        });
    }

    public static HttpClientResult doGet(String url, Map<String, String> header, Map<String, String> params) {
        return HttpClientUtils.doGet(url, null, null, header, params);
    }

    public static void close(HttpRequestBase httpRequest, CloseableHttpResponse response) {
        if (response != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (Throwable ex) {
                log.error("entity close error : ", ex);
            }
            try {
                response.close();
            }
            catch (Throwable ex) {
                log.error("response close error : ", ex);
            }
        }
        if (httpRequest != null) {
            try {
                httpRequest.abort();
            }
            catch (Throwable ex) {
                log.error("httpPost abort error : ", ex);
            }
        }
    }

    public static void packageHeader(Map<String, String> headers, HttpRequestBase httpMethod) {
        if (headers != null) {
            Set<Map.Entry<String, String>> entrySet = headers.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static String getHeaders(HttpRequestBase request) {
        if (request == null) {
            return "";
        }
        StringBuilder headsString = new StringBuilder("");
        Header[] heads = request.getAllHeaders();
        if (heads != null) {
            for (int i = 0; i < heads.length; ++i) {
                headsString.append(heads[i]).append(" , ");
            }
        }
        return headsString.toString();
    }

    public static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, ENCODING));
        }
    }

    public static void setProxy(HttpRequestBase httpMethod, String proxyHost, Integer proxyPort) {
        if (!StringUtils.isEmpty((CharSequence)proxyHost) && proxyPort != null) {
            RequestConfig config = RequestConfig.custom().setProxy(new HttpHost(proxyHost, proxyPort.intValue())).setConnectTimeout(10000).setSocketTimeout(10000).setConnectionRequestTimeout(3000).build();
            httpMethod.setConfig(config);
        }
    }

    public static boolean isOK(HttpClientResult res) {
        return res != null && res.getCode() == 200;
    }

    public static HttpClientResult doPostJSON(String url, String proxyHost, Integer proxyPort, Map<String, String> headers, String req) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            HttpPost httpPost = null;
            CloseableHttpResponse response = null;
            try {
                httpPost = new HttpPost(url);
                HttpClientUtils.setProxy((HttpRequestBase)httpPost, proxyHost, proxyPort);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPost);
                httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                StringEntity stringEntity = new StringEntity(req, ENCODING);
                stringEntity.setContentEncoding(ENCODING);
                httpPost.setEntity((HttpEntity)stringEntity);
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpClientResult res = HttpClientUtils.getHttpClientResult(response);
                log.info("doPostJSON uri:{}, req:{}, resp:{}", new Object[]{url, "headers:" + HttpClientUtils.getHeaders((HttpRequestBase)httpPost) + "------req:" + req, res});
                httpClientResult = res;
            }
            catch (Exception e) {
                try {
                    log.error("doPostJSON error! uri:{}, req:{}", new Object[]{url, "headers:" + headers + "------req:" + req, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    HttpClientUtils.close((HttpRequestBase)httpPost, response);
                    throw throwable;
                }
            }
            HttpClientUtils.close((HttpRequestBase)httpPost, response);
            return httpClientResult;
        });
    }

    public static HttpClientResult doPostJSON(String url, String req) {
        return HttpClientUtils.doPostJSON(url, null, null, null, req);
    }

    public static HttpClientResult doGetJSON(String url, String proxyHost, Integer proxyPort, Map<String, String> headers, Map<String, String> params) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            HttpGet httpGet = null;
            CloseableHttpResponse response = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                if (params != null) {
                    Set entrySet = params.entrySet();
                    for (Map.Entry entry : entrySet) {
                        uriBuilder.setParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                httpGet = new HttpGet(uriBuilder.build());
                HttpClientUtils.setProxy((HttpRequestBase)httpGet, proxyHost, proxyPort);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpGet);
                httpGet.setHeader("Content-Type", "application/json;charset=UTF-8");
                response = httpClient.execute((HttpUriRequest)httpGet);
                HttpClientResult res = HttpClientUtils.getHttpClientResult(response);
                log.info("doGetJSON uri:{}, req:{}, resp:{}", new Object[]{url, "headers:" + HttpClientUtils.getHeaders((HttpRequestBase)httpGet) + "------params:" + params, res});
                httpClientResult = res;
            }
            catch (Exception e) {
                try {
                    log.warn("doGetJSON error! uri:{}, req:{}", new Object[]{url, "headers:" + headers + "------params:" + params, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    HttpClientUtils.close(httpGet, response);
                    throw throwable;
                }
            }
            HttpClientUtils.close((HttpRequestBase)httpGet, response);
            return httpClientResult;
        });
    }

    private static HttpClientResult getHttpClientResult(CloseableHttpResponse response) throws IOException {
        HttpClientResult res = new HttpClientResult(500);
        if (response != null && response.getStatusLine() != null) {
            String content = "";
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                content = EntityUtils.toString((HttpEntity)entity, (String)ENCODING);
            }
            res = new HttpClientResult(response.getStatusLine().getStatusCode(), content);
        }
        return res;
    }

    public static HttpClientResult doFileUploadBodyParams(String url, Map<String, String> headers, Map<String, String> bodyParams, String fullFilePath) {
        return HttpClientUtils.doFileUpload(url, null, null, headers, null, bodyParams, fullFilePath);
    }

    public static HttpClientResult doFileUpload(String url, String proxyHost, Integer proxyPort, Map<String, String> headers, Map<String, String> params, Map<String, String> bodyParams, String fullFilePath) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            InputStream inputStream = null;
            CloseableHttpResponse response = null;
            HttpPost httpPost = null;
            try {
                File uploadFile = new File(fullFilePath);
                inputStream = new FileInputStream(uploadFile);
                httpPost = new HttpPost(url);
                HttpClientUtils.setProxy((HttpRequestBase)httpPost, proxyHost, proxyPort);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPost);
                HttpEntity entity = HttpClientUtils.getFileUploadHttpEntity(params, bodyParams, inputStream, uploadFile.getName());
                httpPost.setEntity(entity);
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpClientResult res = HttpClientUtils.getHttpClientResult(response);
                log.info("doFileUpload uri:{}, req:{}, resp:{}", new Object[]{url, "params:" + params + ", fullFilePath:" + fullFilePath, res});
                httpClientResult = res;
            }
            catch (Exception e) {
                try {
                    log.error("doFileUpload error! uri:{}, req:{}", new Object[]{url, "params:" + params + ", fullFilePath:" + fullFilePath, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != inputStream) {
                            inputStream.close();
                        }
                        HttpClientUtils.close(httpPost, response);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        log.error("HttpClientUtils release error!", (Throwable)e2);
                    }
                    throw throwable;
                }
            }
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                HttpClientUtils.close((HttpRequestBase)httpPost, response);
                return httpClientResult;
            }
            catch (IOException e) {
                log.error("HttpClientUtils release error!", (Throwable)e);
            }
            return httpClientResult;
        });
    }

    private static HttpEntity getFileUploadHttpEntity(Map<String, String> params, Map<String, String> bodyParams, InputStream inputStream, String fileName) throws UnsupportedEncodingException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("file", inputStream, ContentType.create((String)"multipart/form-data"), fileName);
        if (!CollectionUtils.isEmpty(bodyParams)) {
            for (String string : bodyParams.keySet()) {
                builder.addTextBody(string, bodyParams.get(string));
            }
        }
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry entry : params.entrySet()) {
                builder.addPart((String)entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), ContentType.MULTIPART_FORM_DATA));
            }
        }
        builder.setCharset(CharsetUtils.get((String)ENCODING));
        return builder.build();
    }

    public static HttpClientResult doDelete(String url, Map<String, String> headers, String req) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            HttpDeleteWithBody httpDelete = null;
            CloseableHttpResponse response = null;
            try {
                httpDelete = new HttpDeleteWithBody(url);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpDelete);
                httpDelete.setHeader("Content-Type", "application/json;charset=UTF-8");
                StringEntity stringEntity = new StringEntity(req, ENCODING);
                stringEntity.setContentEncoding(ENCODING);
                httpDelete.setEntity((HttpEntity)stringEntity);
                response = httpClient.execute((HttpUriRequest)httpDelete);
                HttpClientResult res = HttpClientUtils.getHttpClientResult(response);
                log.info("doDeleteJSON uri:{}, req:{}, resp:{}", new Object[]{url, "headers:" + HttpClientUtils.getHeaders((HttpRequestBase)httpDelete) + "------req:" + req, res});
                httpClientResult = res;
            }
            catch (Exception e) {
                try {
                    log.error("doDeleteJSON error! uri:{}, req:{}", new Object[]{url, "headers:" + headers + "------req:" + req, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    HttpClientUtils.close((HttpRequestBase)httpDelete, response);
                    throw throwable;
                }
            }
            HttpClientUtils.close((HttpRequestBase)httpDelete, response);
            return httpClientResult;
        });
    }

    public static HttpClientResult doPutJson(String url, Map<String, String> headers, String req) {
        return RetryUtils.exec(() -> {
            HttpClientResult httpClientResult;
            HttpPut httpPut = null;
            CloseableHttpResponse response = null;
            try {
                httpPut = new HttpPut(url);
                HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPut);
                httpPut.setHeader("Content-Type", "application/json;charset=UTF-8");
                StringEntity stringEntity = new StringEntity(req, ENCODING);
                stringEntity.setContentEncoding(ENCODING);
                httpPut.setEntity((HttpEntity)stringEntity);
                response = httpClient.execute((HttpUriRequest)httpPut);
                HttpClientResult res = HttpClientUtils.getHttpClientResult(response);
                log.info("doPutJSON uri:{}, req:{}, resp:{}", new Object[]{url, "headers:" + HttpClientUtils.getHeaders((HttpRequestBase)httpPut) + "------req:" + req, res});
                httpClientResult = res;
            }
            catch (Exception e) {
                try {
                    log.error("doPutJSON error! uri:{}, req:{}", new Object[]{url, "headers:" + headers + "------req:" + req, e});
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    HttpClientUtils.close((HttpRequestBase)httpPut, response);
                    throw throwable;
                }
            }
            HttpClientUtils.close((HttpRequestBase)httpPut, response);
            return httpClientResult;
        });
    }

    static {
        HttpClientUtils.init();
    }

    private static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public HttpDeleteWithBody() {
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

