/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    public static final JsonUtil INSTANCE = new JsonUtil();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonUtil() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public static <T> T toObject(JsonNode jsonNode, Class<T> clazz) {
        return INSTANCE.asObject(jsonNode, clazz);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return INSTANCE.asObject(json, clazz);
    }

    public static <T, W> W toObject(String json, Class<W> wrapperClass, Class<T> typeClass) {
        return INSTANCE.asObject(json, wrapperClass, typeClass);
    }

    public static <T> T toObject(String json, TypeReference<T> typeReference) {
        return INSTANCE.asObject(json, typeReference);
    }

    public static <T> T toObject(byte[] json, Class<T> clazz) {
        return INSTANCE.asObject(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        return INSTANCE.asList(json, clazz);
    }

    public static <T> Set<T> toSet(String json, Class<T> clazz) {
        return INSTANCE.asSet(json, clazz);
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> keyClass, Class<V> valueClass) {
        return INSTANCE.asMap(json, keyClass, valueClass);
    }

    public static Map<String, Object> objectToMap(Object obj) {
        return INSTANCE.asobjectToMap(obj);
    }

    public static Map<String, String> objectToMapString(Object obj) {
        return INSTANCE.asObjectToMapString(obj);
    }

    public static <V> List<Map<String, V>> jsonToListMap(String json, Class<V> clazz) {
        return INSTANCE.asjsonToListMap(json, clazz);
    }

    public static <T> T mapToObject(Map<?, ?> map, Class<T> clazz) {
        return INSTANCE.asmapToObject(map, clazz);
    }

    public static String toString(Object object) {
        return INSTANCE.asString(object);
    }

    public static String toString(Object object, boolean pretty) {
        return INSTANCE.asString(object, pretty);
    }

    public static String prettyToString(Object object) {
        return INSTANCE.prettyAsString(object);
    }

    public static JsonNode readTree(String json) {
        return INSTANCE.asTree(json);
    }

    public static <T> T clone(T object, Class<T> clazz) {
        return INSTANCE.asClone(object, clazz);
    }

    public static ObjectNode getNode(Object object) {
        return INSTANCE.asNode(object);
    }

    public static boolean isJson(String json) {
        return INSTANCE.isJsonValid(json);
    }

    public <T> T asObject(JsonNode jsonNode, Class<T> clazz) {
        if (jsonNode == null) {
            return null;
        }
        try {
            JsonUtil.notNull(clazz, "class is null");
            return (T)this.objectMapper.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> T asObject(String json, Class<T> clazz) {
        try {
            if (StringUtils.isBlank((CharSequence)json)) {
                return null;
            }
            JsonUtil.notNull(clazz, "class is null");
            if (clazz == String.class) {
                return (T)json;
            }
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T, W> W asObject(String json, Class<W> wrapperClass, Class<T> typeClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            JsonUtil.notNull(wrapperClass, "wrapperClass is null");
            JsonUtil.notNull(typeClass, "typeClass is null");
            JavaType type = this.objectMapper.getTypeFactory().constructParametricType(wrapperClass, new Class[]{typeClass});
            return (W)this.objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> T asObject(String json, TypeReference<T> typeReference) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            JsonUtil.notNull(typeReference, "typeReference is null");
            return (T)this.objectMapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> T asObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return this.asObject(new String(bytes, Charset.forName("utf-8")), clazz);
    }

    public <T> List<T> asList(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList();
        }
        try {
            JsonUtil.notNull(clazz, "class is null");
            CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)this.objectMapper.readValue(json, (JavaType)type);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> Set<T> asSet(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            JsonUtil.notNull(clazz, "class is null");
            CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(Set.class, clazz);
            return (Set)this.objectMapper.readValue(json, (JavaType)type);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <K, V> Map<K, V> asMap(String json, Class<K> keyClass, Class<V> valueClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            JsonUtil.notNull(keyClass, "key class is null");
            JsonUtil.notNull(valueClass, "value class is null");
            JavaType type = this.objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{keyClass, valueClass});
            return (Map)this.objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public Map<String, Object> asobjectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Map)this.objectMapper.convertValue(obj, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, String> asObjectToMapString(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Map)this.objectMapper.convertValue(obj, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public <T> T asmapToObject(Map<?, ?> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        return (T)this.objectMapper.convertValue(map, clazz);
    }

    public <V> List<Map<String, V>> asjsonToListMap(String json, Class<V> clazz) {
        try {
            TypeFactory typeFactory = this.getObjectMapper().getTypeFactory();
            MapType mapType = typeFactory.constructMapType(Map.class, String.class, clazz);
            CollectionType collectionType = typeFactory.constructCollectionType(List.class, (JavaType)mapType);
            return (List)this.getObjectMapper().readValue(json, (JavaType)collectionType);
        }
        catch (Exception e) {
            log.error("json:{} to listMap error:", (Object)json, (Object)e);
            return null;
        }
    }

    public String asString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public String asString(Object object, boolean pretty) {
        return pretty ? this.prettyAsString(object) : this.asString(object);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String prettyAsString(Object object) {
        String string;
        block6: {
            if (object == null) {
                return "";
            }
            if (!(object instanceof String)) return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            string = (String)object;
            if (string.startsWith("{") && string.endsWith("}")) break block6;
            return string;
            {
                catch (Exception e) {
                    throw new JsonException(e);
                }
            }
        }
        try {
            JsonNode jsonNode = JsonUtil.readTree(string);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (Exception e) {
            return string;
        }
    }

    public JsonNode asTree(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> T asClone(T object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        try {
            JsonUtil.notNull(clazz, "class is null");
            String json = JsonUtil.toString(object);
            return JsonUtil.toObject(json, clazz);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public boolean isJsonValid(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return false;
        }
        try {
            this.objectMapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public ObjectNode asNode(Object object) {
        if (object == null) {
            return null;
        }
        return (ObjectNode)this.objectMapper.convertValue(object, ObjectNode.class);
    }

    public static void notNull(Object object, String description) {
        if (object == null) {
            description = StringUtils.isBlank((CharSequence)description) ? "\u53c2\u6570" : description;
            throw new InvalidParameterException(description + "\u4e3a\u7a7a");
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static class JsonException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private JsonException() {
        }

        private JsonException(String message) {
            super(message);
        }

        private JsonException(String message, Throwable cause) {
            super(message, cause);
        }

        private JsonException(Throwable cause) {
            super(cause);
        }

        private JsonException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

