/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.tencent.supersonic.common.pojo.Constants;
import com.tencent.supersonic.common.pojo.Criterion;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SqlFilterUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlFilterUtils.class);
    private static String pattern = "^'.*?'$";
    private static String numericPattern = "^[0-9]+$";

    public List<String> getFiltersCol(List<Filter> filters) {
        ArrayList<String> filterCols = new ArrayList<String>();
        if (CollectionUtils.isEmpty(filters)) {
            return filterCols;
        }
        for (Filter filter : filters) {
            filterCols.addAll(this.getFilterCol(filter));
        }
        return filterCols;
    }

    private List<String> getFilterCol(Filter filter) {
        List<Filter> children;
        ArrayList<String> filterCols = new ArrayList<String>();
        if (Filter.Relation.FILTER.equals((Object)filter.getRelation()) && StringUtils.isNotEmpty((CharSequence)filter.getBizName())) {
            filterCols.add(filter.getBizName());
        }
        if (!CollectionUtils.isEmpty(children = filter.getChildren())) {
            for (Filter child : children) {
                filterCols.addAll(this.getFilterCol(child));
            }
        }
        return filterCols;
    }

    public String getWhereClause(List<Filter> filters, boolean isBizName) {
        StringJoiner joiner = new StringJoiner(Constants.AND_UPPER);
        if (!CollectionUtils.isEmpty(filters)) {
            filters.stream().forEach(filter -> {
                if (StringUtils.isNotEmpty((CharSequence)this.dealFilter((Filter)filter, isBizName))) {
                    joiner.add(Constants.SPACE + this.dealFilter((Filter)filter, isBizName) + Constants.SPACE);
                }
            });
            log.debug("getWhereClause, where sql : {}", (Object)joiner);
            return joiner.toString();
        }
        return "";
    }

    public String getWhereClause(List<Filter> filters) {
        return this.getWhereClause(filters, true);
    }

    public String dealFilter(Filter filter, boolean isBizName) {
        if (Objects.isNull(filter)) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getBizName()) && filter.getBizName().endsWith(Constants.SYS_VAR)) {
            return "";
        }
        StringBuilder condition = new StringBuilder();
        if (Filter.Relation.FILTER.equals((Object)filter.getRelation())) {
            return this.dealSingleFilter(filter, isBizName);
        }
        List<Filter> children = filter.getChildren();
        condition.append("(");
        StringJoiner joiner = new StringJoiner(Constants.SPACE + filter.getRelation().name() + Constants.SPACE);
        for (Filter child : children) {
            joiner.add(this.dealFilter(child, isBizName));
        }
        condition.append(joiner.toString());
        condition.append(")");
        return condition.toString();
    }

    private String dealSingleFilter(Filter filter, boolean isBizName) {
        String name = filter.getBizName();
        if (!isBizName) {
            name = filter.getName();
        }
        Object value = filter.getValue();
        FilterOperatorEnum operator = filter.getOperator();
        String dataType = Criterion.StringDataType.STRING.name();
        Criterion criterion = new Criterion(name, operator, value, dataType);
        return this.generator(criterion);
    }

    private String generator(Criterion criterion) {
        log.debug("criterion :{}", (Object)criterion);
        return switch (criterion.getOperator()) {
            case FilterOperatorEnum.SQL_PART -> this.sqlPartLogic(criterion);
            case FilterOperatorEnum.IS_NULL, FilterOperatorEnum.IS_NOT_NULL -> this.judgeNullLogic(criterion);
            case FilterOperatorEnum.EQUALS, FilterOperatorEnum.NOT_EQUALS, FilterOperatorEnum.GREATER_THAN, FilterOperatorEnum.GREATER_THAN_EQUALS, FilterOperatorEnum.MINOR_THAN, FilterOperatorEnum.MINOR_THAN_EQUALS -> this.singleValueLogic(criterion);
            case FilterOperatorEnum.BETWEEN -> this.betweenLogic(criterion);
            case FilterOperatorEnum.IN, FilterOperatorEnum.NOT_IN -> this.inLogic(criterion);
            case FilterOperatorEnum.LIKE -> this.likeLogic(criterion);
            default -> throw new IllegalStateException("Unexpected value: " + criterion.getOperator());
        };
    }

    private String likeLogic(Criterion criterion) {
        if (Objects.isNull(criterion) || Objects.isNull(criterion.getValue())) {
            throw new RuntimeException("criterion.getValue() can not be null");
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(criterion.getColumn() + Constants.SPACE + criterion.getOperator().getValue() + Constants.SPACE);
        String value = criterion.getValue().toString();
        if (criterion.isNeedApostrophe() && !Pattern.matches(pattern, value)) {
            whereClause.append("'" + value + "%'");
        } else {
            whereClause.append("'" + value.replaceAll("'", "%") + "'");
        }
        return whereClause.toString();
    }

    private String inLogic(Criterion criterion) {
        if (Objects.isNull(criterion) || Objects.isNull(criterion.getValue())) {
            throw new RuntimeException("criterion.getValue() can not be null");
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(criterion.getColumn() + Constants.SPACE + criterion.getOperator().getValue() + Constants.SPACE);
        List values = (List)criterion.getValue();
        whereClause.append("(");
        StringJoiner joiner = new StringJoiner(",");
        if (criterion.isNeedApostrophe()) {
            values.stream().forEach(value -> joiner.add(this.valueApostropheLogic(value.toString())));
        } else {
            values.stream().forEach(value -> joiner.add(value.toString()));
        }
        whereClause.append(joiner);
        whereClause.append(")");
        return whereClause.toString();
    }

    private String betweenLogic(Criterion criterion) {
        if (Objects.isNull(criterion) || Objects.isNull(criterion.getValue())) {
            throw new RuntimeException("criterion.getValue() can not be null");
        }
        List values = (List)criterion.getValue();
        if (values.size() != 2) {
            throw new RuntimeException("between value size should be 2");
        }
        if (criterion.isNeedApostrophe()) {
            return String.format("(%s >= %s and %s <= %s)", criterion.getColumn(), this.valueApostropheLogic(values.get(0).toString()), criterion.getColumn(), this.valueApostropheLogic(values.get(1).toString()));
        }
        return String.format("(%s >= %s and %s <= %s)", criterion.getColumn(), values.get(0).toString(), criterion.getColumn(), values.get(1).toString());
    }

    private String singleValueLogic(Criterion criterion) {
        if (Objects.isNull(criterion) || Objects.isNull(criterion.getValue())) {
            throw new RuntimeException("criterion.getValue() can not be null");
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(criterion.getColumn() + Constants.SPACE + criterion.getOperator().getValue() + Constants.SPACE);
        String value = criterion.getValue().toString();
        if (criterion.isNeedApostrophe()) {
            value = this.valueApostropheLogic(value);
        }
        whereClause.append(value);
        return whereClause.toString();
    }

    private String valueApostropheLogic(String value) {
        if (Pattern.matches(pattern, value) || Pattern.matches(numericPattern, value)) {
            return value;
        }
        return "'" + value + "'";
    }

    private String judgeNullLogic(Criterion criterion) {
        if (Objects.isNull(criterion) || Objects.isNull(criterion.getColumn())) {
            throw new RuntimeException("criterion.getColumn() can not be null");
        }
        return String.format("( %s %s)", criterion.getColumn(), criterion.getOperator().getValue());
    }

    private String sqlPartLogic(Criterion criterion) {
        if (Objects.isNull(criterion) || Objects.isNull(criterion.getValue())) {
            throw new RuntimeException("criterion.getValue() can not be null");
        }
        return "(" + Constants.SPACE + criterion.getValue().toString() + Constants.SPACE + ")";
    }
}

