/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.chroma.spring;

import dev.langchain4j.chroma.spring.EmbeddingStoreProperties;
import dev.langchain4j.chroma.spring.Properties;
import dev.langchain4j.inmemory.spring.InMemoryEmbeddingStoreFactory;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreFactory;
import dev.langchain4j.store.embedding.chroma.ChromaEmbeddingStore;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromaEmbeddingStoreFactory
implements EmbeddingStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(ChromaEmbeddingStoreFactory.class);
    private Properties properties;

    public ChromaEmbeddingStoreFactory(Properties properties) {
        this.properties = properties;
    }

    @Override
    public EmbeddingStore create(String collectionName) {
        EmbeddingStoreProperties storeProperties = this.properties.getEmbeddingStore();
        ChromaEmbeddingStore embeddingStore = null;
        try {
            embeddingStore = ChromaEmbeddingStore.builder().baseUrl(storeProperties.getBaseUrl()).collectionName(collectionName).timeout(storeProperties.getTimeout()).build();
        }
        catch (Exception e) {
            log.warn("Failed to create ChromaEmbeddingStore,collectionName:{}, fallback to the default InMemoryEmbeddingStore method\u3002", (Object)collectionName, (Object)e.getMessage());
        }
        if (Objects.isNull(embeddingStore)) {
            embeddingStore = this.createInMemoryEmbeddingStore(collectionName);
        }
        return embeddingStore;
    }

    private EmbeddingStore createInMemoryEmbeddingStore(String collectionName) {
        dev.langchain4j.inmemory.spring.Properties properties = new dev.langchain4j.inmemory.spring.Properties();
        dev.langchain4j.inmemory.spring.EmbeddingStoreProperties embeddingStoreProperties = new dev.langchain4j.inmemory.spring.EmbeddingStoreProperties();
        properties.setEmbeddingStore(embeddingStoreProperties);
        return new InMemoryEmbeddingStoreFactory(properties).create(collectionName);
    }
}

