/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.model.embedding.AbstractInProcessEmbeddingModel;
import dev.langchain4j.model.embedding.OnnxBertBiEncoder;
import dev.langchain4j.model.embedding.PoolingMode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public class S2OnnxEmbeddingModel
extends AbstractInProcessEmbeddingModel {
    private final OnnxBertBiEncoder model;

    public S2OnnxEmbeddingModel(String pathToModel, String vocabularyPath) {
        URL resource = AbstractInProcessEmbeddingModel.class.getResource("/bert-vocabulary-en.txt");
        if (StringUtils.isNotBlank((CharSequence)vocabularyPath)) {
            try {
                resource = Paths.get(vocabularyPath, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.model = S2OnnxEmbeddingModel.loadFromFileSystem(Paths.get(pathToModel, new String[0]), resource);
    }

    public S2OnnxEmbeddingModel(String pathToModel) {
        this(pathToModel, null);
    }

    protected OnnxBertBiEncoder model() {
        return this.model;
    }

    static OnnxBertBiEncoder loadFromFileSystem(Path pathToModel, URL vocabularyFile) {
        try {
            return new OnnxBertBiEncoder(Files.newInputStream(pathToModel, new OpenOption[0]), vocabularyFile.openStream(), PoolingMode.MEAN);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

