/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.provider;

import com.tencent.supersonic.common.config.LLMConfig;
import com.tencent.supersonic.common.util.ContextUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.provider.ChatLanguageModelFactory;
import dev.langchain4j.model.provider.LocalAiChatModelFactory;
import dev.langchain4j.model.provider.ModelProvider;
import dev.langchain4j.model.provider.OllamaChatModelFactory;
import dev.langchain4j.model.provider.OpenAiChatModelFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ChatLanguageModelProvider {
    private static final Map<String, ChatLanguageModelFactory> factories = new HashMap<String, ChatLanguageModelFactory>();

    public static ChatLanguageModel provide(LLMConfig llmConfig) {
        if (llmConfig == null || StringUtils.isBlank((CharSequence)llmConfig.getProvider()) || StringUtils.isBlank((CharSequence)llmConfig.getBaseUrl())) {
            return ContextUtils.getBean(ChatLanguageModel.class);
        }
        ChatLanguageModelFactory factory = factories.get(llmConfig.getProvider().toUpperCase());
        if (factory != null) {
            return factory.create(llmConfig);
        }
        throw new RuntimeException("Unsupported provider: " + llmConfig.getProvider());
    }

    static {
        factories.put(ModelProvider.OPEN_AI.name(), new OpenAiChatModelFactory());
        factories.put(ModelProvider.LOCAL_AI.name(), new LocalAiChatModelFactory());
        factories.put(ModelProvider.OLLAMA.name(), new OllamaChatModelFactory());
    }
}

