/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import com.google.common.base.Objects;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Retrieval {
    protected String id;
    protected double distance;
    protected String query;
    protected Map<String, Object> metadata;

    public static Long getLongId(Object id) {
        if (id == null || StringUtils.isBlank((CharSequence)id.toString())) {
            return null;
        }
        String[] split = id.toString().split("_");
        return Long.parseLong(split[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Retrieval retrieval = (Retrieval)o;
        return Double.compare(retrieval.distance, this.distance) == 0 && Objects.equal((Object)this.id, (Object)retrieval.id) && Objects.equal((Object)this.query, (Object)retrieval.query) && Objects.equal(this.metadata, retrieval.metadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.distance, this.query, this.metadata});
    }

    public String getId() {
        return this.id;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return "Retrieval(id=" + this.getId() + ", distance=" + this.getDistance() + ", query=" + this.getQuery() + ", metadata=" + this.getMetadata() + ")";
    }
}

