/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import com.alibaba.fastjson.JSONObject;
import com.tencent.supersonic.common.pojo.DataItem;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TextSegmentConvert {
    public static final String QUERY_ID = "queryId";

    public static List<TextSegment> convertToEmbedding(List<DataItem> dataItems) {
        return dataItems.stream().map(dataItem -> {
            Map meta = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataItem), Map.class);
            TextSegment textSegment = TextSegment.from((String)dataItem.getName(), (Metadata)new Metadata(meta));
            TextSegmentConvert.addQueryId(textSegment, dataItem.getId() + dataItem.getType().name().toLowerCase());
            return textSegment;
        }).collect(Collectors.toList());
    }

    public static void addQueryId(TextSegment textSegment, String queryId) {
        textSegment.metadata().put(QUERY_ID, queryId);
    }

    public static String getQueryId(TextSegment textSegment) {
        if (Objects.isNull(textSegment) || Objects.isNull(textSegment.metadata())) {
            return null;
        }
        return textSegment.metadata().get(QUERY_ID);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextSegmentConvert)) {
            return false;
        }
        TextSegmentConvert other = (TextSegmentConvert)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextSegmentConvert;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TextSegmentConvert()";
    }
}

