/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class LoadRemoveService {
    private static final Logger log = LoggerFactory.getLogger(LoadRemoveService.class);
    @Value(value="${s2.mapper.remove.nature.prefix:}")
    private String mapperRemoveNaturePrefix;

    public List removeNatures(List value) {
        if (CollectionUtils.isEmpty((Collection)value)) {
            return value;
        }
        ArrayList<String> resultList = new ArrayList<String>(value);
        if (StringUtils.isNotBlank((CharSequence)this.mapperRemoveNaturePrefix)) {
            resultList.removeIf(nature -> {
                if (Objects.isNull(nature)) {
                    return false;
                }
                return nature.startsWith(this.mapperRemoveNaturePrefix);
            });
        }
        return resultList;
    }

    public Long getDataSetId(String nature) {
        try {
            String[] split = nature.split("_");
            if (split.length <= 1) {
                return null;
            }
            return Long.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public String getMapperRemoveNaturePrefix() {
        return this.mapperRemoveNaturePrefix;
    }

    public void setMapperRemoveNaturePrefix(String mapperRemoveNaturePrefix) {
        this.mapperRemoveNaturePrefix = mapperRemoveNaturePrefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadRemoveService)) {
            return false;
        }
        LoadRemoveService other = (LoadRemoveService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mapperRemoveNaturePrefix = this.getMapperRemoveNaturePrefix();
        String other$mapperRemoveNaturePrefix = other.getMapperRemoveNaturePrefix();
        return !(this$mapperRemoveNaturePrefix == null ? other$mapperRemoveNaturePrefix != null : !this$mapperRemoveNaturePrefix.equals(other$mapperRemoveNaturePrefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoadRemoveService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mapperRemoveNaturePrefix = this.getMapperRemoveNaturePrefix();
        result = result * 59 + ($mapperRemoveNaturePrefix == null ? 43 : $mapperRemoveNaturePrefix.hashCode());
        return result;
    }

    public String toString() {
        return "LoadRemoveService(mapperRemoveNaturePrefix=" + this.getMapperRemoveNaturePrefix() + ")";
    }
}

