/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.common;

import com.hankcs.hanlp.corpus.tag.Nature;

public class Term {
    public String word;
    public Nature nature;
    public int offset;
    public int frequency = 0;

    public Term(String word, Nature nature) {
        this.word = word;
        this.nature = nature;
    }

    public Term(String word, Nature nature, int offset) {
        this.word = word;
        this.nature = nature;
        this.offset = offset;
    }

    public Term(String word, Nature nature, int offset, int frequency) {
        this.word = word;
        this.nature = nature;
        this.offset = offset;
        this.frequency = frequency;
    }

    public int length() {
        return this.word.length();
    }

    public int getFrequency() {
        if (this.frequency > 0) {
            return this.frequency;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Term) {
            Term term = (Term)obj;
            if (this.nature == term.nature && this.word.equals(term.word)) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public String getWord() {
        return this.word;
    }

    public Nature getNature() {
        return this.nature;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void setNature(Nature nature) {
        this.nature = nature;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public String toString() {
        return "Term(word=" + this.getWord() + ", nature=" + this.getNature() + ", offset=" + this.getOffset() + ", frequency=" + this.getFrequency() + ")";
    }
}

