/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.config;

import com.tencent.supersonic.common.pojo.Parameter;
import com.tencent.supersonic.common.service.SystemConfigService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public abstract class ParameterConfig {
    @Autowired
    private SystemConfigService sysConfigService;
    @Autowired
    private Environment environment;

    protected abstract List<Parameter> getSysParameters();

    public String getParameterValue(Parameter parameter) {
        String paramName = parameter.getName();
        String value = this.sysConfigService.getSystemConfig().getParameterByName(paramName);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = this.environment.containsProperty(paramName) ? this.environment.getProperty(paramName) : parameter.getDefaultValue();
        }
        return value;
    }
}

