/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.config;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.config.ParameterConfig;
import com.tencent.supersonic.common.pojo.Parameter;
import com.tencent.supersonic.common.util.ContextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class SystemConfig {
    private Integer id;
    private List<String> admins;
    private List<Parameter> parameters;

    public void init() {
        this.parameters = this.buildDefaultParameters();
        this.admins = Lists.newArrayList((Object[])new String[]{"admin"});
    }

    public String getAdmin() {
        if (CollectionUtils.isEmpty(this.admins)) {
            return "";
        }
        return StringUtils.join(this.admins, (String)",");
    }

    public String getParameterByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        Map<String, String> nameToValue = this.getParameters().stream().collect(Collectors.toMap(Parameter::getName, Parameter::getValue, (k1, k2) -> k1));
        return nameToValue.get(name);
    }

    public void setAdminList(String admin) {
        this.admins = StringUtils.isNotBlank((CharSequence)admin) ? Arrays.asList(admin.split(",")) : Lists.newArrayList();
    }

    private List<Parameter> buildDefaultParameters() {
        ArrayList defaultParameters = Lists.newArrayList();
        Collection<ParameterConfig> configurableParameters = ContextUtils.getBeansOfType(ParameterConfig.class).values();
        for (ParameterConfig configParameters : configurableParameters) {
            defaultParameters.addAll(configParameters.getSysParameters());
        }
        return defaultParameters;
    }

    public List<Parameter> getParameters() {
        List<Parameter> defaultParameters = this.buildDefaultParameters();
        if (CollectionUtils.isEmpty(this.parameters)) {
            return defaultParameters;
        }
        Map<String, String> parameterNameValueMap = this.parameters.stream().collect(Collectors.toMap(Parameter::getName, Parameter::getValue, (v1, v2) -> v2));
        for (Parameter parameter : defaultParameters) {
            parameter.setValue(parameterNameValueMap.getOrDefault(parameter.getName(), parameter.getDefaultValue()));
        }
        return defaultParameters;
    }

    public Integer getId() {
        return this.id;
    }

    public List<String> getAdmins() {
        return this.admins;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setAdmins(List<String> admins) {
        this.admins = admins;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemConfig)) {
            return false;
        }
        SystemConfig other = (SystemConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<String> this$admins = this.getAdmins();
        List<String> other$admins = other.getAdmins();
        if (this$admins == null ? other$admins != null : !((Object)this$admins).equals(other$admins)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<String> $admins = this.getAdmins();
        result = result * 59 + ($admins == null ? 43 : ((Object)$admins).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "SystemConfig(id=" + this.getId() + ", admins=" + this.getAdmins() + ", parameters=" + this.getParameters() + ")";
    }
}

