/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.QueryExpressionReplaceVisitor;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;

public class ExpressionReplaceVisitor
extends ExpressionVisitorAdapter {
    private Map<String, String> fieldExprMap;

    public ExpressionReplaceVisitor(Map<String, String> fieldExprMap) {
        this.fieldExprMap = fieldExprMap;
    }

    public void visit(WhenClause expr) {
        expr.getWhenExpression().accept((ExpressionVisitor)this);
        if (expr.getThenExpression() instanceof Column) {
            Column column = (Column)expr.getThenExpression();
            Expression expression = QueryExpressionReplaceVisitor.getExpression(QueryExpressionReplaceVisitor.getReplaceExpr(column, this.fieldExprMap));
            if (Objects.nonNull(expression)) {
                expr.setThenExpression(expression);
            }
        } else {
            expr.getThenExpression().accept((ExpressionVisitor)this);
        }
    }

    protected void visitBinaryExpression(BinaryExpression expr) {
        Expression expression;
        Function function;
        Function leftFunc;
        Expression left = expr.getLeftExpression();
        Expression right = expr.getRightExpression();
        Boolean leftVisited = false;
        Boolean rightVisited = false;
        if (left instanceof Function && this.visitFunction(leftFunc = (Function)left)) {
            leftVisited = true;
        }
        if (right instanceof Function && this.visitFunction(function = (Function)right)) {
            rightVisited = true;
        }
        if (left instanceof Column && Objects.nonNull(expression = QueryExpressionReplaceVisitor.getExpression(QueryExpressionReplaceVisitor.getReplaceExpr((Column)left, this.fieldExprMap)))) {
            expr.setLeftExpression(expression);
            leftVisited = true;
        }
        if (right instanceof Column && Objects.nonNull(expression = QueryExpressionReplaceVisitor.getExpression(QueryExpressionReplaceVisitor.getReplaceExpr((Column)right, this.fieldExprMap)))) {
            expr.setRightExpression(expression);
            rightVisited = true;
        }
        if (!leftVisited.booleanValue()) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
        }
        if (!rightVisited.booleanValue()) {
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }
    }

    private boolean visitFunction(Function function) {
        Expression expression;
        if (function.getParameters().getExpressions().get(0) instanceof Column && Objects.nonNull(expression = QueryExpressionReplaceVisitor.getExpression(QueryExpressionReplaceVisitor.getReplaceExpr(function, this.fieldExprMap)))) {
            ExpressionList expressions = new ExpressionList(new Expression[0]);
            expressions.add((Object)expression);
            for (int i = 1; i < function.getParameters().size(); ++i) {
                expressions.add((Object)((Expression)function.getParameters().get(i)));
            }
            function.setParameters(expressions);
            return true;
        }
        return false;
    }
}

