/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.ParseVisitorHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FieldlValueReplaceVisitor
extends ExpressionVisitorAdapter {
    private static final Logger log = LoggerFactory.getLogger(FieldlValueReplaceVisitor.class);
    ParseVisitorHelper parseVisitorHelper = new ParseVisitorHelper();
    private boolean exactReplace;
    private Map<String, Map<String, String>> filedNameToValueMap;

    public FieldlValueReplaceVisitor(boolean exactReplace, Map<String, Map<String, String>> filedNameToValueMap) {
        this.exactReplace = exactReplace;
        this.filedNameToValueMap = filedNameToValueMap;
    }

    public void visit(EqualsTo expr) {
        this.replaceComparisonExpression(expr);
    }

    public void visit(GreaterThan expr) {
        this.replaceComparisonExpression(expr);
    }

    public void visit(GreaterThanEquals expr) {
        this.replaceComparisonExpression(expr);
    }

    public void visit(MinorThanEquals expr) {
        this.replaceComparisonExpression(expr);
    }

    public void visit(MinorThan expr) {
        this.replaceComparisonExpression(expr);
    }

    public void visit(InExpression inExpression) {
        if (!(inExpression.getLeftExpression() instanceof Column)) {
            return;
        }
        Column column = (Column)inExpression.getLeftExpression();
        Map<String, String> valueMap = this.filedNameToValueMap.get(column.getColumnName());
        ExpressionList rightItemsList = (ExpressionList)inExpression.getRightExpression();
        List expressions = rightItemsList.getExpressions();
        ArrayList values = new ArrayList();
        expressions.stream().forEach(o -> {
            if (o instanceof StringValue) {
                values.add(((StringValue)o).getValue());
            }
        });
        if (valueMap == null) {
            return;
        }
        String value = valueMap.get(JsonUtil.toString(values));
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        List<String> valueList = JsonUtil.toList(value, String.class);
        ArrayList newExpressions = new ArrayList();
        valueList.stream().forEach(o -> {
            StringValue stringValue = new StringValue(o);
            newExpressions.add(stringValue);
        });
        rightItemsList.setExpressions(newExpressions);
        inExpression.setRightExpression((Expression)rightItemsList);
    }

    public <T extends Expression> void replaceComparisonExpression(T expression) {
        LongValue rightStringValue;
        String replaceValue;
        Expression leftExpression = ((ComparisonOperator)expression).getLeftExpression();
        Expression rightExpression = ((ComparisonOperator)expression).getRightExpression();
        if (!(leftExpression instanceof Column) && !(leftExpression instanceof Function)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.filedNameToValueMap)) {
            return;
        }
        if (Objects.isNull(rightExpression) || Objects.isNull(leftExpression)) {
            return;
        }
        String columnName = SqlSelectHelper.getColumnName(leftExpression);
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            return;
        }
        Map<String, String> valueMap = this.filedNameToValueMap.get(columnName);
        if (Objects.isNull(valueMap) || valueMap.isEmpty()) {
            return;
        }
        if (rightExpression instanceof LongValue && StringUtils.isNotEmpty((CharSequence)(replaceValue = this.getReplaceValue(valueMap, String.valueOf((rightStringValue = (LongValue)rightExpression).getValue()))))) {
            rightStringValue.setValue(Long.parseLong(replaceValue));
        }
        if (rightExpression instanceof DoubleValue && StringUtils.isNotEmpty((CharSequence)(replaceValue = this.getReplaceValue(valueMap, String.valueOf((rightStringValue = (DoubleValue)rightExpression).getValue()))))) {
            rightStringValue.setValue(Double.parseDouble(replaceValue));
        }
        if (rightExpression instanceof StringValue && StringUtils.isNotEmpty((CharSequence)(replaceValue = this.getReplaceValue(valueMap, String.valueOf((rightStringValue = (StringValue)rightExpression).getValue()))))) {
            rightStringValue.setValue(replaceValue);
        }
    }

    private String getReplaceValue(Map<String, String> valueMap, String beforeValue) {
        String afterValue = valueMap.get(String.valueOf(beforeValue));
        if (StringUtils.isEmpty((CharSequence)afterValue) && !this.exactReplace) {
            return this.parseVisitorHelper.getReplaceValue(beforeValue, valueMap, false);
        }
        return afterValue;
    }
}

