/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiledFilterReplaceVisitor
extends ExpressionVisitorAdapter {
    private static final Logger log = LoggerFactory.getLogger(FiledFilterReplaceVisitor.class);
    private List<Expression> waitingForAdds = new ArrayList<Expression>();
    private Set<String> fieldNames;

    public FiledFilterReplaceVisitor(Set<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void visit(MinorThan expr) {
        List<Expression> expressions = this.parserFilter((ComparisonOperator)expr, " 1 < 2 ");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(EqualsTo expr) {
        List<Expression> expressions = this.parserFilter((ComparisonOperator)expr, " 1 = 1 ");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(MinorThanEquals expr) {
        List<Expression> expressions = this.parserFilter((ComparisonOperator)expr, " 1 <= 1 ");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(GreaterThan expr) {
        List<Expression> expressions = this.parserFilter((ComparisonOperator)expr, " 2 > 1 ");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(GreaterThanEquals expr) {
        List<Expression> expressions = this.parserFilter((ComparisonOperator)expr, " 1 >= 1 ");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public List<Expression> getWaitingForAdds() {
        return this.waitingForAdds;
    }

    public List<Expression> parserFilter(ComparisonOperator comparisonOperator, String condExpr) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        String toString = comparisonOperator.toString();
        Expression leftExpression = comparisonOperator.getLeftExpression();
        if (!(leftExpression instanceof Function)) {
            return result;
        }
        Function leftExpressionFunction = (Function)leftExpression;
        if (leftExpressionFunction.toString().contains("datediff")) {
            return result;
        }
        ExpressionList leftExpressions = leftExpressionFunction.getParameters();
        if (CollectionUtils.isEmpty((Collection)leftExpressions)) {
            return result;
        }
        Column field = (Column)leftExpressions.get(0);
        String columnName = field.getColumnName();
        if (!this.fieldNames.contains(columnName)) {
            return null;
        }
        try {
            ComparisonOperator expression = (ComparisonOperator)CCJSqlParserUtil.parseCondExpression((String)condExpr);
            comparisonOperator.setLeftExpression(expression.getLeftExpression());
            comparisonOperator.setRightExpression(expression.getRightExpression());
            comparisonOperator.setASTNode(expression.getASTNode());
            result.add(CCJSqlParserUtil.parseCondExpression((String)toString));
            return result;
        }
        catch (JSQLParserException e) {
            log.error("JSQLParserException", (Throwable)e);
            return null;
        }
    }
}

