/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionNameReplaceVisitor
extends ExpressionVisitorAdapter {
    private static final Logger log = LoggerFactory.getLogger(FunctionNameReplaceVisitor.class);
    private Map<String, String> functionMap;
    private Map<String, UnaryOperator> functionCallMap;

    public FunctionNameReplaceVisitor(Map<String, String> functionMap) {
        this.functionMap = functionMap;
    }

    public FunctionNameReplaceVisitor(Map<String, String> functionMap, Map<String, UnaryOperator> functionCallMap) {
        this.functionMap = functionMap;
        this.functionCallMap = functionCallMap;
    }

    public void visit(Function function) {
        String functionName = function.getName().toLowerCase();
        String replaceFunctionName = this.functionMap.get(functionName);
        if (StringUtils.isNotBlank((CharSequence)replaceFunctionName)) {
            Object ret;
            function.setName(replaceFunctionName);
            if (Objects.nonNull(this.functionCallMap) && this.functionCallMap.containsKey(functionName) && Objects.nonNull(ret = this.functionCallMap.get(functionName).apply(function.getParameters())) && ret instanceof ExpressionList) {
                ExpressionList expressionList = (ExpressionList)ret;
                function.setParameters(expressionList);
            }
        }
    }
}

