/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.DateFunctionHelper;
import com.tencent.supersonic.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionReplaceVisitor
extends ExpressionVisitorAdapter {
    private static final Logger log = LoggerFactory.getLogger(FunctionReplaceVisitor.class);
    private List<Expression> waitingForAdds = new ArrayList<Expression>();

    public void visit(MinorThan expr) {
        List<Expression> expressions = this.reparseDate((ComparisonOperator)expr, ">");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(EqualsTo expr) {
        List<Expression> expressions = this.reparseDate((ComparisonOperator)expr, ">=");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(MinorThanEquals expr) {
        List<Expression> expressions = this.reparseDate((ComparisonOperator)expr, ">=");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(GreaterThan expr) {
        List<Expression> expressions = this.reparseDate((ComparisonOperator)expr, "<");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public void visit(GreaterThanEquals expr) {
        List<Expression> expressions = this.reparseDate((ComparisonOperator)expr, "<=");
        if (Objects.nonNull(expressions)) {
            this.waitingForAdds.addAll(expressions);
        }
    }

    public List<Expression> getWaitingForAdds() {
        return this.waitingForAdds;
    }

    public List<Expression> reparseDate(ComparisonOperator comparisonOperator, String startDateOperator) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        Expression leftExpression = comparisonOperator.getLeftExpression();
        if (!(leftExpression instanceof Function)) {
            return result;
        }
        Function leftExpressionFunction = (Function)leftExpression;
        if (!leftExpressionFunction.toString().contains("datediff")) {
            return result;
        }
        ExpressionList leftExpressions = leftExpressionFunction.getParameters();
        if (CollectionUtils.isEmpty((Collection)leftExpressions) || leftExpressions.size() < 3) {
            return result;
        }
        Column field = (Column)leftExpressions.get(1);
        String columnName = field.getColumnName();
        try {
            String startDateValue = DateFunctionHelper.getStartDateStr(comparisonOperator, leftExpressions);
            String endDateValue = DateFunctionHelper.getEndDateValue(leftExpressions);
            String endDateOperator = comparisonOperator.getStringExpression();
            String condExpr = columnName + StringUtil.getSpaceWrap(DateFunctionHelper.getEndDateOperator(comparisonOperator)) + StringUtil.getCommaWrap(endDateValue);
            ComparisonOperator expression = (ComparisonOperator)CCJSqlParserUtil.parseCondExpression((String)condExpr);
            String startDataCondExpr = columnName + StringUtil.getSpaceWrap(startDateOperator) + StringUtil.getCommaWrap(startDateValue);
            if ("=".equalsIgnoreCase(endDateOperator)) {
                result.add(CCJSqlParserUtil.parseCondExpression((String)condExpr));
                expression = (ComparisonOperator)CCJSqlParserUtil.parseCondExpression((String)" 1 = 1 ");
            }
            if (startDateOperator.equals("<=") || startDateOperator.equals("<")) {
                comparisonOperator.setLeftExpression((Expression)new Column("1"));
                comparisonOperator.setRightExpression((Expression)new LongValue(1L));
                comparisonOperator.setASTNode(null);
            } else {
                comparisonOperator.setLeftExpression(expression.getLeftExpression());
                comparisonOperator.setRightExpression(expression.getRightExpression());
                comparisonOperator.setASTNode(expression.getASTNode());
            }
            result.add(CCJSqlParserUtil.parseCondExpression((String)startDataCondExpr));
            return result;
        }
        catch (JSQLParserException e) {
            log.error("JSQLParserException", (Throwable)e);
            return null;
        }
    }
}

