/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.ParseVisitorHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.GroupByVisitor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByReplaceVisitor
implements GroupByVisitor {
    private static final Logger log = LoggerFactory.getLogger(GroupByReplaceVisitor.class);
    ParseVisitorHelper parseVisitorHelper = new ParseVisitorHelper();
    private Map<String, String> fieldNameMap;
    private boolean exactReplace;

    public GroupByReplaceVisitor(Map<String, String> fieldNameMap, boolean exactReplace) {
        this.fieldNameMap = fieldNameMap;
        this.exactReplace = exactReplace;
    }

    public void visit(GroupByElement groupByElement) {
        groupByElement.getGroupByExpressionList();
        ExpressionList groupByExpressionList = groupByElement.getGroupByExpressionList();
        List groupByExpressions = groupByExpressionList.getExpressions();
        for (int i = 0; i < groupByExpressions.size(); ++i) {
            String replaceColumn;
            Expression expression = (Expression)groupByExpressions.get(i);
            String columnName = expression.toString();
            if (expression instanceof Function && Objects.nonNull(((Function)expression).getParameters().getExpressions().get(0))) {
                columnName = ((Function)expression).getParameters().getExpressions().get(0).toString();
            }
            if (!StringUtils.isNotEmpty((CharSequence)(replaceColumn = this.parseVisitorHelper.getReplaceValue(columnName, this.fieldNameMap, this.exactReplace)))) continue;
            if (expression instanceof Column) {
                groupByExpressions.set(i, new Column(replaceColumn));
            }
            if (!(expression instanceof Function)) continue;
            try {
                Expression element = CCJSqlParserUtil.parseExpression((String)replaceColumn);
                ExpressionList expressionList = new ExpressionList(new Expression[0]);
                expressionList.add((Object)element);
                if (((Function)expression).getParameters().size() > 1) {
                    ((Function)expression).getParameters().stream().skip(1L).forEach(e -> expressionList.add((Object)((Function)e)));
                }
                ((Function)expression).setParameters(expressionList);
                continue;
            }
            catch (JSQLParserException e2) {
                log.error("e", (Throwable)e2);
            }
        }
    }
}

