/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseVisitorHelper {
    private static final Logger log = LoggerFactory.getLogger(ParseVisitorHelper.class);

    public void replaceColumn(Column column, Map<String, String> fieldNameMap, boolean exactReplace) {
        String columnName = column.getColumnName();
        String replaceColumn = this.getReplaceValue(columnName, fieldNameMap, exactReplace);
        if (StringUtils.isNotBlank((CharSequence)replaceColumn)) {
            column.setColumnName(replaceColumn);
        }
    }

    public String getReplaceValue(String beforeValue, Map<String, String> valueMap, boolean exactReplace) {
        String value = valueMap.get(beforeValue);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        if (exactReplace) {
            return null;
        }
        Optional first = valueMap.entrySet().stream().sorted((k1, k2) -> {
            String k1Value = (String)k1.getKey();
            String k2Value = (String)k2.getKey();
            Double k1Similarity = this.getSimilarity(beforeValue, k1Value);
            Double k2Similarity = this.getSimilarity(beforeValue, k2Value);
            return k2Similarity.compareTo(k1Similarity);
        }).collect(Collectors.toList()).stream().findFirst();
        if (first.isPresent()) {
            return (String)((Map.Entry)first.get()).getValue();
        }
        return beforeValue;
    }

    public static int editDistance(String word1, String word2) {
        int i;
        int m = word1.length();
        int n = word2.length();
        int[][] dp = new int[m + 1][n + 1];
        for (int j = 0; j <= n; ++j) {
            dp[0][j] = j;
        }
        for (i = 0; i <= m; ++i) {
            dp[i][0] = i;
        }
        for (i = 1; i <= m; ++i) {
            char ci = word1.charAt(i - 1);
            for (int j = 1; j <= n; ++j) {
                char cj = word2.charAt(j - 1);
                dp[i][j] = ci == cj ? dp[i - 1][j - 1] : (i > 1 && j > 1 && ci == word2.charAt(j - 2) && cj == word1.charAt(i - 2) ? 1 + Math.min(dp[i - 2][j - 2], Math.min(dp[i][j - 1], dp[i - 1][j])) : Math.min(dp[i - 1][j - 1] + 1, Math.min(dp[i][j - 1] + 1, dp[i - 1][j] + 1)));
            }
        }
        return dp[m][n];
    }

    public double getSimilarity(String word1, String word2) {
        return 1.0 - (double)ParseVisitorHelper.editDistance(word1, word2) / (double)Math.max(word2.length(), word1.length());
    }
}

