/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.jsqlparser;

import com.tencent.supersonic.common.jsqlparser.FiledFilterReplaceVisitor;
import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectFunctionHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlAddHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlAddHelper.class);

    public static String addFieldsToSelect(String sql, List<String> fields) {
        SetOperationList setOperationList;
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return null;
        }
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectStatement;
            fields.stream().filter(Objects::nonNull).forEach(field -> {
                SelectItem selectExpressionItem = new SelectItem((Expression)new Column(field));
                plainSelect.addSelectItems(new SelectItem[]{selectExpressionItem});
            });
        } else if (selectStatement instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = (SetOperationList)selectStatement).getSelects())) {
            setOperationList.getSelects().forEach(subSelectBody -> {
                PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                fields.stream().forEach(field -> {
                    SelectItem selectExpressionItem = new SelectItem((Expression)new Column(field));
                    subPlainSelect.addSelectItems(new SelectItem[]{selectExpressionItem});
                });
            });
        }
        return selectStatement.toString();
    }

    public static String addFunctionToSelect(String sql, List<Expression> expressionList) {
        SetOperationList setOperationList;
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (selectStatement == null) {
            return null;
        }
        ArrayList<PlainSelect> plainSelectList = new ArrayList<PlainSelect>();
        if (selectStatement instanceof PlainSelect) {
            PlainSelect plainSelect = selectStatement.getPlainSelect();
            plainSelectList.add(plainSelect);
        } else if (selectStatement instanceof SetOperationList && !CollectionUtils.isEmpty((Collection)(setOperationList = selectStatement.getSetOperationList()).getSelects())) {
            setOperationList.getSelects().forEach(subSelectBody -> {
                PlainSelect subPlainSelect = (PlainSelect)subSelectBody;
                plainSelectList.add(subPlainSelect);
            });
        }
        if (CollectionUtils.isEmpty(plainSelectList)) {
            return sql;
        }
        for (PlainSelect plainSelect : plainSelectList) {
            List selectItems = plainSelect.getSelectItems();
            if (CollectionUtils.isEmpty((Collection)selectItems)) continue;
            boolean existFunction = false;
            for (Expression expression : expressionList) {
                for (SelectItem selectItem : selectItems) {
                    if (!(selectItem.getExpression() instanceof Function)) continue;
                    Function expressionFunction = (Function)selectItem.getExpression();
                    if (!expression.toString().equalsIgnoreCase(expressionFunction.toString())) continue;
                    existFunction = true;
                    break;
                }
                if (existFunction) continue;
                SelectItem sumExpressionItem = new SelectItem(expression);
                selectItems.add(sumExpressionItem);
            }
        }
        return selectStatement.toString();
    }

    public static String addWhere(String sql, String column, Object value) {
        if (StringUtils.isEmpty((CharSequence)column) || Objects.isNull(value)) {
            return sql;
        }
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Expression where = plainSelect.getWhere();
        StringValue right = new StringValue(value.toString());
        if (value instanceof Integer || value instanceof Long) {
            right = new LongValue(value.toString());
        }
        if (where == null) {
            plainSelect.setWhere((Expression)new EqualsTo((Expression)new Column(column), (Expression)right));
        } else {
            plainSelect.setWhere((Expression)new AndExpression(where, (Expression)new EqualsTo((Expression)new Column(column), (Expression)right)));
        }
        return selectStatement.toString();
    }

    public static String addWhere(String sql, Expression expression) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        List<String> chNameList = TimeDimensionEnum.getChNameList();
        Boolean dateWhere = false;
        for (String chName : chNameList) {
            if (!expression.toString().contains(chName)) continue;
            dateWhere = true;
        }
        List<PlainSelect> plainSelectList = SqlSelectHelper.getWithItem(selectStatement);
        if (!CollectionUtils.isEmpty(plainSelectList) && dateWhere.booleanValue()) {
            List<String> withNameList = SqlSelectHelper.getWithName(sql);
            for (int i = 0; i < plainSelectList.size(); ++i) {
                Table table;
                if (plainSelectList.get(i).getFromItem() instanceof Table && withNameList.contains((table = (Table)plainSelectList.get(i).getFromItem()).getName())) continue;
                HashSet<String> result = new HashSet<String>();
                ArrayList<PlainSelect> subPlainSelectList = new ArrayList<PlainSelect>();
                subPlainSelectList.add(plainSelectList.get(i));
                SqlSelectHelper.getWhereFields(subPlainSelectList, result);
                if (TimeDimensionEnum.containsZhTimeDimension(new ArrayList<String>(result))) continue;
                Expression subWhere = plainSelectList.get(i).getWhere();
                SqlAddHelper.addWhere(plainSelectList.get(i), subWhere, expression);
            }
            return selectStatement.toString();
        }
        if (plainSelect.getFromItem() instanceof ParenthesedSelect && dateWhere.booleanValue()) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)plainSelect.getFromItem();
            PlainSelect subPlainSelect = parenthesedSelect.getPlainSelect();
            Expression subWhere = subPlainSelect.getWhere();
            SqlAddHelper.addWhere(subPlainSelect, subWhere, expression);
            return selectStatement.toString();
        }
        Expression where = plainSelect.getWhere();
        SqlAddHelper.addWhere(plainSelect, where, expression);
        return selectStatement.toString();
    }

    private static void addWhere(PlainSelect plainSelect, Expression where, Expression expression) {
        if (where == null) {
            plainSelect.setWhere(expression);
        } else {
            plainSelect.setWhere((Expression)new AndExpression(where, expression));
        }
    }

    public static String addWhere(String sql, List<Expression> expressionList) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        if (CollectionUtils.isEmpty(expressionList)) {
            return sql;
        }
        Expression expression = expressionList.get(0);
        for (int i = 1; i < expressionList.size(); ++i) {
            expression = new AndExpression(expression, expressionList.get(i));
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Expression where = plainSelect.getWhere();
        if (where == null) {
            plainSelect.setWhere(expression);
        } else {
            plainSelect.setWhere((Expression)new AndExpression(where, expression));
        }
        return selectStatement.toString();
    }

    public static String addAggregateToField(String sql, final Map<String, String> fieldNameToAggregate) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        selectStatement.accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                SqlAddHelper.addAggregateToSelectItems(plainSelect.getSelectItems(), fieldNameToAggregate);
                SqlAddHelper.addAggregateToOrderByItems(plainSelect.getOrderByElements(), fieldNameToAggregate);
                SqlAddHelper.addAggregateToGroupByItems(plainSelect.getGroupBy(), fieldNameToAggregate);
                SqlAddHelper.addAggregateToWhereItems(plainSelect.getWhere(), fieldNameToAggregate);
            }
        });
        return selectStatement.toString();
    }

    public static String addGroupBy(String sql, Set<String> groupByFields) {
        if (CollectionUtils.isEmpty(groupByFields)) {
            return sql;
        }
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        GroupByElement groupByElement = new GroupByElement();
        List<String> originalGroupByFields = SqlSelectHelper.getGroupByFields(sql);
        if (!CollectionUtils.isEmpty(originalGroupByFields)) {
            groupByFields.addAll(originalGroupByFields);
        }
        for (String groupByField : groupByFields) {
            groupByElement.addGroupByExpression((Expression)new Column(groupByField));
        }
        plainSelect.setGroupByElement(groupByElement);
        return selectStatement.toString();
    }

    private static void addAggregateToSelectItems(List<SelectItem<?>> selectItems, Map<String, String> fieldNameToAggregate) {
        for (SelectItem<?> selectItem : selectItems) {
            Expression expression = selectItem.getExpression();
            Function function = SqlSelectFunctionHelper.getFunction(expression, fieldNameToAggregate);
            if (function == null) continue;
            selectItem.setExpression((Expression)function);
        }
    }

    private static void addAggregateToOrderByItems(List<OrderByElement> orderByElements, Map<String, String> fieldNameToAggregate) {
        if (orderByElements == null) {
            return;
        }
        for (OrderByElement orderByElement : orderByElements) {
            Expression expression = orderByElement.getExpression();
            Function function = SqlSelectFunctionHelper.getFunction(expression, fieldNameToAggregate);
            if (function == null) continue;
            orderByElement.setExpression((Expression)function);
        }
    }

    private static void addAggregateToGroupByItems(GroupByElement groupByElement, Map<String, String> fieldNameToAggregate) {
        if (groupByElement == null) {
            return;
        }
        for (int i = 0; i < groupByElement.getGroupByExpressionList().size(); ++i) {
            Expression expression = (Expression)groupByElement.getGroupByExpressionList().get(i);
            Function function = SqlSelectFunctionHelper.getFunction(expression, fieldNameToAggregate);
            if (function == null) continue;
            groupByElement.addGroupByExpression((Expression)function);
        }
    }

    private static void addAggregateToWhereItems(Expression whereExpression, Map<String, String> fieldNameToAggregate) {
        if (whereExpression == null) {
            return;
        }
        SqlAddHelper.modifyWhereExpression(whereExpression, fieldNameToAggregate);
    }

    private static void modifyWhereExpression(Expression whereExpression, Map<String, String> fieldNameToAggregate) {
        if (SqlSelectHelper.isLogicExpression(whereExpression)) {
            Expression rightExpression;
            Expression leftExpression;
            if (whereExpression instanceof AndExpression) {
                AndExpression andExpression = (AndExpression)whereExpression;
                leftExpression = andExpression.getLeftExpression();
                rightExpression = andExpression.getRightExpression();
                SqlAddHelper.modifyWhereExpression(leftExpression, fieldNameToAggregate);
                SqlAddHelper.modifyWhereExpression(rightExpression, fieldNameToAggregate);
            }
            if (whereExpression instanceof OrExpression) {
                OrExpression orExpression = (OrExpression)whereExpression;
                leftExpression = orExpression.getLeftExpression();
                rightExpression = orExpression.getRightExpression();
                SqlAddHelper.modifyWhereExpression(leftExpression, fieldNameToAggregate);
                SqlAddHelper.modifyWhereExpression(rightExpression, fieldNameToAggregate);
            }
        } else if (whereExpression instanceof Parenthesis) {
            SqlAddHelper.modifyWhereExpression(((Parenthesis)whereExpression).getExpression(), fieldNameToAggregate);
        } else {
            SqlAddHelper.setAggToFunction(whereExpression, fieldNameToAggregate);
        }
    }

    private static void setAggToFunction(Expression expression, Map<String, String> fieldNameToAggregate) {
        Function function;
        String columnName;
        if (!(expression instanceof ComparisonOperator)) {
            return;
        }
        ComparisonOperator comparisonOperator = (ComparisonOperator)expression;
        if (comparisonOperator.getRightExpression() instanceof Column) {
            columnName = ((Column)comparisonOperator.getRightExpression()).getColumnName();
            function = SqlSelectFunctionHelper.getFunction(comparisonOperator.getRightExpression(), fieldNameToAggregate.get(columnName));
            if (Objects.nonNull(function)) {
                comparisonOperator.setRightExpression((Expression)function);
            }
        }
        if (comparisonOperator.getLeftExpression() instanceof Column) {
            columnName = ((Column)comparisonOperator.getLeftExpression()).getColumnName();
            function = SqlSelectFunctionHelper.getFunction(comparisonOperator.getLeftExpression(), fieldNameToAggregate.get(columnName));
            if (Objects.nonNull(function)) {
                comparisonOperator.setLeftExpression((Expression)function);
            }
        }
    }

    public static String addHaving(String sql, Set<String> fieldNames) {
        List<Expression> waitingForAdds;
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Expression where = plainSelect.getWhere();
        FiledFilterReplaceVisitor visitor = new FiledFilterReplaceVisitor(fieldNames);
        if (Objects.nonNull(where)) {
            where.accept((ExpressionVisitor)visitor);
        }
        if (!CollectionUtils.isEmpty(waitingForAdds = visitor.getWaitingForAdds())) {
            for (Expression waitingForAdd : waitingForAdds) {
                Expression having = plainSelect.getHaving();
                if (Objects.isNull(having)) {
                    plainSelect.setHaving(waitingForAdd);
                    continue;
                }
                plainSelect.setHaving((Expression)new AndExpression(having, waitingForAdd));
            }
        }
        return SqlRemoveHelper.removeNumberFilter(selectStatement.toString());
    }

    public static String addHaving(String sql, List<Expression> expressionList) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        if (CollectionUtils.isEmpty(expressionList)) {
            return sql;
        }
        Expression expression = expressionList.get(0);
        for (int i = 1; i < expressionList.size(); ++i) {
            expression = new AndExpression(expression, expressionList.get(i));
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Expression having = plainSelect.getHaving();
        if (having == null) {
            plainSelect.setHaving(expression);
        } else {
            plainSelect.setHaving((Expression)new AndExpression(having, expression));
        }
        return selectStatement.toString();
    }

    public static String addParenthesisToWhere(String sql) {
        Select selectStatement = SqlSelectHelper.getSelect(sql);
        if (!(selectStatement instanceof PlainSelect)) {
            return sql;
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        Expression where = plainSelect.getWhere();
        if (Objects.nonNull(where)) {
            Parenthesis parenthesis = new Parenthesis(where);
            plainSelect.setWhere((Expression)parenthesis);
        }
        return selectStatement.toString();
    }
}

