/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.ItemDateResp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DateModeUtils {
    private static final Logger log = LoggerFactory.getLogger(DateModeUtils.class);
    @Value(value="${s2.query.parameter.sys.date:sys_imp_date}")
    private String sysDateCol;
    @Value(value="${s2.query.parameter.sys.month:sys_imp_month}")
    private String sysDateMonthCol;
    @Value(value="${s2.query.parameter.sys.month:sys_imp_week}")
    private String sysDateWeekCol;
    @Value(value="${s2.query.parameter.sys.zipper.begin:start_}")
    private String sysZipperDateColBegin;
    @Value(value="${s2.query.parameter.sys.zipper.end:end_}")
    private String sysZipperDateColEnd;

    public Boolean recentMode(DateConf dateInfo) {
        if (Objects.nonNull(dateInfo) && DateConf.DateMode.RECENT == dateInfo.getDateMode() && "DAY".equalsIgnoreCase(dateInfo.getPeriod()) && Objects.nonNull(dateInfo.getUnit())) {
            return true;
        }
        return false;
    }

    public boolean hasAvailableDataMode(DateConf dateInfo) {
        return Objects.nonNull(dateInfo) && DateConf.DateMode.AVAILABLE == dateInfo.getDateMode();
    }

    public String hasDataModeStr(ItemDateResp dateDate, DateConf dateInfo) {
        if (Objects.isNull(dateDate) || StringUtils.isEmpty((CharSequence)dateDate.getStartDate()) || StringUtils.isEmpty((CharSequence)dateDate.getStartDate())) {
            return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateCol, dateInfo.getStartDate(), this.sysDateCol, dateInfo.getEndDate());
        }
        log.info("dateDate:{}", (Object)dateDate);
        String dateFormatStr = dateDate.getDateFormat();
        if (StringUtils.isEmpty((CharSequence)dateFormatStr)) {
            dateFormatStr = "yyyy-MM-dd";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatStr);
        LocalDate endData = LocalDate.parse(dateDate.getEndDate(), formatter);
        LocalDate endReq = LocalDate.parse(dateInfo.getEndDate(), formatter);
        if (endReq.isAfter(endData)) {
            if ("DAY".equalsIgnoreCase(dateInfo.getPeriod())) {
                Long unit = this.getInterval(dateInfo.getStartDate(), dateInfo.getEndDate(), dateFormatStr, ChronoUnit.DAYS);
                LocalDate dateMax = endData;
                LocalDate dateMin = dateMax.minusDays(unit - 1L);
                return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateCol, dateMin, this.sysDateCol, dateMax);
            }
            if ("MONTH".equalsIgnoreCase(dateInfo.getPeriod())) {
                Long unit = this.getInterval(dateInfo.getStartDate(), dateInfo.getEndDate(), dateFormatStr, ChronoUnit.MONTHS);
                return this.generateMonthSql(endData, unit, dateFormatStr);
            }
        }
        return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateCol, dateInfo.getStartDate(), this.sysDateCol, dateInfo.getEndDate());
    }

    public String generateMonthSql(LocalDate endData, Long unit, String dateFormatStr) {
        LocalDate dateMax = endData;
        List<String> months = this.generateMonthStr(dateMax, unit, dateFormatStr);
        if (!CollectionUtils.isEmpty(months)) {
            StringJoiner joiner = new StringJoiner(",");
            months.stream().forEach(month -> joiner.add("'" + month + "'"));
            return String.format("(%s in (%s))", this.sysDateCol, joiner.toString());
        }
        return "";
    }

    private List<String> generateMonthStr(LocalDate dateMax, Long unit, String formatStr) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern(formatStr);
        ArrayList<String> months = new ArrayList<String>();
        for (int i = unit.intValue() - 1; i >= 0; --i) {
            LocalDate tmp = dateMax.minusMonths(i);
            months.add(tmp.with(TemporalAdjusters.firstDayOfMonth()).format(format));
        }
        return months;
    }

    public String recentDayStr(ItemDateResp dateDate, DateConf dateInfo) {
        ImmutablePair<String, String> dayRange = this.recentDay(dateDate, dateInfo);
        return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateCol, dayRange.left, this.sysDateCol, dayRange.right);
    }

    public ImmutablePair<String, String> recentDay(ItemDateResp dateDate, DateConf dateInfo) {
        String dateFormatStr = dateDate.getDateFormat();
        if (StringUtils.isEmpty((CharSequence)dateFormatStr)) {
            dateFormatStr = "yyyy-MM-dd";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatStr);
        LocalDate end = LocalDate.parse(dateDate.getEndDate(), formatter);
        Integer unit = dateInfo.getUnit() - 1;
        String start = end.minusDays(unit.intValue()).format(formatter);
        return ImmutablePair.of((Object)start, (Object)dateDate.getEndDate());
    }

    public String recentMonthStr(LocalDate endData, Long unit, String dateFormatStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatStr);
        String endStr = endData.format(formatter);
        String start = endData.minusMonths(unit).format(formatter);
        return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateMonthCol, start, this.sysDateMonthCol, endStr);
    }

    public String recentMonthStr(ItemDateResp dateDate, DateConf dateInfo) {
        List<ImmutablePair<String, String>> range = this.recentMonth(dateDate, dateInfo);
        if (range.size() == 1) {
            return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateMonthCol, range.get((int)0).left, this.sysDateMonthCol, range.get((int)0).right);
        }
        if (range.size() > 0) {
            StringJoiner joiner = new StringJoiner(",");
            range.stream().forEach(month -> joiner.add("'" + (String)month.left + "'"));
            return String.format("(%s in (%s))", this.sysDateCol, joiner.toString());
        }
        return "";
    }

    public List<ImmutablePair<String, String>> recentMonth(ItemDateResp dateDate, DateConf dateInfo) {
        Long unit;
        LocalDate dateMax;
        List<String> months;
        LocalDate endData = LocalDate.parse(dateDate.getEndDate(), DateTimeFormatter.ofPattern(dateDate.getDateFormat()));
        ArrayList<ImmutablePair<String, String>> ret = new ArrayList<ImmutablePair<String, String>>();
        if (dateDate.getDatePeriod() != null && "MONTH".equalsIgnoreCase(dateDate.getDatePeriod()) && !CollectionUtils.isEmpty(months = this.generateMonthStr(dateMax = endData, unit = this.getInterval(dateInfo.getStartDate(), dateInfo.getEndDate(), dateDate.getDateFormat(), ChronoUnit.MONTHS), dateDate.getDateFormat()))) {
            months.stream().forEach(m -> ret.add(ImmutablePair.of((Object)m, (Object)m)));
            return ret;
        }
        String dateFormatStr = "yyyy-MM";
        Integer unit2 = dateInfo.getUnit() - 1;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatStr);
        String endStr = endData.format(formatter);
        String start = endData.minusMonths(unit2.intValue()).format(formatter);
        ret.add(ImmutablePair.of((Object)start, (Object)endStr));
        return ret;
    }

    public String recentWeekStr(LocalDate endData, Long unit) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String start = endData.minusDays(unit * 7L).format(formatter);
        return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateWeekCol, start, this.sysDateWeekCol, endData.format(formatter));
    }

    public String recentWeekStr(ItemDateResp dateDate, DateConf dateInfo) {
        ImmutablePair<String, String> dayRange = this.recentWeek(dateDate, dateInfo);
        return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateWeekCol, dayRange.left, this.sysDateWeekCol, dayRange.right);
    }

    public ImmutablePair<String, String> recentWeek(ItemDateResp dateDate, DateConf dateInfo) {
        String dateFormatStr = dateDate.getDateFormat();
        if (StringUtils.isEmpty((CharSequence)dateFormatStr)) {
            dateFormatStr = "yyyy-MM-dd";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatStr);
        LocalDate end = LocalDate.parse(dateDate.getEndDate(), formatter);
        Integer unit = dateInfo.getUnit() - 1;
        String start = end.minusDays(unit * 7).format(formatter);
        return ImmutablePair.of((Object)start, (Object)end.format(formatter));
    }

    private Long getInterval(String startDate, String endDate, String dateFormat, ChronoUnit chronoUnit) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        try {
            LocalDate start = LocalDate.parse(startDate, formatter);
            LocalDate end = LocalDate.parse(endDate, formatter);
            return start.until(end, chronoUnit) + 1L;
        }
        catch (Exception e) {
            log.warn("e:{}", (Throwable)e);
            return -1L;
        }
    }

    public String recentDateStr(ItemDateResp dateDate, DateConf dateInfo) {
        if (Objects.isNull(dateDate)) {
            return "";
        }
        if ("DAY".equalsIgnoreCase(dateInfo.getPeriod())) {
            return this.recentDayStr(dateDate, dateInfo);
        }
        if ("MONTH".equalsIgnoreCase(dateInfo.getPeriod())) {
            return this.recentMonthStr(dateDate, dateInfo);
        }
        if ("WEEK".equalsIgnoreCase(dateInfo.getPeriod())) {
            return this.recentWeekStr(dateDate, dateInfo);
        }
        return "";
    }

    public String betweenDateStr(ItemDateResp dateDate, DateConf dateInfo) {
        if ("MONTH".equalsIgnoreCase(dateInfo.getPeriod())) {
            if (!dateInfo.getStartDate().contains("-")) {
                return String.format("%s >= '%s' and %s <= '%s'", this.sysDateMonthCol, dateInfo.getStartDate(), this.sysDateMonthCol, dateInfo.getEndDate());
            }
            LocalDate endData = LocalDate.parse(dateInfo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate startData = LocalDate.parse(dateInfo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
            return String.format("%s >= '%s' and %s <= '%s'", this.sysDateMonthCol, startData.format(formatter), this.sysDateMonthCol, endData.format(formatter));
        }
        if ("WEEK".equalsIgnoreCase(dateInfo.getPeriod())) {
            return String.format("%s >= '%s' and %s <= '%s'", this.sysDateWeekCol, dateInfo.getStartDate(), this.sysDateWeekCol, dateInfo.getEndDate());
        }
        return String.format("%s >= '%s' and %s <= '%s'", this.sysDateCol, dateInfo.getStartDate(), this.sysDateCol, dateInfo.getEndDate());
    }

    public String listDateStr(ItemDateResp dateDate, DateConf dateInfo) {
        StringJoiner joiner = new StringJoiner(",");
        dateInfo.getDateList().stream().forEach(date -> joiner.add("'" + date + "'"));
        String dateCol = this.sysDateCol;
        if ("MONTH".equalsIgnoreCase(dateInfo.getPeriod())) {
            dateCol = this.sysDateMonthCol;
        }
        if ("WEEK".equalsIgnoreCase(dateInfo.getPeriod())) {
            dateCol = this.sysDateWeekCol;
        }
        return String.format("(%s in (%s))", dateCol, joiner.toString());
    }

    public String defaultRecentDateInfo(DateConf dateInfo) {
        if (Objects.isNull(dateInfo)) {
            return "";
        }
        Integer unit = dateInfo.getUnit();
        if ("DAY".equalsIgnoreCase(dateInfo.getPeriod())) {
            LocalDate dateMax = LocalDate.now().minusDays(1L);
            LocalDate dateMin = dateMax.minusDays(unit - 1);
            return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateCol, dateMin, this.sysDateCol, dateMax);
        }
        if ("WEEK".equalsIgnoreCase(dateInfo.getPeriod())) {
            LocalDate dateMax = LocalDate.now().minusDays(1L);
            return this.recentWeekStr(dateMax, unit.longValue());
        }
        if ("MONTH".equalsIgnoreCase(dateInfo.getPeriod())) {
            LocalDate dateMax = LocalDate.now().minusDays(1L);
            return this.recentMonthStr(dateMax, unit.longValue(), "yyyy-MM");
        }
        if ("YEAR".equalsIgnoreCase(dateInfo.getPeriod())) {
            LocalDate dateMax = LocalDate.now().minusDays(1L);
            return this.recentMonthStr(dateMax, unit.longValue() * 12L, "yyyy-MM");
        }
        return String.format("(%s >= '%s' and %s <= '%s')", this.sysDateCol, LocalDate.now().minusDays(2L), this.sysDateCol, LocalDate.now().minusDays(1L));
    }

    public String getDateWhereStr(DateConf dateInfo) {
        ItemDateResp dateDate = null;
        return this.getDateWhereStr(dateInfo, dateDate);
    }

    public String getDateWhereStr(DateConf dateInfo, ItemDateResp dateDate) {
        if (Objects.isNull(dateInfo)) {
            return "";
        }
        String dateStr = "";
        switch (dateInfo.getDateMode()) {
            case BETWEEN: {
                dateStr = this.betweenDateStr(dateDate, dateInfo);
                break;
            }
            case LIST: {
                dateStr = this.listDateStr(dateDate, dateInfo);
                break;
            }
            case RECENT: {
                dateStr = this.recentDateStr(dateDate, dateInfo);
                break;
            }
            case AVAILABLE: {
                dateStr = this.hasDataModeStr(dateDate, dateInfo);
                break;
            }
        }
        return dateStr;
    }

    public String getDateWhereStr(DateConf dateConf, ImmutablePair<String, String> range) {
        if ("DAY".equalsIgnoreCase(dateConf.getPeriod()) || "WEEK".equalsIgnoreCase(dateConf.getPeriod())) {
            if (((String)range.left).equals(range.right)) {
                return String.format("(%s <= '%s' and %s > '%s')", this.sysZipperDateColBegin + this.sysDateCol, range.left, this.sysZipperDateColEnd + this.sysDateCol, range.left);
            }
            return String.format("( '%s' <= %s and '%s' >= %s)", range.left, this.sysZipperDateColEnd + this.sysDateCol, range.right, this.sysZipperDateColBegin + this.sysDateCol);
        }
        if ("MONTH".equalsIgnoreCase(dateConf.getPeriod())) {
            if (((String)range.left).equals(range.right)) {
                return String.format("(%s <= '%s' and %s > '%s')", this.sysZipperDateColBegin + this.sysDateMonthCol, range.left, this.sysZipperDateColEnd + this.sysDateMonthCol, range.left);
            }
            return String.format("( '%s' <= %s and '%s' >= %s)", range.left, this.sysZipperDateColEnd + this.sysDateMonthCol, range.right, this.sysZipperDateColBegin + this.sysDateMonthCol);
        }
        return "";
    }

    public String getSysDateCol(DateConf dateInfo) {
        if ("DAY".equalsIgnoreCase(dateInfo.getPeriod())) {
            return this.sysDateCol;
        }
        if ("WEEK".equalsIgnoreCase(dateInfo.getPeriod())) {
            return this.sysDateWeekCol;
        }
        if ("MONTH".equalsIgnoreCase(dateInfo.getPeriod())) {
            return this.sysDateMonthCol;
        }
        return "";
    }

    public boolean isDateStr(String date) {
        return Pattern.matches("[\\d\\s-:]+", date);
    }

    public String getPeriodByCol(String col) {
        if (this.sysDateCol.equalsIgnoreCase(col)) {
            return "DAY";
        }
        if (this.sysDateWeekCol.equalsIgnoreCase(col)) {
            return "WEEK";
        }
        if (this.sysDateMonthCol.equalsIgnoreCase(col)) {
            return "MONTH";
        }
        return "";
    }

    public String getDateColBegin(DateConf dateInfo) {
        return this.sysZipperDateColBegin + this.getSysDateCol(dateInfo);
    }

    public String getDateColEnd(DateConf dateInfo) {
        return this.sysZipperDateColEnd + this.getSysDateCol(dateInfo);
    }

    public List<String> getDateCol() {
        return Arrays.asList(this.sysDateCol, this.sysDateMonthCol, this.sysDateWeekCol);
    }

    public String getSysDateCol() {
        return this.sysDateCol;
    }

    public String getSysDateMonthCol() {
        return this.sysDateMonthCol;
    }

    public String getSysDateWeekCol() {
        return this.sysDateWeekCol;
    }

    public String getSysZipperDateColBegin() {
        return this.sysZipperDateColBegin;
    }

    public String getSysZipperDateColEnd() {
        return this.sysZipperDateColEnd;
    }

    public void setSysDateCol(String sysDateCol) {
        this.sysDateCol = sysDateCol;
    }

    public void setSysDateMonthCol(String sysDateMonthCol) {
        this.sysDateMonthCol = sysDateMonthCol;
    }

    public void setSysDateWeekCol(String sysDateWeekCol) {
        this.sysDateWeekCol = sysDateWeekCol;
    }

    public void setSysZipperDateColBegin(String sysZipperDateColBegin) {
        this.sysZipperDateColBegin = sysZipperDateColBegin;
    }

    public void setSysZipperDateColEnd(String sysZipperDateColEnd) {
        this.sysZipperDateColEnd = sysZipperDateColEnd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateModeUtils)) {
            return false;
        }
        DateModeUtils other = (DateModeUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sysDateCol = this.getSysDateCol();
        String other$sysDateCol = other.getSysDateCol();
        if (this$sysDateCol == null ? other$sysDateCol != null : !this$sysDateCol.equals(other$sysDateCol)) {
            return false;
        }
        String this$sysDateMonthCol = this.getSysDateMonthCol();
        String other$sysDateMonthCol = other.getSysDateMonthCol();
        if (this$sysDateMonthCol == null ? other$sysDateMonthCol != null : !this$sysDateMonthCol.equals(other$sysDateMonthCol)) {
            return false;
        }
        String this$sysDateWeekCol = this.getSysDateWeekCol();
        String other$sysDateWeekCol = other.getSysDateWeekCol();
        if (this$sysDateWeekCol == null ? other$sysDateWeekCol != null : !this$sysDateWeekCol.equals(other$sysDateWeekCol)) {
            return false;
        }
        String this$sysZipperDateColBegin = this.getSysZipperDateColBegin();
        String other$sysZipperDateColBegin = other.getSysZipperDateColBegin();
        if (this$sysZipperDateColBegin == null ? other$sysZipperDateColBegin != null : !this$sysZipperDateColBegin.equals(other$sysZipperDateColBegin)) {
            return false;
        }
        String this$sysZipperDateColEnd = this.getSysZipperDateColEnd();
        String other$sysZipperDateColEnd = other.getSysZipperDateColEnd();
        return !(this$sysZipperDateColEnd == null ? other$sysZipperDateColEnd != null : !this$sysZipperDateColEnd.equals(other$sysZipperDateColEnd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DateModeUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sysDateCol = this.getSysDateCol();
        result = result * 59 + ($sysDateCol == null ? 43 : $sysDateCol.hashCode());
        String $sysDateMonthCol = this.getSysDateMonthCol();
        result = result * 59 + ($sysDateMonthCol == null ? 43 : $sysDateMonthCol.hashCode());
        String $sysDateWeekCol = this.getSysDateWeekCol();
        result = result * 59 + ($sysDateWeekCol == null ? 43 : $sysDateWeekCol.hashCode());
        String $sysZipperDateColBegin = this.getSysZipperDateColBegin();
        result = result * 59 + ($sysZipperDateColBegin == null ? 43 : $sysZipperDateColBegin.hashCode());
        String $sysZipperDateColEnd = this.getSysZipperDateColEnd();
        result = result * 59 + ($sysZipperDateColEnd == null ? 43 : $sysZipperDateColEnd.hashCode());
        return result;
    }

    public String toString() {
        return "DateModeUtils(sysDateCol=" + this.getSysDateCol() + ", sysDateMonthCol=" + this.getSysDateMonthCol() + ", sysDateWeekCol=" + this.getSysDateWeekCol() + ", sysZipperDateColBegin=" + this.getSysZipperDateColBegin() + ", sysZipperDateColEnd=" + this.getSysZipperDateColEnd() + ")";
    }
}

