/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.pojo.enums.DatePeriodEnum;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT = "yyyyMMddHHmmss";

    public static Integer currentYear() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String time = dateFormat.format(date).replaceAll("-", "");
        int year = Integer.parseInt(time.substring(0, 4));
        return year;
    }

    public static DateTimeFormatter getDateFormatter(String date, String[] formats) {
        for (int i = 0; i < formats.length; ++i) {
            String format = formats[i];
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            try {
                dateFormat.parse(date);
                return DateTimeFormatter.ofPattern(format);
            }
            catch (Exception e) {
                log.info("date parse has a exception:{}", (Object)e.toString());
                continue;
            }
        }
        return DateTimeFormatter.ofPattern(formats[0]);
    }

    public static DateTimeFormatter getTimeFormatter(String date, String[] formats) {
        for (int i = 0; i < formats.length; ++i) {
            String format = formats[i];
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                LocalDateTime.parse(date, dateTimeFormatter);
                return dateTimeFormatter;
            }
            catch (Exception e) {
                log.info("date parse has a exception:{}", (Object)e.toString());
                continue;
            }
        }
        return DateTimeFormatter.ofPattern(formats[0]);
    }

    public static String getBeforeDate(int intervalDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -intervalDay);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        return dateFormat.format(calendar.getTime());
    }

    public static String getBeforeDate(int intervalDay, DatePeriodEnum datePeriodEnum) {
        if (Objects.isNull((Object)datePeriodEnum)) {
            return DateUtils.getBeforeDate(intervalDay);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String currentDate = dateFormat.format(new Date());
        return DateUtils.getBeforeDate(currentDate, intervalDay, datePeriodEnum);
    }

    public static String getBeforeDate(String date, int intervalDay, DatePeriodEnum datePeriodEnum) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        LocalDate currentDate = LocalDate.parse(date, dateTimeFormatter);
        LocalDate result = null;
        switch (datePeriodEnum) {
            case DAY: {
                result = currentDate.minusDays(intervalDay);
                break;
            }
            case WEEK: {
                result = currentDate.minusWeeks(intervalDay);
                if (intervalDay != 0) break;
                result = result.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                break;
            }
            case MONTH: {
                result = currentDate.minusMonths(intervalDay);
                if (intervalDay != 0) break;
                result = result.with(TemporalAdjusters.firstDayOfMonth());
                break;
            }
            case QUARTER: {
                result = currentDate.minusMonths((long)intervalDay * 3L);
                if (intervalDay != 0) break;
                TemporalAdjuster firstDayOfQuarter = temporal -> {
                    LocalDate tempDate = LocalDate.from(temporal);
                    int month = tempDate.get(ChronoField.MONTH_OF_YEAR);
                    int firstMonthOfQuarter = (month - 1) / 3 * 3 + 1;
                    return tempDate.with(ChronoField.MONTH_OF_YEAR, firstMonthOfQuarter).with(TemporalAdjusters.firstDayOfMonth());
                };
                result = result.with(firstDayOfQuarter);
                break;
            }
            case YEAR: {
                result = currentDate.minusYears(intervalDay);
                if (intervalDay != 0) break;
                result = result.with(TemporalAdjusters.firstDayOfYear());
                break;
            }
        }
        if (Objects.nonNull(result)) {
            return result.format(DateTimeFormatter.ofPattern(DATE_FORMAT));
        }
        return null;
    }

    public static String format(Date date) {
        SimpleDateFormat dateFormat = DateUtils.containsTime(date) ? new SimpleDateFormat(TIME_FORMAT) : new SimpleDateFormat(DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    private static boolean containsTime(Date date) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        String timeString = timeFormat.format(date);
        return !timeString.equals("00:00:00");
    }

    public static List<String> getDateList(String startDateStr, String endDateStr, String period) {
        try {
            LocalDate startDate = LocalDate.parse(startDateStr);
            LocalDate endDate = LocalDate.parse(endDateStr);
            ArrayList<String> datesInRange = new ArrayList<String>();
            LocalDate currentDate = startDate;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
            while (!currentDate.isAfter(endDate)) {
                if ("MONTH".equals(period)) {
                    datesInRange.add(currentDate.format(formatter));
                    currentDate = currentDate.plusMonths(1L);
                    continue;
                }
                if ("WEEK".equals(period)) {
                    datesInRange.add(currentDate.format(DateTimeFormatter.ISO_DATE));
                    currentDate = currentDate.plusWeeks(1L);
                    continue;
                }
                datesInRange.add(currentDate.format(DateTimeFormatter.ISO_DATE));
                currentDate = currentDate.plusDays(1L);
            }
            return datesInRange;
        }
        catch (Exception e) {
            log.info("parse date failed, startDate:{}, endDate:{}", new Object[]{startDateStr, endDateStr, e});
            return Lists.newArrayList();
        }
    }

    public static boolean isAnyDateString(String value) {
        List<String> formats = Arrays.asList(DATE_FORMAT, "yyyy-MM", "yyyy/MM/dd");
        return DateUtils.isAnyDateString(value, formats);
    }

    public static boolean isAnyDateString(String value, List<String> formats) {
        for (String format : formats) {
            if (!DateUtils.isDateString(value, format)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateString(String value, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            LocalDate.parse(value, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }
}

