/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);
    private static final int RETRY_NUM = 3;

    public static <T> T exec(Supplier<T> supplier) {
        return RetryUtils.exec(supplier, 3);
    }

    public static <T> T exec(Supplier<T> supplier, int retryNum) {
        T result = null;
        for (int index = 1; index <= retryNum; ++index) {
            try {
                result = supplier.get();
                break;
            }
            catch (Exception ex) {
                if (index < retryNum) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        log.error("e", (Throwable)e);
                    }
                } else {
                    log.warn("Retry {} times all fail, err: {}", (Object)retryNum, (Object)ex.getMessage());
                    throw ex;
                }
                log.warn("Retry exec {}, {}", (Object)index, (Object)ex.getMessage());
                continue;
            }
        }
        return result;
    }
}

