/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.tencent.supersonic.common.pojo.Pair;
import org.apache.commons.codec.digest.DigestUtils;

public class SignatureUtils {
    private static final long TIME_OUT = 1800000L;

    public static String generateSignature(String appSecret, long timestamp) {
        String psw = timestamp + appSecret + timestamp;
        return DigestUtils.sha1Hex((String)psw);
    }

    public static Pair<Boolean, String> isValidSignature(String appKey, String appSecret, long timestamp, String signatureToCheck) {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < timestamp) {
            return new Pair<Boolean, String>(false, "Timestamp is in the future");
        }
        if (currentTimeMillis - timestamp > 1800000L) {
            return new Pair<Boolean, String>(false, "Timestamp is too old");
        }
        String generatedSignature = SignatureUtils.generateSignature(appSecret, timestamp);
        if (generatedSignature.equals(signatureToCheck)) {
            return new Pair<Boolean, String>(true, "Signature is valid");
        }
        return new Pair<Boolean, String>(false, "Invalid signature");
    }

    public static void main(String[] args) throws InterruptedException {
        String appSecret = "38f2857c-d9ee-4c3a-bcc2-2cdb62fda5aa";
        long timestamp = 1706504908126L;
        System.out.println("timeStamp:" + timestamp);
        String serverSignature = SignatureUtils.generateSignature(appSecret, timestamp);
        System.out.println("Server Signature: " + serverSignature);
        Pair<Boolean, String> isValid = SignatureUtils.isValidSignature("1", appSecret, timestamp, serverSignature);
        System.out.println("Is Signature Valid? " + isValid.first);
    }
}

