/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    public static final String COMMA_WRAPPER = "'%s'";
    public static final String SPACE_WRAPPER = " %s ";

    public static String getCommaWrap(String value) {
        return String.format(COMMA_WRAPPER, value);
    }

    public static String getSpaceWrap(String value) {
        return String.format(SPACE_WRAPPER, value);
    }

    public static String formatSqlQuota(String where) {
        if (StringUtils.isEmpty((CharSequence)where)) {
            return where;
        }
        return where.replace("\"", "\\\\\"");
    }

    public static int compareVersion(String v1, String v2) {
        String[] v1s = v1.split("\\.");
        String[] v2s = v2.split("\\.");
        int length = Math.min(v1s.length, v2s.length);
        for (int i = 0; i < length; ++i) {
            Integer vv2;
            Integer vv1 = Integer.parseInt(v1s[i]);
            int compare = vv1.compareTo(vv2 = Integer.valueOf(Integer.parseInt(v2s[i])));
            if (compare == 0) continue;
            return compare;
        }
        return v1s.length - v2s.length;
    }

    public static String replaceBackticks(String sql) {
        return sql.replaceAll("`", "");
    }
}

