/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.tencent.supersonic.common.util.TraceIdUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public class ThreadMdcUtil {
    public static void setTraceIdIfAbsent() {
        if (MDC.get((String)"traceId") == null) {
            MDC.put((String)"traceId", (String)TraceIdUtil.generateTraceId());
        }
    }

    public static <T> Callable<T> wrap(Callable<T> callable, Map<String, String> context) {
        return () -> {
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            ThreadMdcUtil.setTraceIdIfAbsent();
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        };
    }

    public static Runnable wrap(Runnable runnable, Map<String, String> context) {
        return () -> {
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            ThreadMdcUtil.setTraceIdIfAbsent();
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }
}

