/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.common.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlUtils {
    private static final Logger log = LoggerFactory.getLogger(YamlUtils.class);

    public static <T> T toObject(String yamlStr, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.findAndRegisterModules();
        try {
            return (T)mapper.readValue(yamlStr, clazz);
        }
        catch (JsonProcessingException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static String toYaml(Object object) {
        YAMLMapper mapper = new YAMLMapper();
        mapper.findAndRegisterModules();
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE);
        try {
            String yaml = mapper.writeValueAsString(object);
            return yaml.replaceAll("\"True\"", "true").replaceAll("\"true\"", "true").replaceAll("\"false\"", "false").replaceAll("\"False\"", "false");
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static String toYamlWithoutNull(Object object) {
        String jsonStr = JSONObject.toJSONString((Object)object);
        if (object instanceof List) {
            return YamlUtils.toYaml(JSONObject.parseObject((String)jsonStr, List.class, (Feature[])new Feature[]{Feature.OrderedField}));
        }
        return YamlUtils.toYaml(JSONObject.parseObject((String)jsonStr, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField}));
    }

    public static String json2Yaml(String jsonStr) throws JsonProcessingException {
        JsonNode jsonNode = new ObjectMapper().readTree(jsonStr);
        return new YAMLMapper().writeValueAsString((Object)jsonNode);
    }
}

