/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.chroma.spring;

import com.tencent.supersonic.common.config.EmbeddingStoreConfig;
import dev.langchain4j.chroma.spring.EmbeddingStoreProperties;
import dev.langchain4j.chroma.spring.Properties;
import dev.langchain4j.store.embedding.BaseEmbeddingStoreFactory;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.chroma.ChromaEmbeddingStore;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ChromaEmbeddingStoreFactory
extends BaseEmbeddingStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(ChromaEmbeddingStoreFactory.class);
    private Properties properties;

    public ChromaEmbeddingStoreFactory(EmbeddingStoreConfig storeConfig) {
        this(ChromaEmbeddingStoreFactory.createPropertiesFromConfig(storeConfig));
    }

    public ChromaEmbeddingStoreFactory(Properties properties) {
        this.properties = properties;
    }

    public EmbeddingStore createEmbeddingStore(String collectionName) {
        EmbeddingStoreProperties storeProperties = this.properties.getEmbeddingStore();
        return ChromaEmbeddingStore.builder().baseUrl(storeProperties.getBaseUrl()).collectionName(collectionName).timeout(storeProperties.getTimeout()).build();
    }

    private static Properties createPropertiesFromConfig(EmbeddingStoreConfig storeConfig) {
        Properties properties = new Properties();
        EmbeddingStoreProperties embeddingStore = new EmbeddingStoreProperties();
        BeanUtils.copyProperties((Object)storeConfig, (Object)embeddingStore);
        embeddingStore.setTimeout(Duration.ofSeconds(storeConfig.getTimeOut()));
        properties.setEmbeddingStore(embeddingStore);
        return properties;
    }
}

