/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.inmemory.spring;

import dev.langchain4j.inmemory.spring.EmbeddingModelProperties;
import dev.langchain4j.inmemory.spring.InMemoryEmbeddingStoreFactory;
import dev.langchain4j.inmemory.spring.Properties;
import dev.langchain4j.model.embedding.AllMiniLmL6V2QuantizedEmbeddingModel;
import dev.langchain4j.model.embedding.BgeSmallZhEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.S2OnnxEmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStoreFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Properties.class})
public class InMemoryAutoConfig {
    public static final String BGE_SMALL_ZH = "bge-small-zh";
    public static final String ALL_MINILM_L6_V2 = "all-minilm-l6-v2-q";

    @Bean
    @ConditionalOnProperty(value={"langchain4j.in-memory.embedding-store.persist-path"})
    EmbeddingStoreFactory inMemoryChatModel(Properties properties) {
        return new InMemoryEmbeddingStoreFactory(properties);
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.in-memory.embedding-model.model-name"})
    EmbeddingModel inMemoryEmbeddingModel(Properties properties) {
        EmbeddingModelProperties embeddingModelProperties = properties.getEmbeddingModel();
        String modelPath = embeddingModelProperties.getModelPath();
        String vocabularyPath = embeddingModelProperties.getVocabularyPath();
        if (StringUtils.isNotBlank((CharSequence)modelPath) && StringUtils.isNotBlank((CharSequence)vocabularyPath)) {
            return new S2OnnxEmbeddingModel(modelPath, vocabularyPath);
        }
        String modelName = embeddingModelProperties.getModelName();
        if (BGE_SMALL_ZH.equalsIgnoreCase(modelName)) {
            return new BgeSmallZhEmbeddingModel();
        }
        if (ALL_MINILM_L6_V2.equalsIgnoreCase(modelName)) {
            return new AllMiniLmL6V2QuantizedEmbeddingModel();
        }
        return new BgeSmallZhEmbeddingModel();
    }
}

